/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tiles;

import com.direwolf20.buildinggadgets.client.renderer.SphereSegmentation;
import com.direwolf20.buildinggadgets.common.capability.CappedEnergyStorage;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.containers.ChargingStationContainer;
import com.direwolf20.buildinggadgets.common.items.ChargingStationItem;
import com.direwolf20.buildinggadgets.common.registry.OurBlocks;
import com.direwolf20.buildinggadgets.common.util.exceptions.CapabilityNotPresentException;
import com.direwolf20.buildinggadgets.common.util.tools.CapabilityUtil;
import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ChargingStationTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int SIZE = 2;
    private static final int FUEL_SLOT = 0;
    private static final int CHARGE_SLOT = 1;
    private static final int UPDATE_FLAG_INVENTORY = 2;
    private static final int UPDATE_FLAG_ENERGY = 1;
    private static final int UPDATE_FLAG_ALL = 3;
    private final int SEND_UPDATE_NO_RENDER = 6;
    private int updateNeeded = 3;
    private int counter = 0;
    private int maxBurn = 0;
    private final ChargingStationEnergyStorage energy = new ChargingStationEnergyStorage();
    private final ItemStackHandler itemStackHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            ChargingStationTileEntity.this.func_70296_d();
            ChargingStationTileEntity.this.updateNeeded = ChargingStationTileEntity.this.updateNeeded | 2;
            if (ChargingStationTileEntity.this.func_145831_w() != null && !ChargingStationTileEntity.this.func_145831_w().func_201670_d()) {
                ChargingStationTileEntity.this.func_145831_w().func_184138_a(ChargingStationTileEntity.this.func_174877_v(), ChargingStationTileEntity.this.func_195044_w(), ChargingStationTileEntity.this.func_195044_w(), 6);
            }
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot == 0 && stack.func_77973_b() == Items.field_151133_ar) {
                return super.insertItem(slot, stack, simulate);
            }
            if (slot == 0 && ForgeHooks.getBurnTime((ItemStack)stack) <= 0) {
                return stack;
            }
            if (!(slot != 1 || stack.getCapability(CapabilityEnergy.ENERGY).isPresent() && this.getStackInSlot(slot).func_190916_E() <= 0)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(this::getEnergy);
    private LazyOptional<IItemHandler> itemCap = LazyOptional.of(this::getItemStackHandler);
    private int renderCounter = 0;
    private double lightningX = 0.0;
    private double lightningZ = 0.0;
    private SphereSegmentation lastSegmentation = SphereSegmentation.LOW_SEGMENTATION;
    private float lastChargeFactor = 0.0f;
    private int callList = 0;
    private int lightningPositionChange = 20;

    public ChargingStationTileEntity() {
        super(OurBlocks.OurTileEntities.CHARGING_STATION_TYPE);
    }

    public void onInitEnergy(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ChargingStationItem) {
            stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(storage -> {
                ChargingStationEnergyStorage stationEnergy = this.getEnergy();
                stationEnergy.setEnergy(stationEnergy.getEnergyStored() + storage.extractEnergy(stationEnergy.getMaxEnergyStored() - stationEnergy.getEnergyStored(), false));
            });
        }
    }

    public void onStoreEnergy(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ChargingStationItem) {
            stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(storage -> {
                ChargingStationEnergyStorage stationEnergy = this.getEnergy();
                stationEnergy.setEnergy(stationEnergy.getEnergyStored() - storage.receiveEnergy(stationEnergy.getEnergyStored(), false));
            });
        }
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        Preconditions.checkArgument((this.func_145831_w() != null ? 1 : 0) != 0);
        return new ChargingStationContainer(i, this.func_145831_w(), this.field_174879_c, playerInventory, playerEntity);
    }

    @Nonnull
    private ChargingStationEnergyStorage getEnergy() {
        return this.energy;
    }

    @Nonnull
    private ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    private ItemStack getChargeStack() {
        return this.getItemStackHandler().getStackInSlot(1);
    }

    public ItemStack getFuelStack() {
        return this.getItemStackHandler().getStackInSlot(0);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        if (this.updateNeeded == 0) {
            return null;
        }
        CompoundNBT nbtTag = new CompoundNBT();
        nbtTag.func_74768_a("max_burn", this.maxBurn);
        if ((this.updateNeeded & 1) == 1) {
            this.writeEnergyNBT(nbtTag);
        }
        if ((this.updateNeeded & 2) == 2) {
            this.writeItemNBT(nbtTag);
        }
        SUpdateTileEntityPacket packet = new SUpdateTileEntityPacket(this.func_174877_v(), this.updateNeeded, nbtTag);
        this.updateNeeded = 0;
        return packet;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        CompoundNBT nbt = packet.func_148857_g();
        this.maxBurn = nbt.func_74762_e("max_burn");
        boolean causeReRender = false;
        if ((packet.func_148853_f() & 2) == 2) {
            this.readItemNBT(nbt);
            causeReRender = true;
        }
        if ((packet.func_148853_f() & 1) == 1) {
            this.readEnergyNBT(nbt);
        }
        if (this.func_145831_w() != null && causeReRender) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.readItemNBT(compound);
        this.readEnergyNBT(compound);
        this.maxBurn = compound.func_74762_e("max_burn");
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeItemNBT(compound);
        this.writeEnergyNBT(compound);
        compound.func_74768_a("max_burn", this.maxBurn);
        return super.func_189515_b(compound);
    }

    private void writeItemNBT(CompoundNBT compound) {
        compound.func_218657_a("items", (INBT)this.itemStackHandler.serializeNBT());
    }

    private void writeEnergyNBT(CompoundNBT compound) {
        compound.func_74768_a("energy", this.energy.getEnergyStored());
    }

    private void readItemNBT(CompoundNBT compound) {
        if (compound.func_74764_b("items")) {
            this.itemStackHandler.deserializeNBT(compound.func_74775_l("items"));
        }
    }

    private void readEnergyNBT(CompoundNBT compound) {
        if (compound.func_74764_b("energy")) {
            this.getEnergy().setEnergy(compound.func_74762_e("energy"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canInteractWith(PlayerEntity playerIn) {
        if (this.func_145837_r()) return false;
        Vec3d vec3d = new Vec3d((Vec3i)this.func_174877_v());
        if (!(playerIn.func_195048_a(vec3d.func_72441_c(0.5, 0.5, 0.5)) <= 64.0)) return false;
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemCap.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onChunkUnloaded() {
        this.itemCap.invalidate();
        this.energyCap.invalidate();
    }

    public void onLoad() {
        if (!this.itemCap.isPresent()) {
            this.itemCap = LazyOptional.of(this::getItemStackHandler);
        }
        if (!this.energyCap.isPresent()) {
            this.energyCap = LazyOptional.of(this::getEnergy);
        }
    }

    private void addEnergy(int amount) {
        this.energy.receiveEnergy(amount, false);
    }

    public ItemStack getRenderStack() {
        return this.getChargeStack();
    }

    public boolean isChargingItem(IEnergyStorage energy) {
        return this.getEnergy().getEnergyStored() > 0 && energy.receiveEnergy(this.getEnergy().getEnergyStored(), true) > 0;
    }

    public void func_73660_a() {
        if (this.func_145831_w() != null) {
            this.tryBurn();
            ItemStack stack = this.getChargeStack();
            if (!stack.func_190926_b()) {
                this.chargeItem(stack);
            }
        } else if (this.func_145831_w() != null) {
            this.tryBurn();
            ItemStack stack = this.getChargeStack();
            if (!stack.func_190926_b()) {
                this.chargeItem(stack);
                this.updateLightning();
            }
        }
        this.getEnergy().resetReceiveCap();
    }

    private void updateLightning() {
        assert (this.func_145831_w() != null);
        if (this.renderCounter % this.lightningPositionChange == 0) {
            this.lightningX = this.func_145831_w().func_201674_k().nextDouble() - 0.5;
            this.lightningZ = this.func_145831_w().func_201674_k().nextDouble() - 0.5;
            this.lightningPositionChange = this.func_145831_w().func_201674_k().nextInt(7) + 17;
        }
        ++this.renderCounter;
    }

    private void tryBurn() {
        boolean canInsertEnergy;
        assert (this.func_145831_w() != null);
        boolean bl = canInsertEnergy = this.getEnergy().receiveEnergy((Integer)Config.CHARGING_STATION.energyPerTick.get(), true) > 0;
        if (this.counter > 0 && canInsertEnergy) {
            this.burn();
        } else if (canInsertEnergy) {
            if (this.initBurn()) {
                this.burn();
            }
        } else {
            this.setLit(false);
        }
    }

    private void burn() {
        this.addEnergy((Integer)Config.CHARGING_STATION.energyPerTick.get());
        --this.counter;
        this.setLit(true);
        if (this.counter == 0) {
            this.maxBurn = 0;
            this.initBurn();
        }
    }

    private boolean initBurn() {
        ItemStack stack = this.getFuelStack();
        int burnTime = ForgeHooks.getBurnTime((ItemStack)stack);
        if (burnTime > 0) {
            Item fuelSlot = this.getItemStackHandler().getStackInSlot(0).func_77973_b();
            this.getItemStackHandler().extractItem(0, 1, false);
            if (fuelSlot instanceof BucketItem && fuelSlot != Items.field_151133_ar) {
                this.getItemStackHandler().insertItem(0, new ItemStack((IItemProvider)Items.field_151133_ar, 1), false);
            }
            this.maxBurn = this.counter = (int)Math.floor((double)burnTime / (Double)Config.CHARGING_STATION.fuelUsage.get());
            this.setLit(true);
            return true;
        }
        this.setLit(false);
        return false;
    }

    private void setLit(boolean lit) {
        if (this.func_145831_w() == null || this.func_145831_w().func_201670_d()) {
            return;
        }
        BlockState currentState = this.func_145831_w().func_180495_p(this.func_174877_v());
        if ((Boolean)currentState.func_177229_b((IProperty)AbstractFurnaceBlock.field_220091_b) != lit) {
            this.func_145831_w().func_180501_a(this.field_174879_c, (BlockState)currentState.func_206870_a((IProperty)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(lit)), 3);
        }
    }

    private void chargeItem(ItemStack stack) {
        CapabilityUtil.EnergyUtil.getCap((ICapabilityProvider)stack).ifPresent(chargingStorage -> {
            if (this.isChargingItem((IEnergyStorage)chargingStorage)) {
                this.getEnergy().setEnergy(this.getEnergy().getEnergyStored() - chargingStorage.receiveEnergy(Math.min(this.getEnergy().getEnergyStored(), (Integer)Config.CHARGING_STATION.chargePerTick.get()), false));
            }
        });
    }

    public int getRemainingBurn() {
        return this.counter;
    }

    public int getMaxBurn() {
        return this.maxBurn;
    }

    public double getLightningX() {
        return this.lightningX;
    }

    public double getLightningZ() {
        return this.lightningZ;
    }

    @Nonnull
    public SphereSegmentation getLastRenderedSegmentation() {
        return this.lastSegmentation;
    }

    public float getLastChargeFactor() {
        return this.lastChargeFactor;
    }

    public float getChargeFactor() {
        IEnergyStorage energy = (IEnergyStorage)this.getChargeStack().getCapability(CapabilityEnergy.ENERGY).orElseThrow(CapabilityNotPresentException::new);
        return (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored();
    }

    public void updateChargeFactor(float newFactor) {
        this.lastChargeFactor = newFactor;
    }

    public SphereSegmentation getSegmentation() {
        if (this.func_145831_w() == null || !this.func_145831_w().func_201670_d()) {
            return this.getLastRenderedSegmentation();
        }
        ClientPlayerEntity playerEntity = Minecraft.func_71410_x().field_71439_g;
        double dist = new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, 0.5, 0.5).func_72436_e(playerEntity.func_213303_ch());
        return SphereSegmentation.forSquareDist(dist);
    }

    public void updateSegmentation(@Nonnull SphereSegmentation segmentation) {
        this.lastSegmentation = Objects.requireNonNull(segmentation);
    }

    public int getCallList() {
        return this.callList;
    }

    public void genCallList() {
        this.callList = GlStateManager.genLists((int)1);
    }

    private final class ChargingStationEnergyStorage
    extends CappedEnergyStorage {
        public ChargingStationEnergyStorage() {
            super(() -> ((ForgeConfigSpec.IntValue)Config.CHARGING_STATION.capacity).get(), () -> ((ForgeConfigSpec.IntValue)Config.CHARGING_STATION.maxExtract).get(), () -> ((ForgeConfigSpec.IntValue)Config.CHARGING_STATION.maxRecieve).get());
        }

        @Override
        protected void writeEnergy() {
            ChargingStationTileEntity.this.func_70296_d();
            ChargingStationTileEntity.this.updateNeeded = ChargingStationTileEntity.this.updateNeeded | 1;
            if (ChargingStationTileEntity.this.func_145831_w() != null && !ChargingStationTileEntity.this.func_145831_w().func_201670_d()) {
                ChargingStationTileEntity.this.func_145831_w().func_184138_a(ChargingStationTileEntity.this.func_174877_v(), ChargingStationTileEntity.this.func_195044_w(), ChargingStationTileEntity.this.func_195044_w(), 6);
            }
        }

        @Override
        protected void updateEnergy() {
        }
    }
}

