/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.blocks;

import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.building.placement.IPositionPlacementSequence;
import com.direwolf20.buildinggadgets.common.building.placement.SetBackedPlacementSequence;
import com.direwolf20.buildinggadgets.common.util.exceptions.PaletteOverflowException;
import com.direwolf20.buildinggadgets.common.util.helpers.LambdaHelper;
import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.util.TriPredicate;
import org.apache.commons.lang3.tuple.Pair;

public class RegionSnapshot {
    private static final String DIMENSION = "dim";
    private static final String POSITIONS = "positions";
    private static final String BLOCK_FRAMES = "frames";
    private static final String BLOCK_PALETTES = "palettes";
    private static final String TILE_DATA = "block_snapshots";
    private static final String TILE_POS = "block_pos";
    private static final String TILE_NBT = "block_nbt";
    private IPositionPlacementSequence positions;
    private DimensionType dim;
    private List<Optional<BlockState>> blockStates;
    private List<Pair<BlockPos, CompoundNBT>> tileData;
    private CompoundNBT serializedForm;

    private static CompoundNBT serialize(CompoundNBT tag, RegionSnapshot snapshot) {
        tag.func_74778_a(DIMENSION, DimensionType.func_212678_a((DimensionType)snapshot.dim).toString());
        tag.func_218657_a(POSITIONS, (INBT)Objects.requireNonNull(NBTHelper.writeIterable(snapshot.positions, NBTUtil::func_186859_a)));
        tag.func_218657_a("area", (INBT)snapshot.positions.getBoundingBox().serialize());
        ListNBT palettes = new ListNBT();
        Object2IntOpenHashMap mapPalettes = new Object2IntOpenHashMap();
        mapPalettes.put(null, 0);
        HashSet<BlockState> recordedPalettes = new HashSet<BlockState>();
        IntArrayList frames = new IntArrayList();
        if (snapshot.blockStates.size() == 0) {
            return new CompoundNBT();
        }
        Optional<BlockState> lastStreak = snapshot.blockStates.get(0);
        int streak = 0;
        for (Optional<BlockState> state : snapshot.blockStates) {
            BlockState nonnullState;
            if (state.isPresent() && !recordedPalettes.contains(nonnullState = state.get())) {
                recordedPalettes.add(nonnullState);
                mapPalettes.put((Object)nonnullState, mapPalettes.size());
                palettes.add((Object)NBTUtil.func_190009_a((BlockState)nonnullState));
            }
            if (state.equals(lastStreak) && streak < 256) {
                ++streak;
                continue;
            }
            frames.add((streak - 1 & 0xFF) << 24 | mapPalettes.getInt(lastStreak.orElse(null)) & 0xFFFFFF);
            streak = 1;
            lastStreak = state;
        }
        frames.add((streak - 1 & 0xFF) << 24 | mapPalettes.getInt(lastStreak.orElse(null)) & 0xFFFFFF);
        tag.func_74783_a(BLOCK_FRAMES, frames.toIntArray());
        tag.func_218657_a(BLOCK_PALETTES, (INBT)palettes);
        ListNBT tileData = new ListNBT();
        for (Pair<BlockPos, CompoundNBT> data : snapshot.tileData) {
            CompoundNBT serializedData = new CompoundNBT();
            serializedData.func_218657_a(TILE_POS, (INBT)NBTUtil.func_186859_a((BlockPos)((BlockPos)data.getLeft())));
            serializedData.func_218657_a(TILE_NBT, (INBT)data.getRight());
            tileData.add((Object)serializedData);
        }
        tag.func_218657_a(TILE_DATA, (INBT)tileData);
        return tag;
    }

    public static RegionSnapshot deserialize(CompoundNBT tag) {
        int[] frames;
        ResourceLocation dimension = new ResourceLocation(tag.func_74779_i(DIMENSION));
        SetBackedPlacementSequence positions = new SetBackedPlacementSequence(NBTHelper.deserializeCollection((ListNBT)tag.func_74781_a(POSITIONS), new HashSet(), nbt -> NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)nbt))), Region.deserializeFrom(tag.func_74775_l("area")));
        ArrayList palettes = new ArrayList();
        palettes.add(Optional.empty());
        ListNBT palettesNBT = tag.func_150295_c(BLOCK_PALETTES, 10);
        for (int i = 0; i < palettesNBT.size(); ++i) {
            palettes.add(Optional.of(NBTUtil.func_190008_d((CompoundNBT)palettesNBT.func_150305_b(i))));
        }
        assert (palettes.size() == palettesNBT.size() + 1);
        ImmutableList.Builder blockStates = ImmutableList.builder();
        for (int frame : frames = tag.func_74759_k(BLOCK_FRAMES)) {
            int stateID = frame & 0xFFFFFF;
            int streaks = (frame >>> 24) + 1;
            Optional state = (Optional)palettes.get(stateID);
            for (int j = 0; j < streaks; ++j) {
                blockStates.add((Object)state);
            }
        }
        ListNBT tileDataNBT = tag.func_150295_c(TILE_DATA, 10);
        ImmutableList.Builder tileData = ImmutableList.builder();
        for (int i = 0; i < tileDataNBT.size(); ++i) {
            CompoundNBT serializedData = tileDataNBT.func_150305_b(i);
            tileData.add((Object)Pair.of((Object)NBTUtil.func_186861_c((CompoundNBT)serializedData.func_74775_l(TILE_POS)), (Object)serializedData.func_74775_l(TILE_NBT)));
        }
        return new RegionSnapshot(DimensionType.func_193417_a((ResourceLocation)dimension), positions, (List<Optional<BlockState>>)blockStates.build(), (List<Pair<BlockPos, CompoundNBT>>)tileData.build());
    }

    public static Recorder record(BiPredicate<BlockPos, BlockState> normalValidator, TriPredicate<BlockPos, BlockState, TileEntity> tileValidator, int expectedSize) {
        return new Recorder(normalValidator, tileValidator, expectedSize);
    }

    public static Recorder recordAll(int expectedSize) {
        return RegionSnapshot.record((p, s) -> true, (TriPredicate<BlockPos, BlockState, TileEntity>)((TriPredicate)(p, s, t) -> true), expectedSize);
    }

    public static Recorder recordAll() {
        return RegionSnapshot.recordAll(100);
    }

    public static Builder select(IWorld world, IPositionPlacementSequence positions) {
        return new Builder(world, positions);
    }

    public static RegionSnapshot take(IWorld world, IPositionPlacementSequence positions) throws PaletteOverflowException {
        return RegionSnapshot.select(world, positions).checkBlocks((pos, state) -> true).recordTiles(false).build();
    }

    private RegionSnapshot(DimensionType dim, IPositionPlacementSequence positions, List<Optional<BlockState>> blockStates, List<Pair<BlockPos, CompoundNBT>> tileData) {
        this.dim = Objects.requireNonNull(dim);
        this.positions = positions;
        this.blockStates = blockStates;
        this.tileData = tileData;
    }

    public void restore(IWorld world) {
        if (this.dim != world.func_201675_m().func_186058_p()) {
            return;
        }
        int index = 0;
        for (BlockPos blockPos : this.positions) {
            this.blockStates.get(index).ifPresent(state -> world.func_180501_a(pos, state, 3));
            ++index;
        }
        for (Pair pair : this.tileData) {
            TileEntity tile = world.func_175625_s((BlockPos)pair.getLeft());
            if (tile != null) {
                tile.func_145839_a((CompoundNBT)pair.getRight());
                tile.func_70296_d();
                continue;
            }
            throw new IllegalStateException("Unable to find expected tile entity at " + pair.getLeft() + " that can read " + pair.getRight());
        }
    }

    public IPositionPlacementSequence getPositions() {
        return this.positions;
    }

    public ImmutableList<Optional<BlockState>> getBlockStates() {
        return ImmutableList.copyOf(this.blockStates);
    }

    public DimensionType getDim() {
        return this.dim;
    }

    public ImmutableList<Pair<BlockPos, CompoundNBT>> getTileData() {
        return ImmutableList.copyOf(this.tileData);
    }

    public CompoundNBT serialize() {
        return this.serializeTo(new CompoundNBT());
    }

    public CompoundNBT serializeTo(CompoundNBT tag) {
        if (this.serializedForm == null) {
            this.serializedForm = RegionSnapshot.serialize(tag, this);
        }
        return this.serializedForm;
    }

    public static class Recorder {
        private final Set<BlockPos> positions;
        private final Region.Builder regionBuilder;
        private final List<Optional<BlockState>> states;
        private final List<Pair<BlockPos, CompoundNBT>> tileData;
        private final BiPredicate<BlockPos, BlockState> normalValidator;
        private final TriPredicate<BlockPos, BlockState, TileEntity> tileValidator;

        private Recorder(BiPredicate<BlockPos, BlockState> normalValidator, TriPredicate<BlockPos, BlockState, TileEntity> tileValidator, int expectedSize) {
            this.normalValidator = Objects.requireNonNull(normalValidator);
            this.tileValidator = Objects.requireNonNull(tileValidator);
            this.positions = new HashSet<BlockPos>(expectedSize);
            this.states = new ArrayList<Optional<BlockState>>(expectedSize);
            this.tileData = new ArrayList<Pair<BlockPos, CompoundNBT>>(expectedSize);
            this.regionBuilder = Region.enclosingBuilder();
        }

        public void record(IWorldReader world, BlockPos pos) {
            TileEntity tile = world.func_175625_s(pos);
            BlockState state = world.func_180495_p(pos);
            if (tile != null && this.tileValidator.test((Object)pos, (Object)state, (Object)tile)) {
                this.tileData.add((Pair<BlockPos, CompoundNBT>)Pair.of((Object)pos, (Object)tile.serializeNBT()));
                this.states.add(Optional.of(state));
            } else if (this.normalValidator.test(pos, state)) {
                this.states.add(Optional.of(state));
            } else {
                this.states.add(Optional.empty());
            }
            this.positions.add(pos);
            this.regionBuilder.enclose((Vec3i)pos);
        }

        public RegionSnapshot build(DimensionType dimensionIn) {
            return new RegionSnapshot(dimensionIn, new SetBackedPlacementSequence(this.positions, this.regionBuilder.build()), this.states, this.tileData);
        }
    }

    public static final class Builder {
        private IWorld world;
        private IPositionPlacementSequence positions;
        private BiPredicate<BlockPos, BlockState> normalValidator;
        private TriPredicate<BlockPos, BlockState, TileEntity> tileValidator;
        private boolean built = false;

        private Builder(IWorld world, IPositionPlacementSequence positions) {
            this.world = world;
            this.positions = positions;
        }

        public Builder checkBlocks(BiPredicate<BlockPos, BlockState> normalValidator) {
            Preconditions.checkState((!this.built ? 1 : 0) != 0);
            this.normalValidator = LambdaHelper.and(this.normalValidator, normalValidator);
            return this;
        }

        public Builder exclude(BlockState ... statesToExclude) {
            ImmutableSet statesSet = ImmutableSet.copyOf((Object[])statesToExclude);
            return this.checkBlocks((pos, state) -> !statesSet.contains(state));
        }

        public Builder excludeAir() {
            return this.checkBlocks((pos, state) -> !state.isAir((IBlockReader)this.world, pos));
        }

        public Builder checkTiles(TriPredicate<BlockPos, BlockState, TileEntity> tileValidator) {
            Preconditions.checkState((!this.built ? 1 : 0) != 0);
            this.tileValidator = LambdaHelper.and(this.tileValidator, tileValidator);
            return this;
        }

        public Builder recordTiles(boolean flag) {
            return this.checkTiles((TriPredicate<BlockPos, BlockState, TileEntity>)(flag ? (pos, state, tile) -> true : (pos, state, tileEntity) -> false));
        }

        public RegionSnapshot build() throws IllegalStateException, PaletteOverflowException {
            Preconditions.checkState((!this.built ? 1 : 0) != 0);
            ImmutableSet.Builder positionBuilder = ImmutableSet.builder();
            ImmutableList.Builder blockStatesBuilder = ImmutableList.builder();
            ImmutableList.Builder tileDataBuilder = ImmutableList.builder();
            for (BlockPos pos : this.positions) {
                positionBuilder.add((Object)pos);
                TileEntity tile = this.world.func_175625_s(pos);
                BlockState state = this.world.func_180495_p(pos);
                if (tile != null && this.tileValidator.test((Object)pos, (Object)state, (Object)tile)) {
                    tileDataBuilder.add((Object)Pair.of((Object)pos, (Object)tile.serializeNBT()));
                    blockStatesBuilder.add(Optional.of(state));
                    continue;
                }
                if (this.normalValidator.test(pos, state)) {
                    blockStatesBuilder.add(Optional.of(state));
                    continue;
                }
                blockStatesBuilder.add(Optional.empty());
            }
            ImmutableList blockStates = blockStatesBuilder.build();
            ImmutableSet uniqueBlocksStates = ImmutableSet.copyOf((Collection)blockStates);
            if (uniqueBlocksStates.size() >= 0x1000000) {
                throw new PaletteOverflowException(this.positions, uniqueBlocksStates.size());
            }
            this.built = true;
            return new RegionSnapshot(this.world.func_201675_m().func_186058_p(), new SetBackedPlacementSequence((Set<BlockPos>)positionBuilder.build(), this.positions.getBoundingBox()), (List)blockStates, (List)tileDataBuilder.build());
        }
    }
}

