/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.helpers;

import com.direwolf20.buildinggadgets.common.building.PlacementTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;

public class SortingHelper {

    private static final class TargetObject<T> {
        public static final Comparator<TargetObject<?>> BY_DISTANCE = Comparator.comparingDouble(TargetObject::getDist);
        private final double dist;
        private final T target;

        public TargetObject(double dist, T target) {
            this.dist = dist;
            this.target = target;
        }

        public T getTarget() {
            return this.target;
        }

        public double getDist() {
            return this.dist;
        }
    }

    public static class RenderSorter {
        private final List<PlacementTarget> orderedTargets;
        private final PlayerEntity player;
        private List<PlacementTarget> sortedTargets;

        public RenderSorter(PlayerEntity player, int estimatedSize) {
            this.orderedTargets = new ArrayList<PlacementTarget>(estimatedSize);
            this.player = player;
            this.sortedTargets = null;
        }

        public void onPlaced(PlacementTarget target) {
            this.orderedTargets.add(target);
        }

        public List<PlacementTarget> getOrderedTargets() {
            return this.orderedTargets;
        }

        public List<PlacementTarget> getSortedTargets() {
            if (this.sortedTargets == null) {
                this.sortedTargets = this.sort(this.orderedTargets);
            }
            return Collections.unmodifiableList(this.sortedTargets);
        }

        private List<PlacementTarget> sort(Iterable<PlacementTarget> orderedTargets) {
            return Blocks.byDistance(orderedTargets, PlacementTarget::getPos, this.getPlayer());
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }
    }

    public static class Blocks {
        public static List<BlockPos> byDistance(Iterable<BlockPos> list, PlayerEntity player) {
            return Blocks.byDistance(list, Function.identity(), player);
        }

        public static <T> List<T> byDistance(Iterable<T> list, Function<T, ? extends BlockPos> posExtractor, PlayerEntity player) {
            return Blocks.byDistance(StreamSupport.stream(list.spliterator(), false), posExtractor, player).collect(Collectors.toCollection(LinkedList::new));
        }

        public static <T> Stream<T> byDistance(Stream<T> stream, Function<T, ? extends BlockPos> posExtractor, PlayerEntity player) {
            double x = player.field_70165_t;
            double y = player.field_70163_u + (double)player.func_70047_e();
            double z = player.field_70161_v;
            return stream.map(t -> new TargetObject<Object>(((BlockPos)posExtractor.apply(t)).func_218140_a(x, y, z, true), t)).sorted(TargetObject.BY_DISTANCE).map(TargetObject::getTarget);
        }
    }
}

