/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.renderer;

import com.direwolf20.buildinggadgets.client.renderer.MyRenderMethods;
import com.direwolf20.buildinggadgets.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.tileentities.EffectBlockTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class EffectBlockTER
extends TileEntityRenderer<EffectBlockTileEntity> {
    public EffectBlockTER(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(EffectBlockTileEntity tile, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        float alpha;
        BlockData renderData = tile.getRenderedBlock();
        if (renderData == null) {
            return;
        }
        IRenderTypeBuffer.Impl buffer2 = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        EffectBlock.Mode toolMode = tile.getReplacementMode();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        int teCounter = tile.getTicksExisted();
        int maxLife = tile.getLifespan();
        float scale = (float)(teCounter = Math.min(teCounter, maxLife)) / (float)maxLife;
        if (scale >= 1.0f) {
            scale = 0.99f;
        }
        if (toolMode == EffectBlock.Mode.REMOVE || toolMode == EffectBlock.Mode.REPLACE) {
            scale = (float)(maxLife - teCounter) / (float)maxLife;
        }
        float trans = (1.0f - scale) / 2.0f;
        stack.func_227860_a_();
        stack.func_227861_a_((double)trans, (double)trans, (double)trans);
        stack.func_227862_a_(scale, scale, scale);
        BlockState renderBlockState = renderData.getState();
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        int color = blockColors.func_228054_a_(renderBlockState, (ILightReader)tile.func_145831_w(), tile.func_174877_v(), 0);
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        if (tile.isUsingPaste() && toolMode == EffectBlock.Mode.PLACE) {
            renderBlockState = ((Block)OurBlocks.CONSTRUCTION_DENSE_BLOCK.get()).func_176223_P();
        }
        IVertexBuilder builder = buffer2.getBuffer(OurRenderTypes.RenderBlock);
        if (!renderData.getState().hasTileEntity()) {
            IBakedModel ibakedmodel = dispatcher.func_184389_a(renderBlockState);
            for (Direction direction : Direction.values()) {
                MyRenderMethods.renderModelBrightnessColorQuads(stack.func_227866_c_(), builder, f, f1, f2, 1.0f, ibakedmodel.getQuads(renderBlockState, direction, new Random(MathHelper.func_180186_a((Vec3i)tile.func_174877_v())), (IModelData)EmptyModelData.INSTANCE), 0xF00000, 655360);
            }
            MyRenderMethods.renderModelBrightnessColorQuads(stack.func_227866_c_(), builder, f, f1, f2, 1.0f, ibakedmodel.getQuads(renderBlockState, null, new Random(MathHelper.func_180186_a((Vec3i)tile.func_174877_v())), (IModelData)EmptyModelData.INSTANCE), 0xF00000, 655360);
        } else {
            TileEntity te = BaseRenderer.getTileEntityWorld().getTileEntity(renderBlockState);
            TileEntityRenderer<TileEntity> teRender = BaseRenderer.getTileEntityWorld().getTileEntityRender(renderBlockState);
            if (teRender != null) {
                te.func_174878_a(tile.func_174877_v());
                stack.func_227860_a_();
                try {
                    teRender.func_225616_a_(te, partialTicks, stack, buffer, 0xF000F0, OverlayTexture.field_229196_a_);
                }
                catch (Exception e) {
                    BuildingGadgets.LOG.warn("TER Exception with block type: " + renderBlockState);
                }
                stack.func_227865_b_();
            }
        }
        stack.func_227865_b_();
        stack.func_227860_a_();
        builder = buffer.getBuffer(OurRenderTypes.MissingBlockOverlay);
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float maxX = 1.0f;
        float maxY = 1.0f;
        float maxZ = 1.0f;
        float red = 0.0f;
        float green = 1.0f;
        float blue = 1.0f;
        if (toolMode == EffectBlock.Mode.REMOVE || toolMode == EffectBlock.Mode.REPLACE) {
            red = 1.0f;
            green = 0.25f;
            blue = 0.25f;
        }
        if ((alpha = 1.0f - scale) < 0.051f) {
            alpha = 0.051f;
        }
        if (alpha > 0.33f) {
            alpha = 0.33f;
        }
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        if (tile.func_145831_w().func_180495_p(tile.func_174877_v().func_177977_b()).func_177230_c() != OurBlocks.EFFECT_BLOCK.get()) {
            builder.func_227888_a_(matrix, x, y, z).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, y, z).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, y, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, x, y, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        }
        if (tile.func_145831_w().func_180495_p(tile.func_174877_v().func_177984_a()).func_177230_c() != OurBlocks.EFFECT_BLOCK.get()) {
            builder.func_227888_a_(matrix, x, maxY, z).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, x, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, z).func_227885_a_(red, green, blue, alpha).func_181675_d();
        }
        if (tile.func_145831_w().func_180495_p(tile.func_174877_v().func_177978_c()).func_177230_c() != OurBlocks.EFFECT_BLOCK.get()) {
            builder.func_227888_a_(matrix, x, y, z).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, x, maxY, z).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, z).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, y, z).func_227885_a_(red, green, blue, alpha).func_181675_d();
        }
        if (tile.func_145831_w().func_180495_p(tile.func_174877_v().func_177968_d()).func_177230_c() != OurBlocks.EFFECT_BLOCK.get()) {
            builder.func_227888_a_(matrix, x, y, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, y, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, x, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        }
        if (tile.func_145831_w().func_180495_p(tile.func_174877_v().func_177974_f()).func_177230_c() != OurBlocks.EFFECT_BLOCK.get()) {
            builder.func_227888_a_(matrix, maxX, y, z).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, z).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, y, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        }
        if (tile.func_145831_w().func_180495_p(tile.func_174877_v().func_177976_e()).func_177230_c() != OurBlocks.EFFECT_BLOCK.get()) {
            builder.func_227888_a_(matrix, x, y, z).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, x, y, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, x, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, x, maxY, z).func_227885_a_(red, green, blue, alpha).func_181675_d();
        }
        stack.func_227865_b_();
        buffer2.func_228461_a_();
    }
}

