/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.inventory;

import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.inventory.CreativeItemIndex;
import com.direwolf20.buildinggadgets.common.inventory.HandlerInsertProvider;
import com.direwolf20.buildinggadgets.common.inventory.IInsertProvider;
import com.direwolf20.buildinggadgets.common.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.inventory.PlayerInventoryInsertProvider;
import com.direwolf20.buildinggadgets.common.inventory.PlayerItemIndex;
import com.direwolf20.buildinggadgets.common.inventory.handle.IObjectHandle;
import com.direwolf20.buildinggadgets.common.inventory.handle.ItemHandlerProvider;
import com.direwolf20.buildinggadgets.common.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.UniqueItem;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.ConstructionPaste;
import com.direwolf20.buildinggadgets.common.items.ConstructionPasteContainer;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.registry.TopologicalRegistryBuilder;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.CommonUtils;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.LeverBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class InventoryHelper {
    public static final MaterialList PASTE_LIST = MaterialList.of(new UniqueItem((Item)OurItems.CONSTRUCTION_PASTE_ITEM.get()));
    private static IProperty AXIS = EnumProperty.func_177709_a((String)"axis", Direction.Axis.class);
    private static final Set<IProperty> SAFE_PROPERTIES = ImmutableSet.of((Object)SlabBlock.field_196505_a, (Object)StairsBlock.field_176308_b, (Object)LogBlock.field_176298_M, (Object)AXIS, (Object)DirectionalBlock.field_176387_N, (Object)StairsBlock.field_176309_a, (Object[])new IProperty[]{TrapDoorBlock.field_176285_M, TrapDoorBlock.field_176283_b, StairsBlock.field_176310_M, LeverBlock.field_176359_b, RepeaterBlock.field_176410_b, PaneBlock.field_196411_b, PaneBlock.field_196414_y, PaneBlock.field_196409_a, PaneBlock.field_196413_c});
    private static final Set<IProperty> SAFE_PROPERTIES_COPY_PASTE = ImmutableSet.builder().addAll(SAFE_PROPERTIES).add((Object[])new IProperty[]{RailBlock.field_176565_b, PoweredRailBlock.field_176568_b, ChestBlock.field_196314_b}).build();
    private static final Set<IProperty<?>> UNSAFE_PROPERTIES = ImmutableSet.builder().add((Object)CropsBlock.field_176488_a).build();
    public static final CreativeItemIndex CREATIVE_INDEX = new CreativeItemIndex();

    public static IItemIndex index(ItemStack tool, PlayerEntity player) {
        if (player.func_184812_l_()) {
            return CREATIVE_INDEX;
        }
        return new PlayerItemIndex(tool, player);
    }

    static List<IInsertProvider> indexInsertProviders(ItemStack tool, PlayerEntity player) {
        ImmutableList.Builder builder = ImmutableList.builder();
        IItemHandler remoteInv = GadgetUtils.getRemoteInventory(tool, player.field_70170_p);
        if (remoteInv != null) {
            builder.add((Object)new HandlerInsertProvider(remoteInv));
        }
        builder.add((Object)new PlayerInventoryInsertProvider(player));
        return builder.build();
    }

    static Map<Class<?>, Map<Object, List<IObjectHandle<?>>>> indexMap(ItemStack tool, PlayerEntity player) {
        HashMap map = new HashMap();
        for (IItemHandler handler : InventoryHelper.getHandlers(tool, player)) {
            if (handler == null || handler.getSlots() <= 0) continue;
            ItemHandlerProvider.index(handler, map);
        }
        return map;
    }

    static List<IItemHandler> getHandlers(ItemStack stack, PlayerEntity player) {
        return Arrays.asList(GadgetUtils.getRemoteInventory(stack, player.field_70170_p), (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)new EmptyHandler()));
    }

    public static void registerHandleProviders() {
        InterModComms.sendTo((String)"buildinggadgets", (String)"imc_handle_provider", () -> () -> TopologicalRegistryBuilder.create().addMarker(Reference.MARKER_AFTER_RL).addValue(Reference.HandleProviderReference.STACK_HANDLER_ITEM_HANDLE_RL, new ItemHandlerProvider()).addDependency(Reference.HandleProviderReference.STACK_HANDLER_ITEM_HANDLE_RL, Reference.MARKER_AFTER_RL));
    }

    public static boolean giveItem(ItemStack itemStack, PlayerEntity player, IWorld world) {
        List<IItemHandler> invContainers;
        ItemStack giveItemStack;
        if (player.func_184812_l_()) {
            return true;
        }
        if (itemStack.func_77973_b() instanceof ConstructionPaste) {
            itemStack = InventoryHelper.addPasteToContainer(player, itemStack);
        }
        if (itemStack.func_190916_E() == 0) {
            return true;
        }
        PlayerInventory inv = player.field_71071_by;
        List<Integer> slots = InventoryHelper.findItem(itemStack.func_77973_b(), inv);
        for (int slot : slots) {
            boolean success;
            ItemStack stackInSlot = inv.func_70301_a(slot);
            if (stackInSlot.func_190916_E() >= stackInSlot.func_77973_b().getItemStackLimit(stackInSlot) || !(success = inv.func_70441_a(giveItemStack = itemStack.func_77946_l()))) continue;
            return true;
        }
        ItemStack tool = AbstractGadget.getGadget(player);
        IItemHandler remoteInventory = GadgetUtils.getRemoteInventory(tool, world.func_201672_e());
        if (remoteInventory != null) {
            for (int i = 0; i < remoteInventory.getSlots(); ++i) {
                ItemStack containerItem = remoteInventory.getStackInSlot(i);
                ItemStack giveItemStack2 = itemStack.func_77946_l();
                if (containerItem.func_77973_b() != itemStack.func_77973_b() && !containerItem.func_190926_b()) continue;
                if ((giveItemStack2 = remoteInventory.insertItem(i, giveItemStack2, false)).func_190926_b()) {
                    return true;
                }
                itemStack = giveItemStack2.func_77946_l();
            }
        }
        if ((invContainers = InventoryHelper.findInvContainers(inv)).size() > 0) {
            for (IItemHandler container : invContainers) {
                for (int i = 0; i < container.getSlots(); ++i) {
                    ItemStack containerItem = container.getStackInSlot(i);
                    ItemStack giveItemStack3 = itemStack.func_77946_l();
                    if (containerItem.func_77973_b() != giveItemStack3.func_77973_b()) continue;
                    if ((giveItemStack3 = container.insertItem(i, giveItemStack3, false)).func_190926_b()) {
                        return true;
                    }
                    itemStack = giveItemStack3.func_77946_l();
                }
            }
        }
        giveItemStack = itemStack.func_77946_l();
        return inv.func_70441_a(giveItemStack);
    }

    public static int countItem(ItemStack itemStack, PlayerEntity player, IRemoteInventoryProvider remoteInventory) {
        if (player.func_184812_l_()) {
            return Integer.MAX_VALUE;
        }
        long count = remoteInventory.countItem(AbstractGadget.getGadget(player), itemStack);
        PlayerInventory inv = player.field_71071_by;
        List<Integer> slots = InventoryHelper.findItem(itemStack.func_77973_b(), inv);
        List<IItemHandler> invContainers = InventoryHelper.findInvContainers(inv);
        if (slots.size() == 0 && invContainers.size() == 0 && count == 0L) {
            return 0;
        }
        if (invContainers.size() > 0) {
            for (IItemHandler container : invContainers) {
                count += (long)InventoryHelper.countInContainer(container, itemStack.func_77973_b());
            }
        }
        Iterator<Object> iterator = slots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            ItemStack stackInSlot = inv.func_70301_a(slot);
            count += (long)stackInSlot.func_190916_E();
        }
        return InventoryHelper.longToInt(count);
    }

    public static int countPaste(PlayerEntity player) {
        List<Integer> containerSlots;
        if (player.func_184812_l_()) {
            return Integer.MAX_VALUE;
        }
        long count = 0L;
        PlayerInventory inv = player.field_71071_by;
        Item item = (Item)OurItems.CONSTRUCTION_PASTE_ITEM.get();
        List<Integer> slots = InventoryHelper.findItem(item, inv);
        if (slots.size() > 0) {
            for (int slot : slots) {
                ItemStack stackInSlot = inv.func_70301_a(slot);
                count += (long)stackInSlot.func_190916_E();
            }
        }
        if ((containerSlots = InventoryHelper.findItemClass(ConstructionPasteContainer.class, inv)).size() > 0) {
            for (int slot : containerSlots) {
                ItemStack stackInSlot = inv.func_70301_a(slot);
                if (!(stackInSlot.func_77973_b() instanceof ConstructionPasteContainer)) continue;
                count += (long)ConstructionPasteContainer.getPasteAmount(stackInSlot);
            }
        }
        return InventoryHelper.longToInt(count);
    }

    public static int longToInt(long count) {
        try {
            return Math.toIntExact(count);
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
    }

    public static ItemStack addPasteToContainer(PlayerEntity player, ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ConstructionPaste)) {
            return itemStack;
        }
        PlayerInventory inv = player.field_71071_by;
        List<Integer> slots = InventoryHelper.findItemClass(ConstructionPasteContainer.class, inv);
        if (slots.size() == 0) {
            return itemStack;
        }
        HashMap<Integer, Integer> slotMap = new HashMap<Integer, Integer>();
        for (int slot : slots) {
            slotMap.put(slot, ConstructionPasteContainer.getPasteAmount(inv.func_70301_a(slot)));
        }
        ArrayList list = new ArrayList(slotMap.entrySet());
        Comparator comparator = Map.Entry.comparingByValue();
        comparator = comparator.reversed();
        list.sort(comparator);
        for (Map.Entry entry : list) {
            ItemStack containerStack = inv.func_70301_a(((Integer)entry.getKey()).intValue());
            ConstructionPasteContainer item = (ConstructionPasteContainer)containerStack.func_77973_b();
            int maxAmount = item.getMaxCapacity();
            int pasteInContainer = ConstructionPasteContainer.getPasteAmount(containerStack);
            int freeSpace = item.isCreative() ? Integer.MAX_VALUE : maxAmount - pasteInContainer;
            int stackSize = itemStack.func_190916_E();
            int remainingPaste = stackSize - freeSpace;
            if (remainingPaste < 0) {
                remainingPaste = 0;
            }
            int usedPaste = Math.abs(stackSize - remainingPaste);
            itemStack.func_190920_e(remainingPaste);
            ConstructionPasteContainer.setPasteAmount(containerStack, pasteInContainer + usedPaste);
        }
        return itemStack;
    }

    private static List<IItemHandler> findInvContainers(PlayerInventory inv) {
        ArrayList<IItemHandler> containers = new ArrayList<IItemHandler>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(containers::add);
        }
        return containers;
    }

    public static int countInContainer(IItemHandler container, Item item) {
        int count = 0;
        for (int i = 0; i < container.getSlots(); ++i) {
            ItemStack tempItem = container.getStackInSlot(i);
            if (tempItem.func_77973_b() != item) continue;
            count += tempItem.func_190916_E();
        }
        return count;
    }

    private static List<Integer> findItem(Item item, PlayerInventory inv) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item) continue;
            slots.add(i);
        }
        return slots;
    }

    public static List<Integer> findItemClass(Class<?> c, PlayerInventory inv) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !c.isInstance(stack.func_77973_b())) continue;
            slots.add(i);
        }
        return slots;
    }

    public static ItemStack getSilkTouchDrop(BlockState state) {
        return new ItemStack((IItemProvider)state.func_177230_c());
    }

    public static Optional<BlockData> getSafeBlockData(PlayerEntity player, BlockPos pos, Hand hand) {
        BlockItemUseContext blockItemUseContext = new BlockItemUseContext(new ItemUseContext(player, hand, CommonUtils.fakeRayTrace(player.func_213303_ch(), pos)));
        return InventoryHelper.getSafeBlockData(player, pos, blockItemUseContext);
    }

    public static Optional<BlockData> getSafeBlockData(PlayerEntity player, BlockPos pos, BlockItemUseContext useContext) {
        TileEntity te;
        World world = player.field_70170_p;
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof FlowingFluidBlock || !state.func_204520_s().func_206888_e()) {
            return Optional.empty();
        }
        if (state.func_177230_c() == OurBlocks.CONSTRUCTION_BLOCK.get() && (te = world.func_175625_s(pos)) instanceof ConstructionBlockTileEntity) {
            return Optional.of(((ConstructionBlockTileEntity)te).getConstructionBlockData());
        }
        BlockState placeState = null;
        try {
            placeState = state.func_177230_c().func_196258_a(useContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (placeState == null) {
            placeState = state.func_177230_c().func_176223_P();
        }
        for (IProperty prop : placeState.func_206869_a()) {
            if (UNSAFE_PROPERTIES.contains(prop)) continue;
            placeState = InventoryHelper.applyProperty(placeState, state, prop);
        }
        return Optional.of(new BlockData(placeState, TileSupport.createTileData((IBlockReader)world, pos)));
    }

    private static <T extends Comparable<T>> BlockState applyProperty(BlockState state, BlockState from, IProperty<T> prop) {
        return (BlockState)state.func_206870_a(prop, from.func_177229_b(prop));
    }

    public static interface IRemoteInventoryProvider {
        public int countItem(ItemStack var1, ItemStack var2);
    }
}

