/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.building.view.SimpleBuildContext;
import com.direwolf20.buildinggadgets.common.capability.CapabilityProviderEnergy;
import com.direwolf20.buildinggadgets.common.capability.IPrivateEnergy;
import com.direwolf20.buildinggadgets.common.capability.provider.CapabilityProviderBlockProvider;
import com.direwolf20.buildinggadgets.common.capability.provider.MultiCapabilityProvider;
import com.direwolf20.buildinggadgets.common.commands.ForceUnloadedCommand;
import com.direwolf20.buildinggadgets.common.concurrent.UndoScheduler;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.items.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.items.modes.GridMode;
import com.direwolf20.buildinggadgets.common.items.modes.HorizontalColumnMode;
import com.direwolf20.buildinggadgets.common.items.modes.StairMode;
import com.direwolf20.buildinggadgets.common.items.modes.VerticalColumnMode;
import com.direwolf20.buildinggadgets.common.save.SaveManager;
import com.direwolf20.buildinggadgets.common.save.Undo;
import com.direwolf20.buildinggadgets.common.save.UndoWorldSave;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractGadget
extends Item {
    private BaseRenderer renderer = (BaseRenderer)DistExecutor.runForDist(this::createRenderFactory, () -> () -> null);
    private final Tag<Block> whiteList;
    private final Tag<Block> blackList;
    private Supplier<UndoWorldSave> saveSupplier;

    public AbstractGadget(Item.Properties builder, IntSupplier undoLengthSupplier, String undoName, ResourceLocation whiteListTag, ResourceLocation blackListTag) {
        super(builder);
        this.whiteList = new BlockTags.Wrapper(whiteListTag);
        this.blackList = new BlockTags.Wrapper(blackListTag);
        this.saveSupplier = SaveManager.INSTANCE.registerUndoSave(w -> SaveManager.getUndoSave(w, undoLengthSupplier, undoName));
    }

    public abstract int getEnergyMax();

    public abstract int getEnergyCost(ItemStack var1);

    public Tag<Block> getWhiteList() {
        return this.whiteList;
    }

    public Tag<Block> getBlackList() {
        return this.blackList;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BaseRenderer getRender() {
        return this.renderer;
    }

    protected abstract Supplier<BaseRenderer> createRenderFactory();

    protected UndoWorldSave getUndoSave() {
        return this.saveSupplier.get();
    }

    protected void addCapabilityProviders(ImmutableList.Builder<ICapabilityProvider> providerBuilder, ItemStack stack, @Nullable CompoundNBT tag) {
        providerBuilder.add((Object)new CapabilityProviderEnergy(stack, this::getEnergyMax));
        providerBuilder.add((Object)new CapabilityProviderBlockProvider(stack));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT tag) {
        ImmutableList.Builder providerBuilder = ImmutableList.builder();
        this.addCapabilityProviders((ImmutableList.Builder<ICapabilityProvider>)providerBuilder, stack, tag);
        return new MultiCapabilityProvider((ImmutableList<ICapabilityProvider>)providerBuilder.build());
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (!this.func_194125_a(group)) {
            return;
        }
        ItemStack charged = new ItemStack((IItemProvider)this);
        charged.func_196082_o().func_74780_a("energy", (double)this.getEnergyMax());
        items.add((Object)charged);
    }

    public boolean func_77645_m() {
        return this.func_77612_l() > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        LazyOptional cap = stack.getCapability(CapabilityEnergy.ENERGY);
        if (!cap.isPresent()) {
            return super.getDurabilityForDisplay(stack);
        }
        Pair energyStorage = (Pair)cap.map(e -> Pair.of((Object)e.getEnergyStored(), (Object)e.getMaxEnergyStored())).orElse((Object)Pair.of((Object)0, (Object)0));
        return 1.0 - (double)((Integer)energyStorage.getLeft()).intValue() / (double)((Integer)energyStorage.getRight()).intValue();
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        LazyOptional cap = stack.getCapability(CapabilityEnergy.ENERGY);
        if (!cap.isPresent()) {
            return super.getRGBDurabilityForDisplay(stack);
        }
        Pair energyStorage = (Pair)cap.map(e -> Pair.of((Object)e.getEnergyStored(), (Object)e.getMaxEnergyStored())).orElse((Object)Pair.of((Object)0, (Object)0));
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)((Integer)energyStorage.getLeft()).intValue() / (float)((Integer)energyStorage.getRight()).intValue()) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean isDamaged(ItemStack stack) {
        LazyOptional cap = stack.getCapability(CapabilityEnergy.ENERGY);
        if (!cap.isPresent()) {
            return super.isDamaged(stack);
        }
        Pair energyStorage = (Pair)cap.map(e -> Pair.of((Object)e.getEnergyStored(), (Object)e.getMaxEnergyStored())).orElse((Object)Pair.of((Object)0, (Object)0));
        return energyStorage.getLeft() != energyStorage.getRight();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("creative")) {
            return false;
        }
        LazyOptional cap = stack.getCapability(CapabilityEnergy.ENERGY);
        if (!cap.isPresent()) {
            return super.showDurabilityBar(stack);
        }
        Pair energyStorage = (Pair)cap.map(e -> Pair.of((Object)e.getEnergyStored(), (Object)e.getMaxEnergyStored())).orElse((Object)Pair.of((Object)0, (Object)0));
        return energyStorage.getLeft() != energyStorage.getRight();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return !toRepair.getCapability(CapabilityEnergy.ENERGY).isPresent() && repair.func_77973_b() == Items.field_151045_i;
    }

    public boolean isAllowedBlock(Block block) {
        if (this.getWhiteList().func_199885_a().isEmpty()) {
            return !this.getBlackList().func_199685_a_((Object)block);
        }
        return this.getWhiteList().func_199685_a_((Object)block);
    }

    public static ItemStack getGadget(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        if (!(heldItem.func_77973_b() instanceof AbstractGadget) && !((heldItem = player.func_184592_cb()).func_77973_b() instanceof AbstractGadget)) {
            return ItemStack.field_190927_a;
        }
        return heldItem;
    }

    public boolean canUse(ItemStack tool, PlayerEntity player) {
        if (player.func_184812_l_() || this.getEnergyMax() == 0) {
            return true;
        }
        return this.getEnergyCost(tool) <= (Integer)tool.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse((Object)0);
    }

    public void applyDamage(ItemStack tool, ServerPlayerEntity player) {
        if (player.func_184812_l_() || this.getEnergyMax() == 0) {
            return;
        }
        tool.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> ((IPrivateEnergy)e).extractPower(this.getEnergyCost(tool), false));
    }

    protected void addEnergyInformation(List<ITextComponent> tooltip, ItemStack stack) {
        if (this.getEnergyMax() == 0) {
            return;
        }
        stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energy -> tooltip.add(TooltipTranslation.GADGET_ENERGY.componentTranslation(GadgetUtils.withSuffix(energy.getEnergyStored()), GadgetUtils.withSuffix(energy.getMaxEnergyStored())).func_150255_a(Styles.GRAY)));
    }

    public final void onRotate(ItemStack stack, PlayerEntity player) {
        if (this.performRotate(stack, player)) {
            player.func_146105_b(MessageTranslation.ROTATED.componentTranslation(new Object[0]).func_150255_a(Styles.AQUA), true);
        }
    }

    protected boolean performRotate(ItemStack stack, PlayerEntity player) {
        return false;
    }

    public final void onMirror(ItemStack stack, PlayerEntity player) {
        if (this.performMirror(stack, player)) {
            player.func_146105_b(MessageTranslation.MIRRORED.componentTranslation(new Object[0]).func_150255_a(Styles.AQUA), true);
        }
    }

    protected boolean performMirror(ItemStack stack, PlayerEntity player) {
        return false;
    }

    public final void onAnchor(ItemStack stack, PlayerEntity player) {
        if (this.getAnchor(stack) == null) {
            BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, stack);
            if (player.field_70170_p.func_175623_d(lookingAt.func_216350_a())) {
                return;
            }
            this.onAnchorSet(stack, player, lookingAt);
            player.func_146105_b(MessageTranslation.ANCHOR_SET.componentTranslation(new Object[0]).func_150255_a(Styles.AQUA), true);
        } else {
            this.onAnchorRemoved(stack, player);
            player.func_146105_b(MessageTranslation.ANCHOR_REMOVED.componentTranslation(new Object[0]).func_150255_a(Styles.AQUA), true);
        }
    }

    protected void onAnchorSet(ItemStack stack, PlayerEntity player, BlockRayTraceResult lookingAt) {
        GadgetUtils.writePOSToNBT(stack, lookingAt.func_216350_a(), "anchor");
    }

    protected void onAnchorRemoved(ItemStack stack, PlayerEntity player) {
        stack.func_196082_o().func_82580_o("anchor");
    }

    @Nullable
    public BlockPos getAnchor(ItemStack stack) {
        return GadgetUtils.getPOSFromNBT(stack, "anchor");
    }

    public static boolean getFuzzy(ItemStack stack) {
        return stack.func_196082_o().func_74767_n("fuzzy");
    }

    public static void toggleFuzzy(PlayerEntity player, ItemStack stack) {
        stack.func_196082_o().func_74757_a("fuzzy", !AbstractGadget.getFuzzy(stack));
        player.func_146105_b(MessageTranslation.FUZZY_MODE.componentTranslation(AbstractGadget.getFuzzy(stack)).func_150255_a(Styles.AQUA), true);
    }

    public static boolean getConnectedArea(ItemStack stack) {
        return !stack.func_196082_o().func_74767_n("unconnected_area");
    }

    public static void toggleConnectedArea(PlayerEntity player, ItemStack stack) {
        stack.func_196082_o().func_74757_a("unconnected_area", AbstractGadget.getConnectedArea(stack));
        player.func_146105_b((stack.func_77973_b() instanceof GadgetDestruction ? MessageTranslation.CONNECTED_AREA : MessageTranslation.CONNECTED_SURFACE).componentTranslation(AbstractGadget.getConnectedArea(stack)).func_150255_a(Styles.AQUA), true);
    }

    public static boolean shouldRayTraceFluid(ItemStack stack) {
        return stack.func_196082_o().func_74767_n("raytrace_fluid");
    }

    public static void toggleRayTraceFluid(ServerPlayerEntity player, ItemStack stack) {
        stack.func_196082_o().func_74757_a("raytrace_fluid", !AbstractGadget.shouldRayTraceFluid(stack));
        player.func_146105_b(MessageTranslation.RAYTRACE_FLUID.componentTranslation(AbstractGadget.shouldRayTraceFluid(stack)).func_150255_a(Styles.AQUA), true);
    }

    public static void addInformationRayTraceFluid(List<ITextComponent> tooltip, ItemStack stack) {
        tooltip.add(TooltipTranslation.GADGET_RAYTRACE_FLUID.componentTranslation(String.valueOf(AbstractGadget.shouldRayTraceFluid(stack))).func_150255_a(Styles.BLUE));
    }

    public UUID getUUID(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (!nbt.func_186855_b("uuid")) {
            UUID newId = this.getUndoSave().getFreeUUID();
            nbt.func_186854_a("uuid", newId);
            return newId;
        }
        return nbt.func_186857_a("uuid");
    }

    public static int getRangeInBlocks(int range, AbstractMode mode) {
        if (mode instanceof StairMode || mode instanceof VerticalColumnMode || mode instanceof HorizontalColumnMode) {
            return range;
        }
        if (mode instanceof GridMode) {
            return range < 7 ? 9 : (range < 13 ? 121 : 361);
        }
        return range == 1 ? 1 : (range + 1) * (range + 1);
    }

    protected void pushUndo(ItemStack stack, Undo undo) {
        if (undo.getUndoData().isEmpty()) {
            return;
        }
        UndoWorldSave save = this.getUndoSave();
        save.insertUndo(this.getUUID(stack), undo);
    }

    public void undo(World world, PlayerEntity player, ItemStack stack) {
        UndoWorldSave save = this.getUndoSave();
        Optional<Undo> undoOptional = save.getUndo(this.getUUID(stack));
        if (undoOptional.isPresent()) {
            ImmutableSortedSet<ChunkPos> unloadedChunks;
            Undo undo = undoOptional.orElseThrow(RuntimeException::new);
            IItemIndex index = InventoryHelper.index(stack, player);
            if (!ForceUnloadedCommand.mayForceUnloadedChunks(player) && !(unloadedChunks = undo.getBoundingBox().getUnloadedChunks((IWorldReader)world)).isEmpty()) {
                this.pushUndo(stack, undo);
                player.func_146105_b(MessageTranslation.UNDO_UNLOADED.componentTranslation(new Object[0]).func_150255_a(Styles.RED), true);
                BuildingGadgets.LOG.error("Player attempted to undo a Region missing {} unloaded chunks. Denied undo!", (Object)unloadedChunks.size());
                BuildingGadgets.LOG.trace("The following chunks were detected as unloaded {}.", unloadedChunks);
                return;
            }
            SimpleBuildContext buildContext = SimpleBuildContext.builder().buildingPlayer(player).usedStack(stack).build((IWorld)world);
            UndoScheduler.scheduleUndo(undo, index, buildContext, (Integer)Config.GADGETS.placeSteps.get());
        } else {
            player.func_146105_b(MessageTranslation.NOTHING_TO_UNDO.componentTranslation(new Object[0]).func_150255_a(Styles.RED), true);
        }
    }
}

