/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.client.renders.BuildRender;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.view.SimpleBuildContext;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.items.modes.BuildingModes;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketBindTool;
import com.direwolf20.buildinggadgets.common.network.packets.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.save.Undo;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.LangUtil;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.direwolf20.buildinggadgets.common.world.MockBuilderWorld;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class GadgetBuilding
extends AbstractGadget {
    private static final MockBuilderWorld fakeWorld = new MockBuilderWorld();

    public GadgetBuilding() {
        super(OurItems.nonStackableItemProperties().func_200918_c(1), () -> ((ForgeConfigSpec.IntValue)Config.GADGETS.GADGET_BUILDING.undoSize).get(), "buildinggadgets_undo_building", Reference.BlockReference.TagReference.WHITELIST_BUILDING, Reference.BlockReference.TagReference.BLACKLIST_BUILDING);
    }

    @Override
    public int getEnergyMax() {
        return (Integer)Config.GADGETS.GADGET_BUILDING.maxEnergy.get();
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return (Integer)Config.GADGETS.GADGET_BUILDING.energyCost.get();
    }

    @Override
    protected Supplier<BaseRenderer> createRenderFactory() {
        return () -> new BuildRender(false);
    }

    public boolean placeAtop(ItemStack stack) {
        return GadgetBuilding.shouldPlaceAtop(stack);
    }

    private static void setToolMode(ItemStack tool, BuildingModes mode) {
        CompoundNBT tagCompound = tool.func_196082_o();
        tagCompound.func_74778_a("mode", mode.toString());
    }

    public static BuildingModes getToolMode(ItemStack tool) {
        CompoundNBT tagCompound = tool.func_196082_o();
        return BuildingModes.getFromName(tagCompound.func_74779_i("mode"));
    }

    public static boolean shouldPlaceAtop(ItemStack stack) {
        return !stack.func_196082_o().func_74767_n("start_inside");
    }

    public static void togglePlaceAtop(PlayerEntity player, ItemStack stack) {
        stack.func_196082_o().func_74757_a("start_inside", GadgetBuilding.shouldPlaceAtop(stack));
        player.func_146105_b((GadgetBuilding.shouldPlaceAtop(stack) ? MessageTranslation.PLACE_ATOP : MessageTranslation.PLACE_INSIDE).componentTranslation(new Object[0]).func_150255_a(Styles.AQUA), true);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        BuildingModes mode = GadgetBuilding.getToolMode(stack);
        this.addEnergyInformation(tooltip, stack);
        tooltip.add(TooltipTranslation.GADGET_MODE.componentTranslation(mode == BuildingModes.SURFACE && GadgetBuilding.getConnectedArea(stack) ? TooltipTranslation.GADGET_CONNECTED.componentTranslation(new TranslationTextComponent(mode.getTranslationKey(), new Object[0])) : new TranslationTextComponent(mode.getTranslationKey(), new Object[0])).func_150255_a(Styles.AQUA));
        tooltip.add(TooltipTranslation.GADGET_BLOCK.componentTranslation(LangUtil.getFormattedBlockName(GadgetUtils.getToolBlock(stack).getState())).func_150255_a(Styles.DK_GREEN));
        int range = GadgetUtils.getToolRange(stack);
        if (GadgetBuilding.getToolMode(stack) != BuildingModes.BUILD_TO_ME) {
            tooltip.add(TooltipTranslation.GADGET_RANGE.componentTranslation(range, GadgetBuilding.getRangeInBlocks(range, mode.getMode())).func_150255_a(Styles.LT_PURPLE));
        }
        if (GadgetBuilding.getToolMode(stack) == BuildingModes.SURFACE) {
            tooltip.add(TooltipTranslation.GADGET_FUZZY.componentTranslation(String.valueOf(GadgetBuilding.getFuzzy(stack))).func_150255_a(Styles.GOLD));
        }
        GadgetBuilding.addInformationRayTraceFluid(tooltip, stack);
        tooltip.add(TooltipTranslation.GADGET_BUILDING_PLACE_ATOP.componentTranslation(String.valueOf(GadgetBuilding.shouldPlaceAtop(stack))).func_150255_a(Styles.YELLOW));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (player.func_225608_bj_()) {
                ActionResult<Block> result = GadgetUtils.selectBlock(itemstack, player);
                if (!result.func_188397_a().func_226247_b_()) {
                    player.func_146105_b(MessageTranslation.INVALID_BLOCK.componentTranslation(((Block)result.func_188398_b()).getRegistryName()).func_150255_a(Styles.AQUA), true);
                    return super.func_77659_a(world, player, hand);
                }
            } else if (player instanceof ServerPlayerEntity) {
                this.build((ServerPlayerEntity)player, itemstack);
            }
        } else if (!player.func_225608_bj_()) {
            BaseRenderer.updateInventoryCache();
        } else if (Screen.hasControlDown()) {
            PacketHandler.sendToServer(new PacketBindTool());
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public void setMode(ItemStack heldItem, int modeInt) {
        BuildingModes mode = BuildingModes.values()[modeInt];
        GadgetBuilding.setToolMode(heldItem, mode);
    }

    public static void rangeChange(PlayerEntity player, ItemStack heldItem) {
        int changeAmount;
        int range = GadgetUtils.getToolRange(heldItem);
        int n = changeAmount = GadgetBuilding.getToolMode(heldItem) != BuildingModes.SURFACE || range % 2 == 0 ? 1 : 2;
        range = player.func_225608_bj_() ? (range == 1 ? (Integer)Config.GADGETS.maxRange.get() : range - changeAmount) : (range >= (Integer)Config.GADGETS.maxRange.get() ? 1 : range + changeAmount);
        GadgetUtils.setToolRange(heldItem, range);
        player.func_146105_b(MessageTranslation.RANGE_SET.componentTranslation(range).func_150255_a(Styles.AQUA), true);
    }

    private void build(ServerPlayerEntity player, ItemStack stack) {
        World world = player.field_70170_p;
        ItemStack heldItem = GadgetBuilding.getGadget((PlayerEntity)player);
        if (heldItem.func_190926_b()) {
            return;
        }
        List<BlockPos> coords = GadgetUtils.getAnchor(heldItem).orElse(new ArrayList());
        BlockData blockData = GadgetUtils.getToolBlock(heldItem);
        if (coords.size() == 0) {
            BlockRayTraceResult lookingAt = VectorHelper.getLookingAt((PlayerEntity)player, stack);
            if (world.func_175623_d(lookingAt.func_216350_a())) {
                return;
            }
            Direction sideHit = lookingAt.func_216354_b();
            coords = GadgetBuilding.getToolMode(stack).getMode().getCollection(new AbstractMode.UseContext(world, blockData.getState(), lookingAt.func_216350_a(), heldItem, sideHit, this.placeAtop(stack)), (PlayerEntity)player);
        } else {
            GadgetUtils.setAnchor(stack);
        }
        Undo.Builder builder = Undo.builder();
        IItemIndex index = InventoryHelper.index(stack, (PlayerEntity)player);
        if (blockData.getState() != Blocks.field_150350_a.func_176223_P()) {
            fakeWorld.setWorldAndState(player.field_70170_p, blockData.getState(), (Collection<BlockPos>)coords);
            for (BlockPos coordinate : coords) {
                this.placeBlock(world, player, index, builder, coordinate, blockData);
            }
        }
        this.pushUndo(stack, builder.build(world.func_201675_m().func_186058_p()));
    }

    private void placeBlock(World world, ServerPlayerEntity player, IItemIndex index, Undo.Builder builder, BlockPos pos, BlockData setBlock) {
        BlockSnapshot blockSnapshot;
        if (pos.func_177956_o() > world.getMaxHeight() || pos.func_177956_o() < 0 || !player.func_175142_cm()) {
            return;
        }
        ItemStack heldItem = GadgetBuilding.getGadget((PlayerEntity)player);
        if (heldItem.func_190926_b()) {
            return;
        }
        boolean useConstructionPaste = false;
        SimpleBuildContext buildContext = new SimpleBuildContext((IWorld)world, (PlayerEntity)player, heldItem);
        MaterialList requiredItems = setBlock.getRequiredItems(buildContext, null, pos);
        MatchResult match = index.tryMatch(requiredItems);
        if (!match.isSuccess()) {
            if (setBlock.getState().hasTileEntity()) {
                return;
            }
            match = index.tryMatch(InventoryHelper.PASTE_LIST);
            if (!match.isSuccess()) {
                return;
            }
            useConstructionPaste = true;
        }
        if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)(blockSnapshot = BlockSnapshot.getBlockSnapshot((IWorld)world, (BlockPos)pos)), (Direction)Direction.UP) || !world.func_175660_a((PlayerEntity)player, pos) || !this.canUse(heldItem, (PlayerEntity)player)) {
            return;
        }
        this.applyDamage(heldItem, player);
        if (index.applyMatch(match)) {
            ImmutableMultiset<IUniqueObject<?>> usedItems = match.getChosenOption();
            builder.record((IBlockReader)world, pos, setBlock, (Multiset<IUniqueObject<?>>)usedItems, (Multiset<IUniqueObject<?>>)ImmutableMultiset.of());
            EffectBlock.spawnEffectBlock((IWorld)world, pos, setBlock, EffectBlock.Mode.PLACE, useConstructionPaste);
        }
    }

    public static ItemStack getGadget(PlayerEntity player) {
        ItemStack stack = AbstractGadget.getGadget(player);
        if (!(stack.func_77973_b() instanceof GadgetBuilding)) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    @Override
    public boolean performRotate(ItemStack stack, PlayerEntity player) {
        GadgetUtils.rotateOrMirrorToolBlock(stack, player, PacketRotateMirror.Operation.ROTATE);
        return true;
    }

    @Override
    public boolean performMirror(ItemStack stack, PlayerEntity player) {
        GadgetUtils.rotateOrMirrorToolBlock(stack, player, PacketRotateMirror.Operation.MIRROR);
        return true;
    }
}

