/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.client.renders.BuildRender;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.tilesupport.ITileEntityData;
import com.direwolf20.buildinggadgets.common.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.building.view.SimpleBuildContext;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.UniqueItem;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.items.modes.ExchangingModes;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketBindTool;
import com.direwolf20.buildinggadgets.common.network.packets.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.LangUtil;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.direwolf20.buildinggadgets.common.world.MockBuilderWorld;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.PeekingIterator;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class GadgetExchanger
extends AbstractGadget {
    private static final MockBuilderWorld fakeWorld = new MockBuilderWorld();

    public GadgetExchanger() {
        super(OurItems.nonStackableItemProperties().func_200918_c(1), () -> ((ForgeConfigSpec.IntValue)Config.GADGETS.GADGET_EXCHANGER.undoSize).get(), "buildinggadgets_undo_exchanging", Reference.BlockReference.TagReference.WHITELIST_EXCHANGING, Reference.BlockReference.TagReference.BLACKLIST_EXCHANGING);
    }

    @Override
    public int getEnergyMax() {
        return (Integer)Config.GADGETS.GADGET_EXCHANGER.maxEnergy.get();
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return (Integer)Config.GADGETS.GADGET_EXCHANGER.energyCost.get();
    }

    @Override
    protected Supplier<BaseRenderer> createRenderFactory() {
        return () -> new BuildRender(true);
    }

    public int func_77619_b() {
        return 3;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_185306_r) || super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185306_r || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    private static void setToolMode(ItemStack tool, ExchangingModes mode) {
        CompoundNBT tagCompound = tool.func_196082_o();
        tagCompound.func_74778_a("mode", mode.toString());
    }

    public static ExchangingModes getToolMode(ItemStack tool) {
        CompoundNBT tagCompound = tool.func_196082_o();
        return ExchangingModes.getFromName(tagCompound.func_74779_i("mode"));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        this.addEnergyInformation(tooltip, stack);
        ExchangingModes mode = GadgetExchanger.getToolMode(stack);
        tooltip.add(TooltipTranslation.GADGET_MODE.componentTranslation(mode == ExchangingModes.SURFACE && GadgetExchanger.getConnectedArea(stack) ? TooltipTranslation.GADGET_CONNECTED.componentTranslation(new TranslationTextComponent(mode.getTranslationKey(), new Object[0]).func_150261_e()) : new TranslationTextComponent(mode.getTranslationKey(), new Object[0])).func_150255_a(Styles.AQUA));
        tooltip.add(TooltipTranslation.GADGET_BLOCK.componentTranslation(LangUtil.getFormattedBlockName(GadgetUtils.getToolBlock(stack).getState())).func_150255_a(Styles.DK_GREEN));
        int range = GadgetUtils.getToolRange(stack);
        tooltip.add(TooltipTranslation.GADGET_RANGE.componentTranslation(range, GadgetExchanger.getRangeInBlocks(range, mode.getMode())).func_150255_a(Styles.LT_PURPLE));
        tooltip.add(TooltipTranslation.GADGET_FUZZY.componentTranslation(String.valueOf(GadgetExchanger.getFuzzy(stack))).func_150255_a(Styles.GOLD));
        GadgetExchanger.addInformationRayTraceFluid(tooltip, stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (player.func_225608_bj_()) {
                ActionResult<Block> result = GadgetUtils.selectBlock(itemstack, player);
                if (!result.func_188397_a().func_226247_b_()) {
                    player.func_146105_b(MessageTranslation.INVALID_BLOCK.componentTranslation(((Block)result.func_188398_b()).getRegistryName()).func_150255_a(Styles.AQUA), true);
                    return super.func_77659_a(world, player, hand);
                }
            } else if (player instanceof ServerPlayerEntity) {
                this.exchange((ServerPlayerEntity)player, itemstack);
            }
        } else if (!player.func_225608_bj_()) {
            BaseRenderer.updateInventoryCache();
        } else if (Screen.hasControlDown()) {
            PacketHandler.sendToServer(new PacketBindTool());
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public void setMode(ItemStack heldItem, int modeInt) {
        ExchangingModes mode = ExchangingModes.values()[modeInt];
        GadgetExchanger.setToolMode(heldItem, mode);
    }

    public static void rangeChange(PlayerEntity player, ItemStack heldItem) {
        int changeAmount;
        int range = GadgetUtils.getToolRange(heldItem);
        int n = changeAmount = GadgetExchanger.getToolMode(heldItem) == ExchangingModes.GRID || range % 2 == 0 ? 1 : 2;
        range = player.func_225608_bj_() ? (range <= 1 ? (Integer)Config.GADGETS.maxRange.get() : range - changeAmount) : (range >= (Integer)Config.GADGETS.maxRange.get() ? 1 : range + changeAmount);
        GadgetUtils.setToolRange(heldItem, range);
        player.func_146105_b(MessageTranslation.RANGE_SET.componentTranslation(range).func_150255_a(Styles.AQUA), true);
    }

    private void exchange(ServerPlayerEntity player, ItemStack stack) {
        ServerWorld world = player.func_71121_q();
        ItemStack heldItem = GadgetExchanger.getGadget((PlayerEntity)player);
        if (heldItem.func_190926_b()) {
            return;
        }
        BlockData blockData = GadgetUtils.getToolBlock(heldItem);
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt((PlayerEntity)player, stack);
        TileEntity tileEntity = world.func_175625_s(lookingAt.func_216350_a());
        Block lookAtBlock = player.field_70170_p.func_180495_p(lookingAt.func_216350_a()).func_177230_c();
        if (blockData.getState() == Blocks.field_150350_a.func_176223_P() || lookAtBlock == OurBlocks.EFFECT_BLOCK.get() || blockData.getState().func_177230_c() == lookAtBlock || tileEntity != null) {
            return;
        }
        Optional<List<BlockPos>> anchor = GadgetUtils.getAnchor(stack);
        List coords = anchor.orElseGet(() -> GadgetExchanger.getToolMode(stack).getMode().getCollection(new AbstractMode.UseContext((World)world, blockData.getState(), lookingAt.func_216350_a(), heldItem, lookingAt.func_216354_b()), (PlayerEntity)player));
        if (anchor.isPresent()) {
            GadgetUtils.setAnchor(stack);
        }
        IItemIndex index = InventoryHelper.index(stack, (PlayerEntity)player);
        if (blockData.getState() != Blocks.field_150350_a.func_176223_P()) {
            fakeWorld.setWorldAndState(player.field_70170_p, blockData.getState(), coords);
            for (BlockPos coordinate : coords) {
                this.exchangeBlock(world, player, index, coordinate, blockData);
            }
        }
    }

    private boolean exchangeBlock(ServerWorld world, ServerPlayerEntity player, IItemIndex index, BlockPos pos, BlockData setBlock) {
        ITileEntityData data;
        BlockState currentBlock = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ConstructionBlockTileEntity) {
            data = ((ConstructionBlockTileEntity)te).getConstructionBlockData().getTileData();
            currentBlock = ((ConstructionBlockTileEntity)te).getConstructionBlockData().getState();
        } else {
            data = TileSupport.createTileData((IBlockReader)world, pos);
        }
        ItemStack tool = GadgetExchanger.getGadget((PlayerEntity)player);
        if (tool.func_190926_b()) {
            return false;
        }
        SimpleBuildContext buildContext = SimpleBuildContext.builder().usedStack(tool).buildingPlayer((PlayerEntity)player).build((IWorld)world);
        MaterialList requiredItems = setBlock.getRequiredItems(buildContext, null, pos);
        MatchResult match = index.tryMatch(requiredItems);
        boolean useConstructionPaste = false;
        if (!match.isSuccess()) {
            if (setBlock.getState().hasTileEntity()) {
                return false;
            }
            match = index.tryMatch(InventoryHelper.PASTE_LIST);
            if (!match.isSuccess()) {
                return false;
            }
            useConstructionPaste = true;
        }
        if (!player.func_175142_cm()) {
            return false;
        }
        if (!world.func_175660_a((PlayerEntity)player, pos)) {
            return false;
        }
        BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((IWorld)world, (BlockPos)pos);
        if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blockSnapshot, (Direction)Direction.UP)) {
            return false;
        }
        BlockEvent.BreakEvent e = new BlockEvent.BreakEvent((World)world, pos, currentBlock, (PlayerEntity)player);
        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
            return false;
        }
        if (!this.canUse(tool, (PlayerEntity)player)) {
            return false;
        }
        this.applyDamage(tool, player);
        if (index.applyMatch(match)) {
            MaterialList materials = te instanceof ConstructionBlockTileEntity ? InventoryHelper.PASTE_LIST : data.getRequiredItems(buildContext, currentBlock, (RayTraceResult)world.func_217299_a(new RayTraceContext(player.func_213303_ch(), new Vec3d((Vec3i)pos), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player)), pos);
            PeekingIterator<ImmutableMultiset<IUniqueObject<?>>> it = materials.iterator();
            LinkedHashMultiset producedItems = LinkedHashMultiset.create();
            if (buildContext.getUsedStack().func_77948_v() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)buildContext.getUsedStack()) > 0) {
                producedItems = it.hasNext() ? (Multiset)it.next() : ImmutableMultiset.of();
            } else {
                List drops = Block.func_220070_a((BlockState)currentBlock, (ServerWorld)((ServerWorld)buildContext.getWorld()), (BlockPos)pos, (TileEntity)buildContext.getWorld().func_175625_s(pos));
                producedItems.addAll((Collection)drops.stream().map(UniqueItem::ofStack).collect(Collectors.toList()));
            }
            index.insert((Multiset<IUniqueObject<?>>)producedItems);
            EffectBlock.spawnEffectBlock((IWorld)world, pos, setBlock, EffectBlock.Mode.REPLACE, useConstructionPaste);
            return true;
        }
        return false;
    }

    public static ItemStack getGadget(PlayerEntity player) {
        ItemStack stack = AbstractGadget.getGadget(player);
        if (!(stack.func_77973_b() instanceof GadgetExchanger)) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }

    @Override
    public boolean performRotate(ItemStack stack, PlayerEntity player) {
        GadgetUtils.rotateOrMirrorToolBlock(stack, player, PacketRotateMirror.Operation.ROTATE);
        return true;
    }

    @Override
    public boolean performMirror(ItemStack stack, PlayerEntity player) {
        GadgetUtils.rotateOrMirrorToolBlock(stack, player, PacketRotateMirror.Operation.MIRROR);
        return true;
    }
}

