/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketCopyCoords {
    private final BlockPos start;
    private final BlockPos end;

    public PacketCopyCoords(BlockPos start, BlockPos end) {
        this.start = start;
        this.end = end;
    }

    public static void encode(PacketCopyCoords msg, PacketBuffer buffer) {
        buffer.func_179255_a(msg.start);
        buffer.func_179255_a(msg.end);
    }

    public static PacketCopyCoords decode(PacketBuffer buffer) {
        return new PacketCopyCoords(buffer.func_179259_c(), buffer.func_179259_c());
    }

    public static class Handler {
        public static void handle(PacketCopyCoords msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayerEntity playerEntity = ctx.get().getSender();
            if (playerEntity == null) {
                return;
            }
            ctx.get().enqueueWork(() -> {
                ItemStack heldItem = GadgetCopyPaste.getGadget((PlayerEntity)playerEntity);
                if (heldItem.func_190926_b()) {
                    return;
                }
                BlockPos startPos = msg.start;
                BlockPos endPos = msg.end;
                if (startPos.equals((Object)BlockPos.field_177992_a) && endPos.equals((Object)BlockPos.field_177992_a)) {
                    GadgetCopyPaste.setSelectedRegion(heldItem, null);
                    playerEntity.func_146105_b(MessageTranslation.AREA_RESET.componentTranslation(new Object[0]).func_150255_a(Styles.AQUA), true);
                } else {
                    GadgetCopyPaste.setSelectedRegion(heldItem, new Region((Vec3i)startPos, (Vec3i)endPos));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

