/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tileentities;

import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.tileentities.OurTileEntities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;

public class EffectBlockTileEntity
extends TileEntity
implements ITickableTileEntity {
    private BlockData renderedBlock;
    private BlockData sourceBlock;
    private EffectBlock.Mode mode = null;
    private boolean usePaste;
    private int ticks;

    public EffectBlockTileEntity() {
        super((TileEntityType)OurTileEntities.EFFECT_BLOCK_TILE_ENTITY.get());
    }

    public void initializeData(BlockState curState, @Nullable TileEntity te, BlockData replacementBlock, EffectBlock.Mode mode, boolean usePaste) {
        this.ticks = 0;
        this.sourceBlock = replacementBlock;
        this.mode = mode;
        this.usePaste = usePaste;
        this.renderedBlock = mode == EffectBlock.Mode.REPLACE ? (te instanceof ConstructionBlockTileEntity ? ((ConstructionBlockTileEntity)te).getConstructionBlockData() : TileSupport.createBlockData(curState, te)) : (te instanceof ConstructionBlockTileEntity ? ((ConstructionBlockTileEntity)te).getConstructionBlockData() : replacementBlock);
    }

    public void func_73660_a() {
        ++this.ticks;
        if (this.ticks >= this.getLifespan()) {
            this.complete();
        }
    }

    private void complete() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K || this.mode == null || this.renderedBlock == null) {
            return;
        }
        this.mode.onBuilderRemoved(this);
    }

    public BlockData getRenderedBlock() {
        return this.renderedBlock;
    }

    public BlockData getSourceBlock() {
        return this.sourceBlock;
    }

    public EffectBlock.Mode getReplacementMode() {
        return this.mode;
    }

    public boolean isUsingPaste() {
        return this.usePaste;
    }

    public int getTicksExisted() {
        return this.ticks;
    }

    public int getLifespan() {
        return 20;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.func_145839_a(tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        if (this.mode != null && this.renderedBlock != null && this.sourceBlock != null) {
            compound.func_74768_a("ticks", this.ticks);
            compound.func_74768_a("mode", this.mode.ordinal());
            compound.func_218657_a("replacement_block", (INBT)this.renderedBlock.serialize(true));
            compound.func_218657_a("source_block", (INBT)this.sourceBlock.serialize(true));
            compound.func_74757_a("use_paste", this.usePaste);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(@Nonnull CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("ticks", 3) && compound.func_150297_b("mode", 3) && compound.func_150297_b("source_block", 10) && compound.func_150297_b("replacement_block", 10) && compound.func_74764_b("use_paste")) {
            this.ticks = compound.func_74762_e("ticks");
            this.mode = EffectBlock.Mode.VALUES[compound.func_74762_e("mode")];
            this.renderedBlock = BlockData.tryDeserialize(compound.func_74775_l("replacement_block"), true);
            this.sourceBlock = BlockData.tryDeserialize(compound.func_74775_l("source_block"), true);
            this.usePaste = compound.func_74767_n("use_paste");
        }
    }
}

