/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util;

import com.direwolf20.buildinggadgets.client.events.EventTooltip;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.InventoryWrapper;
import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.network.packets.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.template.Template;
import com.direwolf20.buildinggadgets.common.template.TemplateHeader;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.exceptions.CapabilityNotPresentException;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.tools.NetworkIO;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class GadgetUtils {
    private static final ImmutableList<String> LINK_STARTS = ImmutableList.of((Object)"http", (Object)"www");

    public static boolean mightBeLink(String s) {
        return LINK_STARTS.stream().anyMatch(s::startsWith);
    }

    public static void addTooltipNameAndAuthor(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip) {
        if (world != null) {
            world.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).ifPresent(provider -> stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> {
                Template template = provider.getTemplateForKey((ITemplateKey)key);
                TemplateHeader header = template.getHeader();
                if (header.getName() != null && !header.getName().isEmpty()) {
                    tooltip.add(TooltipTranslation.TEMPLATE_NAME.componentTranslation(header.getName()).func_150255_a(Styles.AQUA));
                }
                if (header.getAuthor() != null && !header.getAuthor().isEmpty()) {
                    tooltip.add(TooltipTranslation.TEMPLATE_AUTHOR.componentTranslation(header.getAuthor()).func_150255_a(Styles.AQUA));
                }
            }));
        }
        EventTooltip.addTemplatePadding(stack, tooltip);
    }

    @Nullable
    public static ByteArrayOutputStream getPasteStream(@Nonnull CompoundNBT compound, @Nullable String name) throws IOException {
        CompoundNBT withText;
        CompoundNBT compoundNBT = withText = name != null && !name.isEmpty() ? compound.func_74737_b() : compound;
        if (name != null && !name.isEmpty()) {
            withText.func_74778_a("template_name", name);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompressedStreamTools.func_74799_a((CompoundNBT)withText, (OutputStream)baos);
        return baos.size() < 32567 ? baos : null;
    }

    public static void setAnchor(ItemStack stack) {
        GadgetUtils.setAnchor(stack, new ArrayList<BlockPos>());
    }

    public static void setAnchor(ItemStack stack, List<BlockPos> coordinates) {
        CompoundNBT tagCompound = stack.func_196082_o();
        tagCompound.func_218657_a("anchor_coords", (INBT)coordinates.stream().map(NBTUtil::func_186859_a).collect(Collectors.toCollection(ListNBT::new)));
        stack.func_77982_d(tagCompound);
    }

    public static Optional<List<BlockPos>> getAnchor(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return Optional.empty();
        }
        ListNBT coordList = (ListNBT)tagCompound.func_74781_a("anchor_coords");
        if (coordList == null || coordList.size() == 0) {
            return Optional.empty();
        }
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        for (int i = 0; i < coordList.size(); ++i) {
            coordinates.add(NBTUtil.func_186861_c((CompoundNBT)coordList.func_150305_b(i)));
        }
        return Optional.of(coordinates);
    }

    public static void setToolRange(ItemStack stack, int range) {
        CompoundNBT tagCompound = stack.func_196082_o();
        tagCompound.func_74768_a("range", range);
    }

    public static int getToolRange(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_196082_o();
        return MathHelper.func_76125_a((int)tagCompound.func_74762_e("range"), (int)1, (int)15);
    }

    public static BlockData rotateOrMirrorBlock(PlayerEntity player, PacketRotateMirror.Operation operation, BlockData data) {
        if (operation == PacketRotateMirror.Operation.MIRROR) {
            return data.mirror(player.func_174811_aO().func_176740_k() == Direction.Axis.X ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK);
        }
        return data.rotate(Rotation.CLOCKWISE_90);
    }

    public static void rotateOrMirrorToolBlock(ItemStack stack, PlayerEntity player, PacketRotateMirror.Operation operation) {
        GadgetUtils.setToolBlock(stack, GadgetUtils.rotateOrMirrorBlock(player, operation, GadgetUtils.getToolBlock(stack)));
        GadgetUtils.setToolActualBlock(stack, GadgetUtils.rotateOrMirrorBlock(player, operation, GadgetUtils.getToolActualBlock(stack)));
    }

    private static void setToolBlock(ItemStack stack, @Nullable BlockData data) {
        CompoundNBT tagCompound = stack.func_196082_o();
        if (data == null) {
            data = BlockData.AIR;
        }
        CompoundNBT stateTag = data.serialize(true);
        tagCompound.func_218657_a("state", (INBT)stateTag);
        stack.func_77982_d(tagCompound);
    }

    private static void setToolActualBlock(ItemStack stack, @Nullable BlockData data) {
        CompoundNBT tagCompound = stack.func_196082_o();
        if (data == null) {
            data = BlockData.AIR;
        }
        CompoundNBT dataTag = data.serialize(true);
        tagCompound.func_218657_a("state_actual", (INBT)dataTag);
        stack.func_77982_d(tagCompound);
    }

    @Nonnull
    public static BlockData getToolBlock(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_196082_o();
        BlockData res = BlockData.tryDeserialize(tagCompound.func_74775_l("state"), true);
        if (res == null) {
            GadgetUtils.setToolActualBlock(stack, BlockData.AIR);
            return BlockData.AIR;
        }
        return res;
    }

    @Nonnull
    public static BlockData getToolActualBlock(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_196082_o();
        BlockData res = BlockData.tryDeserialize(tagCompound.func_74775_l("state_actual"), true);
        if (res == null) {
            GadgetUtils.setToolActualBlock(stack, BlockData.AIR);
            return BlockData.AIR;
        }
        return res;
    }

    public static void bindToolToTE(ItemStack stack, PlayerEntity player) {
        World world = player.field_70170_p;
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, AbstractGadget.shouldRayTraceFluid(stack) ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE);
        if (world.func_180495_p(VectorHelper.getLookingAt(player, stack).func_216350_a()) == Blocks.field_150350_a.func_176223_P()) {
            return;
        }
        ActionResultType result = GadgetUtils.setRemoteInventory(stack, player, world, lookingAt.func_216350_a(), true);
    }

    public static ActionResult<Block> selectBlock(ItemStack stack, PlayerEntity player) {
        World world = player.field_70170_p;
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, AbstractGadget.shouldRayTraceFluid(stack) ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE);
        if (world.func_175623_d(lookingAt.func_216350_a())) {
            return ActionResult.func_226251_d_((Object)Blocks.field_150350_a);
        }
        BlockState state = world.func_180495_p(lookingAt.func_216350_a());
        if (!((AbstractGadget)stack.func_77973_b()).isAllowedBlock(state.func_177230_c()) || state.func_177230_c() instanceof EffectBlock) {
            return ActionResult.func_226251_d_((Object)state.func_177230_c());
        }
        Optional<BlockData> data = InventoryHelper.getSafeBlockData(player, lookingAt.func_216350_a(), player.func_184600_cs());
        data.ifPresent(placeState -> {
            BlockState actualState = placeState.getState();
            GadgetUtils.setToolBlock(stack, placeState);
            GadgetUtils.setToolActualBlock(stack, new BlockData(actualState, placeState.getTileData()));
        });
        return ActionResult.func_226248_a_((Object)state.func_177230_c());
    }

    public static ActionResultType setRemoteInventory(ItemStack stack, PlayerEntity player, World world, BlockPos pos, boolean setTool) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return ActionResultType.PASS;
        }
        if (setTool && te instanceof ConstructionBlockTileEntity) {
            ((ConstructionBlockTileEntity)te).getConstructionBlockData();
            GadgetUtils.setToolBlock(stack, ((ConstructionBlockTileEntity)te).getActualBlockData());
            GadgetUtils.setToolActualBlock(stack, ((ConstructionBlockTileEntity)te).getActualBlockData());
            return ActionResultType.SUCCESS;
        }
        if (GadgetUtils.setRemoteInventory(player, stack, pos, world)) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public static boolean anchorBlocks(PlayerEntity player, ItemStack stack) {
        Optional<List<BlockPos>> anchorCoords = GadgetUtils.getAnchor(stack);
        if (anchorCoords.isPresent()) {
            GadgetUtils.setAnchor(stack);
            player.func_146105_b(MessageTranslation.ANCHOR_REMOVED.componentTranslation(new Object[0]).func_150255_a(Styles.AQUA), true);
            return true;
        }
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, stack);
        BlockPos startBlock = lookingAt.func_216350_a();
        Direction sideHit = lookingAt.func_216354_b();
        if (player.field_70170_p.func_175623_d(startBlock)) {
            return false;
        }
        BlockData blockData = GadgetUtils.getToolBlock(stack);
        AbstractMode.UseContext context = new AbstractMode.UseContext(player.field_70170_p, blockData.getState(), startBlock, stack, sideHit, stack.func_77973_b() instanceof GadgetBuilding && GadgetBuilding.shouldPlaceAtop(stack));
        List<BlockPos> coords = stack.func_77973_b() instanceof GadgetBuilding ? GadgetBuilding.getToolMode(stack).getMode().getCollection(context, player) : GadgetExchanger.getToolMode(stack).getMode().getCollection(context, player);
        GadgetUtils.setAnchor(stack, coords);
        player.func_146105_b(MessageTranslation.ANCHOR_SET.componentTranslation(new Object[0]).func_150255_a(Styles.AQUA), true);
        return true;
    }

    public static boolean setRemoteInventory(PlayerEntity player, ItemStack tool, BlockPos pos, World world) {
        if (GadgetUtils.getRemoteInventory(pos, DimensionType.func_212678_a((DimensionType)player.field_71093_bK), world) != null) {
            boolean same = pos.equals((Object)GadgetUtils.getPOSFromNBT(tool, "bound_te_pos"));
            GadgetUtils.writePOSToNBT(tool, same ? null : pos, "bound_te_pos", player.field_71093_bK);
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.AQUA + new TranslationTextComponent(same ? MessageTranslation.UNBOUND_TO_TILE.getTranslationKey() : MessageTranslation.BOUND_TO_TILE.getTranslationKey(), new Object[0]).func_150261_e()), true);
            return true;
        }
        return false;
    }

    @Nullable
    public static IItemHandler getRemoteInventory(ItemStack tool, World world) {
        return GadgetUtils.getRemoteInventory(tool, world, NetworkIO.Operation.EXTRACT);
    }

    @Nullable
    public static IItemHandler getRemoteInventory(ItemStack tool, World world, NetworkIO.Operation operation) {
        ResourceLocation dim = GadgetUtils.getDIMFromNBT(tool, "bound_te_pos");
        if (dim == null) {
            return null;
        }
        BlockPos pos = GadgetUtils.getPOSFromNBT(tool, "bound_te_pos");
        return pos == null ? null : GadgetUtils.getRemoteInventory(pos, dim, world);
    }

    @Nullable
    public static IItemHandler getRemoteInventory(BlockPos pos, ResourceLocation dim, World world) {
        return GadgetUtils.getRemoteInventory(pos, dim, world, NetworkIO.Operation.EXTRACT);
    }

    @Nullable
    public static IItemHandler getRemoteInventory(BlockPos pos, ResourceLocation dimName, World world, NetworkIO.Operation operation) {
        DimensionType dim = DimensionType.func_193417_a((ResourceLocation)dimName);
        if (dim == null) {
            return null;
        }
        MinecraftServer server = world.func_73046_m();
        if (server == null) {
            return null;
        }
        ServerWorld worldServer = server.func_71218_a(dim);
        return GadgetUtils.getRemoteInventory(pos, (World)worldServer, operation);
    }

    @Nullable
    public static IItemHandler getRemoteInventory(BlockPos pos, World world, NetworkIO.Operation operation) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        LazyOptional cap = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!cap.isPresent()) {
            return null;
        }
        return (IItemHandler)cap.orElseThrow(CapabilityNotPresentException::new);
    }

    public static String withSuffix(int count) {
        if (count < 1000) {
            return "" + count;
        }
        int exp = (int)(Math.log(count) / Math.log(1000.0));
        return String.format("%.1f%c", (double)count / Math.pow(1000.0, exp), Character.valueOf("kMGTPE".charAt(exp - 1)));
    }

    public static void writePOSToNBT(ItemStack stack, @Nullable BlockPos pos, String tagName) {
        CompoundNBT tagCompound = stack.func_196082_o();
        if (pos == null) {
            if (tagCompound.func_74781_a(tagName) != null) {
                tagCompound.func_82580_o(tagName);
                stack.func_77982_d(tagCompound);
            }
            return;
        }
        tagCompound.func_218657_a(tagName, (INBT)NBTUtil.func_186859_a((BlockPos)pos));
        stack.func_77982_d(tagCompound);
    }

    public static void writePOSToNBT(ItemStack stack, @Nullable BlockPos pos, String tagName, DimensionType dimension) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if (pos == null) {
            tagCompound.func_74781_a(tagName);
            tagCompound.func_82580_o(tagName);
            stack.func_77982_d(tagCompound);
            return;
        }
        CompoundNBT posTag = NBTUtil.func_186859_a((BlockPos)pos);
        posTag.func_74778_a("dim", DimensionType.func_212678_a((DimensionType)dimension).toString());
        tagCompound.func_218657_a(tagName, (INBT)posTag);
        stack.func_77982_d(tagCompound);
    }

    @Nullable
    public static BlockPos getPOSFromNBT(ItemStack stack, String tagName) {
        CompoundNBT stackTag = stack.func_196082_o();
        if (!stackTag.func_74764_b(tagName)) {
            return null;
        }
        CompoundNBT posTag = stack.func_196082_o().func_74775_l(tagName);
        if (posTag.isEmpty()) {
            return null;
        }
        return NBTUtil.func_186861_c((CompoundNBT)posTag);
    }

    @Nullable
    public static ResourceLocation getDIMFromNBT(ItemStack stack, String tagName) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        CompoundNBT posTag = tagCompound.func_74775_l(tagName);
        if (posTag.equals((Object)new CompoundNBT())) {
            return null;
        }
        return new ResourceLocation(posTag.func_74779_i("dim"));
    }

    public static void dropTileEntityInventory(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            LazyOptional cap = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            cap.ifPresent(handler -> {
                if (handler instanceof IItemHandlerModifiable) {
                    net.minecraft.inventory.InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)new InventoryWrapper((IItemHandlerModifiable)handler));
                }
            });
        }
    }
}

