/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.cache;

import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketSetRemoteInventoryCache;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.tools.UniqueItem;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Multiset;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class RemoteInventoryCache {
    private boolean isCopyPaste;
    private boolean forceUpdate;
    private Pair<ResourceLocation, BlockPos> locCached;
    private Multiset<UniqueItem> cache;
    private Stopwatch timer;

    public RemoteInventoryCache(boolean isCopyPaste) {
        this.isCopyPaste = isCopyPaste;
    }

    public void setCache(Multiset<UniqueItem> cache) {
        this.cache = cache;
    }

    public void forceUpdate() {
        this.forceUpdate = true;
    }

    public int countItem(ItemStack tool, ItemStack stack) {
        Pair<ResourceLocation, BlockPos> loc = this.getInventoryLocation(tool);
        if (this.isCacheOld(loc)) {
            this.updateCache(loc);
        }
        return this.cache == null ? 0 : this.cache.count((Object)new UniqueItem(stack.func_77973_b()));
    }

    private void updateCache(Pair<ResourceLocation, BlockPos> loc) {
        this.locCached = loc;
        if (loc == null) {
            this.cache = null;
        } else {
            PacketHandler.sendToServer(new PacketSetRemoteInventoryCache(loc, this.isCopyPaste));
        }
    }

    private boolean isCacheOld(@Nullable Pair<ResourceLocation, BlockPos> loc) {
        if (!Objects.equals(this.locCached, loc)) {
            this.timer = loc == null ? null : Stopwatch.createStarted();
            return true;
        }
        if (this.timer != null) {
            boolean overtime;
            boolean bl = overtime = this.forceUpdate || this.timer.elapsed(TimeUnit.MILLISECONDS) >= 5000L;
            if (overtime) {
                this.timer.reset();
                this.timer.start();
                this.forceUpdate = false;
            }
            return overtime;
        }
        return false;
    }

    @Nullable
    private Pair<ResourceLocation, BlockPos> getInventoryLocation(ItemStack stack) {
        ResourceLocation dim = GadgetUtils.getDIMFromNBT(stack, "bound_te_pos");
        BlockPos pos = GadgetUtils.getPOSFromNBT(stack, "bound_te_pos");
        return dim == null || pos == null ? null : new ImmutablePair((Object)dim, (Object)pos);
    }
}

