/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.renders;

import com.direwolf20.buildinggadgets.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.tainted.inventory.RecordingItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class BuildRender
extends BaseRenderer {
    private final boolean isExchanger;
    private static final BlockState DEFAULT_EFFECT_BLOCK = ((Block)OurBlocks.EFFECT_BLOCK.get()).func_176223_P();

    public BuildRender(boolean isExchanger) {
        this.isExchanger = isExchanger;
    }

    @Override
    public void render(RenderWorldLastEvent evt, PlayerEntity player, ItemStack heldItem) {
        super.render(evt, player, heldItem);
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, heldItem);
        BlockState state = AIR;
        Optional<List<BlockPos>> anchor = GadgetUtils.getAnchor(heldItem);
        BlockState startBlock = player.field_70170_p.func_180495_p(lookingAt.func_216350_a());
        if (player.field_70170_p.func_175623_d(lookingAt.func_216350_a()) && !anchor.isPresent() || startBlock == DEFAULT_EFFECT_BLOCK) {
            return;
        }
        BlockData data = GadgetUtils.getToolBlock(heldItem);
        BlockState renderBlockState = data.getState();
        if (renderBlockState == BaseRenderer.AIR) {
            return;
        }
        List coordinates = anchor.orElseGet(() -> {
            AbstractMode mode = !this.isExchanger ? GadgetBuilding.getToolMode(heldItem).getMode() : GadgetExchanger.getToolMode(heldItem).getMode();
            return mode.getCollection(new AbstractMode.UseContext(player.field_70170_p, renderBlockState, lookingAt.func_216350_a(), heldItem, lookingAt.func_216354_b(), !this.isExchanger && GadgetBuilding.shouldPlaceAtop(heldItem)), player);
        });
        BuildRender.getBuilderWorld().setWorldAndState(player.field_70170_p, renderBlockState, coordinates);
        Vector3d playerPos = BuildRender.getMc().field_71460_t.func_215316_n().func_216785_c();
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        MatrixStack matrix = evt.getMatrixStack();
        matrix.func_227860_a_();
        matrix.func_227861_a_(-playerPos.func_82615_a(), -playerPos.func_82617_b(), -playerPos.func_82616_c());
        BlockRendererDispatcher dispatcher = BuildRender.getMc().func_175602_ab();
        for (BlockPos coordinate : coordinates) {
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)coordinate.func_177958_n(), (double)coordinate.func_177956_o(), (double)coordinate.func_177952_p());
            if (this.isExchanger) {
                matrix.func_227861_a_((double)-5.0E-4f, (double)-5.0E-4f, (double)-5.0E-4f);
                matrix.func_227862_a_(1.001f, 1.001f, 1.001f);
            }
            state = renderBlockState;
            OurRenderTypes.MultiplyAlphaRenderTypeBuffer mutatedBuffer = new OurRenderTypes.MultiplyAlphaRenderTypeBuffer((IRenderTypeBuffer)Minecraft.func_71410_x().func_228019_au_().func_228487_b_(), 0.55f);
            dispatcher.renderBlock(state, matrix, (IRenderTypeBuffer)mutatedBuffer, 0xF00000, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
            matrix.func_227865_b_();
            RenderSystem.disableDepthTest();
            buffer.func_228461_a_();
        }
        if (!player.func_184812_l_()) {
            RecordingItemIndex index = new RecordingItemIndex(InventoryHelper.index(heldItem, player));
            MaterialList materials = data.getRequiredItems(new BuildContext((IWorld)player.field_70170_p, player, heldItem), null, null);
            int hasEnergy = this.getEnergy(player, heldItem);
            LazyOptional energyCap = heldItem.getCapability(CapabilityEnergy.ENERGY);
            for (BlockPos coordinate : coordinates) {
                if (energyCap.isPresent()) {
                    hasEnergy -= ((AbstractGadget)heldItem.func_77973_b()).getEnergyCost(heldItem);
                }
                IVertexBuilder builder = buffer.getBuffer(OurRenderTypes.MissingBlockOverlay);
                MatchResult match = index.tryMatch(materials);
                if (!match.isSuccess()) {
                    match = index.tryMatch(InventoryHelper.PASTE_LIST);
                }
                if (!match.isSuccess() || hasEnergy < 0) {
                    BuildRender.renderMissingBlock(matrix.func_227866_c_().func_227870_a_(), builder, coordinate);
                    continue;
                }
                index.applyMatch(match);
                BuildRender.renderBoxSolid(matrix.func_227866_c_().func_227870_a_(), builder, coordinate, 0.97f, 1.0f, 0.99f, 0.1f);
            }
        }
        matrix.func_227865_b_();
        RenderSystem.disableDepthTest();
        buffer.func_228461_a_();
    }

    @Override
    public boolean isLinkable() {
        return true;
    }
}

