/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.blocks;

import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.entities.ConstructionBlockEntity;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.tileentities.EffectBlockTileEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EffectBlock
extends Block {
    private static final Material EFFECT_BLOCK_MATERIAL = new Material.Builder(MaterialColor.field_151660_b).func_200502_b().func_200506_i();

    public static void spawnUndoBlock(BuildContext context, PlacementTarget target) {
        BlockState state = context.getWorld().func_180495_p(target.getPos());
        TileEntity curTe = context.getWorld().func_175625_s(target.getPos());
        if (target.getData().getState() != Blocks.field_150350_a.func_176223_P()) {
            Mode mode = state.isAir((IBlockReader)context.getWorld(), target.getPos()) ? Mode.PLACE : Mode.REPLACE;
            EffectBlock.spawnEffectBlock(curTe, state, context.getWorld(), target.getPos(), target.getData(), mode, false);
        } else if (!state.isAir((IBlockReader)context.getWorld(), target.getPos())) {
            EffectBlock.spawnEffectBlock(curTe, state, context.getWorld(), target.getPos(), TileSupport.createBlockData(state, curTe), Mode.REMOVE, false);
        }
    }

    public static void spawnEffectBlock(BuildContext context, PlacementTarget target, Mode mode, boolean usePaste) {
        EffectBlock.spawnEffectBlock(context.getWorld(), target.getPos(), target.getData(), mode, usePaste);
    }

    public static void spawnEffectBlock(IWorld world, BlockPos spawnPos, BlockData spawnBlock, Mode mode, boolean usePaste) {
        BlockState state = world.func_180495_p(spawnPos);
        TileEntity curTe = world.func_175625_s(spawnPos);
        EffectBlock.spawnEffectBlock(curTe, state, world, spawnPos, spawnBlock, mode, usePaste);
    }

    private static void spawnEffectBlock(@Nullable TileEntity curTe, BlockState curState, IWorld world, BlockPos spawnPos, BlockData spawnBlock, Mode mode, boolean usePaste) {
        BlockState state = ((Block)OurBlocks.EFFECT_BLOCK.get()).func_176223_P();
        world.func_180501_a(spawnPos, state, 3);
        assert (world.func_175625_s(spawnPos) != null);
        ((EffectBlockTileEntity)world.func_175625_s(spawnPos)).initializeData(curState, curTe, spawnBlock, mode, usePaste);
        if (world instanceof World) {
            ((World)world).func_184138_a(spawnPos, state, state, 3);
        }
    }

    public EffectBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)EFFECT_BLOCK_MATERIAL).func_200943_b(20.0f).func_226896_b_().func_222380_e());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EffectBlockTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public boolean func_200122_a(BlockState p_200122_1_, BlockState p_200122_2_, Direction p_200122_3_) {
        return true;
    }

    public List<ItemStack> func_220076_a(BlockState p_220076_1_, LootContext.Builder p_220076_2_) {
        return new ArrayList<ItemStack>();
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public static enum Mode {
        PLACE{

            @Override
            public void onBuilderRemoved(EffectBlockTileEntity builder) {
                World world = builder.func_145831_w();
                if (world == null) {
                    return;
                }
                BlockPos targetPos = builder.func_174877_v();
                BlockData targetBlock = builder.getRenderedBlock();
                if (builder.isUsingPaste()) {
                    world.func_175656_a(targetPos, ((Block)OurBlocks.CONSTRUCTION_BLOCK.get()).func_176223_P());
                    TileEntity te = world.func_175625_s(targetPos);
                    if (te instanceof ConstructionBlockTileEntity) {
                        ((ConstructionBlockTileEntity)te).setBlockState(targetBlock, targetBlock);
                    }
                    world.func_217376_c((Entity)new ConstructionBlockEntity(world, targetPos, false));
                } else {
                    world.func_217377_a(targetPos, false);
                    if (targetBlock.getState().func_177230_c() instanceof LeavesBlock) {
                        targetBlock = new BlockData((BlockState)targetBlock.getState().func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true)), targetBlock.getTileData());
                    }
                    targetBlock.placeIn(BuildContext.builder().build((IWorld)world), targetPos);
                    BlockPos upPos = targetPos.func_177984_a();
                    world.func_180495_p(targetPos).func_215697_a(world, targetPos, world.func_180495_p(upPos).func_177230_c(), upPos, false);
                }
            }
        }
        ,
        REMOVE{

            @Override
            public void onBuilderRemoved(EffectBlockTileEntity builder) {
                builder.func_145831_w().func_217377_a(builder.func_174877_v(), false);
            }
        }
        ,
        REPLACE{

            @Override
            public void onBuilderRemoved(EffectBlockTileEntity builder) {
                EffectBlock.spawnEffectBlock((IWorld)builder.func_145831_w(), builder.func_174877_v(), builder.getSourceBlock(), PLACE, builder.isUsingPaste());
            }
        };

        public static final Mode[] VALUES;

        public abstract void onBuilderRemoved(EffectBlockTileEntity var1);

        static {
            VALUES = Mode.values();
        }
    }
}

