/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.util.tools.UniqueItem;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSetRemoteInventoryCache {
    private boolean isCopyPaste;
    private Multiset<UniqueItem> cache;
    private Pair<ResourceLocation, BlockPos> loc;

    public PacketSetRemoteInventoryCache(Multiset<UniqueItem> cache, boolean isCopyPaste) {
        this.cache = cache;
        this.isCopyPaste = isCopyPaste;
    }

    public PacketSetRemoteInventoryCache(Pair<ResourceLocation, BlockPos> loc, boolean isCopyPaste) {
        this.loc = loc;
        this.isCopyPaste = isCopyPaste;
    }

    public static PacketSetRemoteInventoryCache decode(PacketBuffer buf) {
        boolean isCopyPaste = buf.readBoolean();
        if (buf.readBoolean()) {
            ImmutablePair loc = new ImmutablePair((Object)buf.func_192575_l(), (Object)buf.func_179259_c());
            return new PacketSetRemoteInventoryCache((Pair<ResourceLocation, BlockPos>)loc, isCopyPaste);
        }
        int len = buf.readInt();
        ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
        for (int i = 0; i < len; ++i) {
            builder.addCopies((Object)new UniqueItem(Item.func_150899_d((int)buf.readInt())), buf.readInt());
        }
        ImmutableMultiset cache = builder.build();
        return new PacketSetRemoteInventoryCache((Multiset<UniqueItem>)cache, isCopyPaste);
    }

    public static void encode(PacketSetRemoteInventoryCache msg, PacketBuffer buf) {
        buf.writeBoolean(msg.isCopyPaste());
        boolean isRequest = msg.getCache() == null;
        buf.writeBoolean(isRequest);
        if (isRequest) {
            buf.func_192572_a((ResourceLocation)msg.getLoc().getLeft());
            buf.writeLong(((BlockPos)msg.getLoc().getRight()).func_218275_a());
            return;
        }
        Set items = msg.getCache().entrySet();
        buf.writeInt(items.size());
        for (Multiset.Entry entry : items) {
            UniqueItem uniqueItem = (UniqueItem)entry.getElement();
            buf.writeInt(Item.func_150891_b((Item)uniqueItem.getItem()));
            buf.writeInt(entry.getCount());
        }
    }

    public boolean isCopyPaste() {
        return this.isCopyPaste;
    }

    public Multiset<UniqueItem> getCache() {
        return this.cache;
    }

    public Pair<ResourceLocation, BlockPos> getLoc() {
        return this.loc;
    }
}

