/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.inventory;

import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.ConstructionPaste;
import com.direwolf20.buildinggadgets.common.items.ConstructionPasteContainer;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.inventory.CreativeItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.HandlerInsertProvider;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IInsertProvider;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryLinker;
import com.direwolf20.buildinggadgets.common.tainted.inventory.PlayerInventoryInsertProvider;
import com.direwolf20.buildinggadgets.common.tainted.inventory.PlayerItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.handle.IObjectHandle;
import com.direwolf20.buildinggadgets.common.tainted.inventory.handle.ItemHandlerProvider;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.UniqueItem;
import com.direwolf20.buildinggadgets.common.tainted.registry.TopologicalRegistryBuilder;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.CommonUtils;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class InventoryHelper {
    public static final MaterialList PASTE_LIST = MaterialList.of(new UniqueItem((Item)OurItems.CONSTRUCTION_PASTE_ITEM.get()));
    private static final Set<Property<?>> UNSAFE_PROPERTIES = ImmutableSet.builder().add((Object)CropsBlock.field_176488_a).add((Object)DoublePlantBlock.field_176492_b).build();
    public static final CreativeItemIndex CREATIVE_INDEX = new CreativeItemIndex();

    public static IItemIndex index(ItemStack tool, PlayerEntity player) {
        if (player.func_184812_l_()) {
            return CREATIVE_INDEX;
        }
        return new PlayerItemIndex(tool, player);
    }

    static List<IInsertProvider> indexInsertProviders(ItemStack tool, PlayerEntity player) {
        ImmutableList.Builder builder = ImmutableList.builder();
        InventoryLinker.getLinkedInventory(player.field_70170_p, tool).ifPresent(e -> builder.add((Object)new HandlerInsertProvider((IItemHandler)e)));
        builder.add((Object)new PlayerInventoryInsertProvider(player));
        return builder.build();
    }

    static Map<Class<?>, Map<Object, List<IObjectHandle<?>>>> indexMap(ItemStack tool, PlayerEntity player) {
        HashMap map = new HashMap();
        for (IItemHandler handler : InventoryHelper.getHandlers(tool, player)) {
            if (handler == null || handler.getSlots() <= 0) continue;
            ItemHandlerProvider.index(handler, map);
        }
        return map;
    }

    static List<IItemHandler> getHandlers(ItemStack stack, PlayerEntity player) {
        ArrayList<IItemHandler> handlers = new ArrayList<IItemHandler>();
        InventoryLinker.getLinkedInventory(player.field_70170_p, stack).ifPresent(handlers::add);
        player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handlers::add);
        return handlers;
    }

    public static void registerHandleProviders() {
        InterModComms.sendTo((String)"buildinggadgets", (String)"imc_handle_provider", () -> () -> TopologicalRegistryBuilder.create().addMarker(Reference.MARKER_AFTER_RL).addValue(Reference.HandleProviderReference.STACK_HANDLER_ITEM_HANDLE_RL, new ItemHandlerProvider()).addDependency(Reference.HandleProviderReference.STACK_HANDLER_ITEM_HANDLE_RL, Reference.MARKER_AFTER_RL));
    }

    public static boolean giveItem(ItemStack itemStack, PlayerEntity player, World world) {
        List<IItemHandler> invContainers;
        ItemStack giveItemStack;
        if (player.func_184812_l_()) {
            return true;
        }
        if (itemStack.func_77973_b() instanceof ConstructionPaste) {
            itemStack = InventoryHelper.addPasteToContainer(player, itemStack);
        }
        if (itemStack.func_190916_E() == 0) {
            return true;
        }
        PlayerInventory inv = player.field_71071_by;
        List<Integer> slots = InventoryHelper.findItem(itemStack.func_77973_b(), inv);
        for (int slot : slots) {
            boolean success;
            ItemStack stackInSlot = inv.func_70301_a(slot);
            if (stackInSlot.func_190916_E() >= stackInSlot.func_77973_b().getItemStackLimit(stackInSlot) || !(success = inv.func_70441_a(giveItemStack = itemStack.func_77946_l()))) continue;
            return true;
        }
        ItemStack tool = AbstractGadget.getGadget(player);
        IItemHandler remoteInventory = (IItemHandler)InventoryLinker.getLinkedInventory(world, tool).orElse((Object)new EmptyHandler());
        if (remoteInventory.getSlots() > 0) {
            for (int i = 0; i < remoteInventory.getSlots(); ++i) {
                ItemStack containerItem = remoteInventory.getStackInSlot(i);
                ItemStack giveItemStack2 = itemStack.func_77946_l();
                if (containerItem.func_77973_b() != itemStack.func_77973_b() && !containerItem.func_190926_b()) continue;
                if ((giveItemStack2 = remoteInventory.insertItem(i, giveItemStack2, false)).func_190926_b()) {
                    return true;
                }
                itemStack = giveItemStack2.func_77946_l();
            }
        }
        if ((invContainers = InventoryHelper.findInvContainers(inv)).size() > 0) {
            for (IItemHandler container : invContainers) {
                for (int i = 0; i < container.getSlots(); ++i) {
                    ItemStack containerItem = container.getStackInSlot(i);
                    ItemStack giveItemStack3 = itemStack.func_77946_l();
                    if (containerItem.func_77973_b() != giveItemStack3.func_77973_b()) continue;
                    if ((giveItemStack3 = container.insertItem(i, giveItemStack3, false)).func_190926_b()) {
                        return true;
                    }
                    itemStack = giveItemStack3.func_77946_l();
                }
            }
        }
        giveItemStack = itemStack.func_77946_l();
        return inv.func_70441_a(giveItemStack);
    }

    public static ItemStack addPasteToContainer(PlayerEntity player, ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ConstructionPaste)) {
            return itemStack;
        }
        PlayerInventory inv = player.field_71071_by;
        List<Integer> slots = InventoryHelper.findItemClass(ConstructionPasteContainer.class, inv);
        if (slots.size() == 0) {
            return itemStack;
        }
        HashMap<Integer, Integer> slotMap = new HashMap<Integer, Integer>();
        for (int slot : slots) {
            slotMap.put(slot, ConstructionPasteContainer.getPasteAmount(inv.func_70301_a(slot)));
        }
        ArrayList list = new ArrayList(slotMap.entrySet());
        Comparator comparator = Map.Entry.comparingByValue();
        comparator = comparator.reversed();
        list.sort(comparator);
        for (Map.Entry entry : list) {
            ItemStack containerStack = inv.func_70301_a(((Integer)entry.getKey()).intValue());
            ConstructionPasteContainer item = (ConstructionPasteContainer)containerStack.func_77973_b();
            int maxAmount = item.getMaxCapacity();
            int pasteInContainer = ConstructionPasteContainer.getPasteAmount(containerStack);
            int freeSpace = item.isCreative() ? Integer.MAX_VALUE : maxAmount - pasteInContainer;
            int stackSize = itemStack.func_190916_E();
            int remainingPaste = stackSize - freeSpace;
            if (remainingPaste < 0) {
                remainingPaste = 0;
            }
            int usedPaste = Math.abs(stackSize - remainingPaste);
            itemStack.func_190920_e(remainingPaste);
            ConstructionPasteContainer.setPasteAmount(containerStack, pasteInContainer + usedPaste);
        }
        return itemStack;
    }

    private static List<IItemHandler> findInvContainers(PlayerInventory inv) {
        ArrayList<IItemHandler> containers = new ArrayList<IItemHandler>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(containers::add);
        }
        return containers;
    }

    public static int countInContainer(IItemHandler container, Item item) {
        int count = 0;
        for (int i = 0; i < container.getSlots(); ++i) {
            ItemStack tempItem = container.getStackInSlot(i);
            if (tempItem.func_77973_b() != item) continue;
            count += tempItem.func_190916_E();
        }
        return count;
    }

    private static List<Integer> findItem(Item item, PlayerInventory inv) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item) continue;
            slots.add(i);
        }
        return slots;
    }

    public static List<Integer> findItemClass(Class<?> c, PlayerInventory inv) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !c.isInstance(stack.func_77973_b())) continue;
            slots.add(i);
        }
        return slots;
    }

    public static ItemStack getSilkTouchDrop(BlockState state) {
        return new ItemStack((IItemProvider)state.func_177230_c());
    }

    public static Optional<BlockData> getSafeBlockData(PlayerEntity player, BlockPos pos, Hand hand) {
        BlockItemUseContext blockItemUseContext = new BlockItemUseContext(new ItemUseContext(player, hand, CommonUtils.fakeRayTrace(player.func_213303_ch(), pos)));
        return InventoryHelper.getSafeBlockData(player, pos, blockItemUseContext);
    }

    public static Optional<BlockData> getSafeBlockData(PlayerEntity player, BlockPos pos, BlockItemUseContext useContext) {
        TileEntity te;
        World world = player.field_70170_p;
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof FlowingFluidBlock || !state.func_204520_s().func_206888_e()) {
            return Optional.empty();
        }
        if (state.func_177230_c() == OurBlocks.CONSTRUCTION_BLOCK.get() && (te = world.func_175625_s(pos)) instanceof ConstructionBlockTileEntity) {
            return Optional.of(((ConstructionBlockTileEntity)te).getConstructionBlockData());
        }
        BlockState placeState = null;
        try {
            placeState = state.func_177230_c().func_196258_a(useContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (placeState == null) {
            placeState = state.func_177230_c().func_176223_P();
        }
        for (Property prop : placeState.func_235904_r_()) {
            if (UNSAFE_PROPERTIES.contains(prop)) continue;
            placeState = InventoryHelper.applyProperty(placeState, state, prop);
        }
        return Optional.of(new BlockData(placeState, TileSupport.createTileData((IBlockReader)world, pos)));
    }

    private static <T extends Comparable<T>> BlockState applyProperty(BlockState state, BlockState from, Property<T> prop) {
        return (BlockState)state.func_206870_a(prop, from.func_177229_b(prop));
    }
}

