/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.inventory;

import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryLinker {
    public static Result linkInventory(World world, ItemStack stack, BlockRayTraceResult trace) {
        TileEntity tileEntity = world.func_175625_s(trace.func_216350_a());
        if (tileEntity == null || !tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            return Result.fail(MessageTranslation.INVALID_BOUND_TILE);
        }
        boolean removed = InventoryLinker.getLinkedInventory(world, stack).map(e -> InventoryLinker.removeIfSame(stack, trace.func_216350_a())).orElse(false);
        if (removed) {
            return Result.removed();
        }
        CompoundNBT compound = stack.func_196082_o();
        compound.func_74778_a("bound_te_dim", world.func_234923_W_().getRegistryName().toString());
        compound.func_218657_a("bound_te_pos", (INBT)NBTUtil.func_186859_a((BlockPos)trace.func_216350_a()));
        return Result.success();
    }

    public static LazyOptional<IItemHandler> getLinkedInventory(World world, ItemStack stack) {
        Pair<BlockPos, RegistryKey<World>> dataFromStack = InventoryLinker.getDataFromStack(stack);
        if (dataFromStack == null || !world.func_234923_W_().equals(dataFromStack.getValue())) {
            return LazyOptional.empty();
        }
        TileEntity tileEntity = world.func_175625_s((BlockPos)dataFromStack.getKey());
        if (tileEntity == null) {
            InventoryLinker.removeDataFromStack(stack);
            return LazyOptional.empty();
        }
        return tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    private static boolean removeIfSame(ItemStack stack, BlockPos pos) {
        Pair<BlockPos, RegistryKey<World>> dataFromStack = InventoryLinker.getDataFromStack(stack);
        if (dataFromStack == null) {
            return false;
        }
        if (((BlockPos)dataFromStack.getKey()).equals((Object)pos)) {
            InventoryLinker.removeDataFromStack(stack);
            return true;
        }
        return false;
    }

    public static void removeDataFromStack(ItemStack stack) {
        CompoundNBT compound = stack.func_196082_o();
        compound.func_82580_o("bound_te_pos");
        compound.func_82580_o("bound_te_dim");
    }

    @Nullable
    public static Pair<BlockPos, RegistryKey<World>> getDataFromStack(ItemStack stack) {
        CompoundNBT compound = stack.func_196082_o();
        if (!compound.func_74764_b("bound_te_pos") || !compound.func_74764_b("bound_te_dim")) {
            return null;
        }
        RegistryKey dimKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(compound.func_74779_i("bound_te_dim")));
        return Pair.of((Object)NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("bound_te_pos")), (Object)dimKey);
    }

    public static final class Result {
        private final MessageTranslation i18n;
        private final boolean successful;

        public Result(MessageTranslation i18n, boolean successful) {
            this.i18n = i18n;
            this.successful = successful;
        }

        public static Result fail(MessageTranslation i18n) {
            return new Result(i18n, false);
        }

        public static Result success() {
            return new Result(MessageTranslation.BOUND_TO_TILE, true);
        }

        public static Result removed() {
            return new Result(MessageTranslation.UNBOUND_TO_TILE, true);
        }

        public MessageTranslation getI18n() {
            return this.i18n;
        }

        public boolean isSuccessful() {
            return this.successful;
        }
    }
}

