/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.template;

import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateHeader;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateReadException;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateWriteException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Base64;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;

public final class TemplateIO {
    private static final Gson GSON = TemplateHeader.appendHeaderSpecification(new GsonBuilder(), false, true).create();

    private TemplateIO() {
    }

    public static void writeTemplate(Template template, OutputStream stream) throws TemplateWriteException {
        TemplateIO.writeTemplate(template, stream, true);
    }

    public static void writeTemplate(Template template, OutputStream stream, boolean persisted) throws TemplateWriteException {
        CompoundNBT nbt = template.serialize(persisted);
        try {
            CompressedStreamTools.func_74799_a((CompoundNBT)nbt, (OutputStream)stream);
        }
        catch (IOException e) {
            throw new TemplateWriteException.DataCannotBeWrittenException(e, nbt);
        }
    }

    public static Template readTemplate(InputStream stream, @Nullable TemplateHeader header) throws TemplateReadException {
        return TemplateIO.readTemplate(stream, header, true);
    }

    public static Template readTemplate(InputStream stream, @Nullable TemplateHeader header, boolean persisted) throws TemplateReadException {
        try {
            return TemplateIO.readTemplate(CompressedStreamTools.func_74796_a((InputStream)stream), header, persisted);
        }
        catch (IOException e) {
            throw new TemplateReadException.DataCannotBeReadException(e);
        }
    }

    public static Template readTemplate(CompoundNBT nbt, @Nullable TemplateHeader header, boolean persisted) throws TemplateReadException {
        try {
            return Template.deserialize(nbt, header, persisted);
        }
        catch (Exception e) {
            throw new TemplateReadException.IllegalNBTDataException(e, nbt);
        }
    }

    public static void writeTemplateJson(Template template, OutputStream stream) throws TemplateWriteException {
        TemplateIO.writeTemplateJson(template, stream, null);
    }

    public static void writeTemplateJson(Template template, OutputStream stream, @Nullable BuildContext context) throws TemplateWriteException {
        GSON.toJson((Object)TemplateJsonRepresentation.ofTemplate(template, context), (Appendable)new OutputStreamWriter(stream));
    }

    public static String writeTemplateJson(Template template) throws TemplateWriteException {
        return TemplateIO.writeTemplateJson(template, (BuildContext)null);
    }

    public static String writeTemplateJson(Template template, @Nullable BuildContext context) throws TemplateWriteException {
        return GSON.toJson((Object)TemplateJsonRepresentation.ofTemplate(template, context));
    }

    public static Template readTemplateFromJson(String json) throws TemplateReadException {
        try {
            return ((TemplateJsonRepresentation)TemplateIO.GSON.fromJson(json, TemplateJsonRepresentation.class)).getTemplate();
        }
        catch (JsonSyntaxException e) {
            throw new TemplateReadException.CorruptJsonException(e);
        }
    }

    public static Template readTemplateFromJson(InputStream stream) throws TemplateReadException {
        try {
            return ((TemplateJsonRepresentation)TemplateIO.GSON.fromJson((Reader)new InputStreamReader(stream), TemplateJsonRepresentation.class)).getTemplate();
        }
        catch (JsonSyntaxException e) {
            throw new TemplateReadException.CorruptJsonException(e);
        }
    }

    private static final class TemplateJsonRepresentation {
        private final TemplateHeader header;
        private final String body;

        public static TemplateJsonRepresentation ofTemplate(Template template, @Nullable BuildContext context) throws TemplateWriteException {
            TemplateHeader header = context != null ? template.getHeaderAndForceMaterials(context) : template.getHeader();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TemplateIO.writeTemplate(template, baos);
            String base64 = Base64.getEncoder().encodeToString(baos.toByteArray());
            return new TemplateJsonRepresentation(header, base64);
        }

        private TemplateJsonRepresentation(TemplateHeader header, String body) {
            this.header = header;
            this.body = body;
        }

        private TemplateHeader getHeader() {
            return this.header;
        }

        private String getBody() {
            return this.body;
        }

        private Template getTemplate() throws TemplateReadException {
            CompoundNBT nbt;
            byte[] bytes = Base64.getDecoder().decode(this.body);
            try {
                nbt = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(bytes));
            }
            catch (IOException e) {
                throw new TemplateReadException.CorruptDataException(e, this.body);
            }
            return Template.deserialize(nbt, this.header, true);
        }
    }
}

