/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tileentities;

import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tileentities.OurTileEntities;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class ConstructionBlockTileEntity
extends TileEntity {
    private BlockData blockState;
    private BlockData actualBlockState;
    public static final ModelProperty<BlockState> FACADE_STATE = new ModelProperty();

    public ConstructionBlockTileEntity() {
        super((TileEntityType)OurTileEntities.CONSTRUCTION_BLOCK_TILE_ENTITY.get());
    }

    public void setBlockState(BlockData state, BlockData actualState) {
        this.blockState = state;
        this.actualBlockState = actualState;
        this.markDirtyClient();
    }

    @Nonnull
    public IModelData getModelData() {
        BlockState state = this.getActualBlockData().getState();
        return new ModelDataMap.Builder().withInitial(FACADE_STATE, (Object)state).build();
    }

    @Nonnull
    public BlockState func_195044_w() {
        return this.getConstructionBlockData().getState();
    }

    @Nonnull
    public BlockData getConstructionBlockData() {
        if (this.blockState == null) {
            return BlockData.AIR;
        }
        return this.blockState;
    }

    @Nonnull
    public BlockData getActualBlockData() {
        if (this.actualBlockState == null) {
            return BlockData.AIR;
        }
        return this.actualBlockState;
    }

    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.blockState = BlockData.tryDeserialize(compound.func_74775_l("state"), true);
        this.actualBlockState = BlockData.tryDeserialize(compound.func_74775_l("state_actual"), true);
        this.markDirtyClient();
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        if (this.blockState != null) {
            compound.func_218657_a("state", (INBT)this.blockState.serialize(true));
            if (this.actualBlockState != null) {
                compound.func_218657_a("state_actual", (INBT)this.actualBlockState.serialize(true));
            }
        }
        return super.func_189515_b(compound);
    }

    private void markDirtyClient() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        this.func_189515_b(updateTag);
        return updateTag;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        this.func_189515_b(nbtTag);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        BlockData oldMimicBlock = this.getConstructionBlockData();
        CompoundNBT tagCompound = packet.func_148857_g();
        super.onDataPacket(net, packet);
        this.deserializeNBT(tagCompound);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && !this.getConstructionBlockData().equals(oldMimicBlock)) {
            this.field_145850_b.func_175646_b(this.func_174877_v(), this.getTileEntity());
        }
    }
}

