/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util;

import com.direwolf20.buildinggadgets.client.events.EventTooltip;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.network.packets.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryLinker;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateHeader;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class GadgetUtils {
    private static final ImmutableList<Block> DISALLOWED_BLOCKS = ImmutableList.of((Object)Blocks.field_150384_bq, (Object)Blocks.field_150427_aO, (Object)Blocks.field_150378_br, (Object)Blocks.field_150357_h);
    private static final ImmutableList<String> LINK_STARTS = ImmutableList.of((Object)"http", (Object)"www");

    public static boolean mightBeLink(String s) {
        return LINK_STARTS.stream().anyMatch(s::startsWith);
    }

    public static void addTooltipNameAndAuthor(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip) {
        if (world != null) {
            world.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).ifPresent(provider -> stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> {
                Template template = provider.getTemplateForKey((ITemplateKey)key);
                TemplateHeader header = template.getHeader();
                if (header.getName() != null && !header.getName().isEmpty()) {
                    tooltip.add((ITextComponent)TooltipTranslation.TEMPLATE_NAME.componentTranslation(header.getName()).func_230530_a_(Styles.AQUA));
                }
                if (header.getAuthor() != null && !header.getAuthor().isEmpty()) {
                    tooltip.add((ITextComponent)TooltipTranslation.TEMPLATE_AUTHOR.componentTranslation(header.getAuthor()).func_230530_a_(Styles.AQUA));
                }
            }));
        }
        EventTooltip.addTemplatePadding(stack, tooltip);
    }

    @Nullable
    public static ByteArrayOutputStream getPasteStream(@Nonnull CompoundNBT compound, @Nullable String name) throws IOException {
        CompoundNBT withText;
        CompoundNBT compoundNBT = withText = name != null && !name.isEmpty() ? compound.func_74737_b() : compound;
        if (name != null && !name.isEmpty()) {
            withText.func_74778_a("template_name", name);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompressedStreamTools.func_74799_a((CompoundNBT)withText, (OutputStream)baos);
        return baos.size() < 32567 ? baos : null;
    }

    public static void setAnchor(ItemStack stack) {
        GadgetUtils.setAnchor(stack, new ArrayList<BlockPos>());
    }

    public static void setAnchor(ItemStack stack, List<BlockPos> coordinates) {
        CompoundNBT tagCompound = stack.func_196082_o();
        tagCompound.func_218657_a("anchor_coords", (INBT)coordinates.stream().map(NBTUtil::func_186859_a).collect(Collectors.toCollection(ListNBT::new)));
        stack.func_77982_d(tagCompound);
    }

    public static Optional<List<BlockPos>> getAnchor(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return Optional.empty();
        }
        ListNBT coordList = (ListNBT)tagCompound.func_74781_a("anchor_coords");
        if (coordList == null || coordList.size() == 0) {
            return Optional.empty();
        }
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        for (int i = 0; i < coordList.size(); ++i) {
            coordinates.add(NBTUtil.func_186861_c((CompoundNBT)coordList.func_150305_b(i)));
        }
        return Optional.of(coordinates);
    }

    public static void setToolRange(ItemStack stack, int range) {
        CompoundNBT tagCompound = stack.func_196082_o();
        tagCompound.func_74768_a("range", range);
    }

    public static int getToolRange(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_196082_o();
        return MathHelper.func_76125_a((int)tagCompound.func_74762_e("range"), (int)1, (int)15);
    }

    public static BlockData rotateOrMirrorBlock(PlayerEntity player, PacketRotateMirror.Operation operation, BlockData data) {
        if (operation == PacketRotateMirror.Operation.MIRROR) {
            return data.mirror(player.func_174811_aO().func_176740_k() == Direction.Axis.X ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK);
        }
        return data.rotate(Rotation.CLOCKWISE_90);
    }

    public static void rotateOrMirrorToolBlock(ItemStack stack, PlayerEntity player, PacketRotateMirror.Operation operation) {
        GadgetUtils.setToolBlock(stack, GadgetUtils.rotateOrMirrorBlock(player, operation, GadgetUtils.getToolBlock(stack)));
        GadgetUtils.setToolActualBlock(stack, GadgetUtils.rotateOrMirrorBlock(player, operation, GadgetUtils.getToolActualBlock(stack)));
    }

    private static void setToolBlock(ItemStack stack, @Nullable BlockData data) {
        CompoundNBT tagCompound = stack.func_196082_o();
        if (data == null) {
            data = BlockData.AIR;
        }
        CompoundNBT stateTag = data.serialize(true);
        tagCompound.func_218657_a("state", (INBT)stateTag);
        stack.func_77982_d(tagCompound);
    }

    private static void setToolActualBlock(ItemStack stack, @Nullable BlockData data) {
        CompoundNBT tagCompound = stack.func_196082_o();
        if (data == null) {
            data = BlockData.AIR;
        }
        CompoundNBT dataTag = data.serialize(true);
        tagCompound.func_218657_a("state_actual", (INBT)dataTag);
        stack.func_77982_d(tagCompound);
    }

    @Nonnull
    public static BlockData getToolBlock(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_196082_o();
        BlockData res = BlockData.tryDeserialize(tagCompound.func_74775_l("state"), true);
        if (res == null) {
            GadgetUtils.setToolActualBlock(stack, BlockData.AIR);
            return BlockData.AIR;
        }
        return res;
    }

    @Nonnull
    public static BlockData getToolActualBlock(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_196082_o();
        BlockData res = BlockData.tryDeserialize(tagCompound.func_74775_l("state_actual"), true);
        if (res == null) {
            GadgetUtils.setToolActualBlock(stack, BlockData.AIR);
            return BlockData.AIR;
        }
        return res;
    }

    public static void linkToInventory(ItemStack stack, PlayerEntity player) {
        World world = player.field_70170_p;
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, AbstractGadget.shouldRayTraceFluid(stack) ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE);
        if (world.func_180495_p(VectorHelper.getLookingAt(player, stack).func_216350_a()) == Blocks.field_150350_a.func_176223_P()) {
            return;
        }
        InventoryLinker.Result result = InventoryLinker.linkInventory(player.field_70170_p, stack, lookingAt);
        player.func_146105_b((ITextComponent)result.getI18n().componentTranslation(new Object[0]), true);
    }

    public static ActionResult<Block> selectBlock(ItemStack stack, PlayerEntity player) {
        World world = player.field_70170_p;
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, AbstractGadget.shouldRayTraceFluid(stack) ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE);
        if (world.func_175623_d(lookingAt.func_216350_a())) {
            return ActionResult.func_226251_d_((Object)Blocks.field_150350_a);
        }
        BlockState state = world.func_180495_p(lookingAt.func_216350_a());
        if (!((AbstractGadget)stack.func_77973_b()).isAllowedBlock(state.func_177230_c()) || state.func_177230_c() instanceof EffectBlock) {
            return ActionResult.func_226251_d_((Object)state.func_177230_c());
        }
        if (DISALLOWED_BLOCKS.contains((Object)state.func_177230_c())) {
            return ActionResult.func_226251_d_((Object)state.func_177230_c());
        }
        if (state.func_185887_b((IBlockReader)world, lookingAt.func_216350_a()) < 0.0f) {
            return ActionResult.func_226251_d_((Object)state.func_177230_c());
        }
        Optional<BlockData> data = com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper.getSafeBlockData(player, lookingAt.func_216350_a(), player.func_184600_cs());
        data.ifPresent(placeState -> {
            BlockState actualState = placeState.getState();
            GadgetUtils.setToolBlock(stack, placeState);
            GadgetUtils.setToolActualBlock(stack, new BlockData(actualState, placeState.getTileData()));
        });
        return ActionResult.func_226248_a_((Object)state.func_177230_c());
    }

    public static ActionResultType setRemoteInventory(ItemStack stack, PlayerEntity player, World world, BlockPos pos, boolean setTool) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return ActionResultType.PASS;
        }
        if (setTool && te instanceof ConstructionBlockTileEntity) {
            ((ConstructionBlockTileEntity)te).getConstructionBlockData();
            GadgetUtils.setToolBlock(stack, ((ConstructionBlockTileEntity)te).getActualBlockData());
            GadgetUtils.setToolActualBlock(stack, ((ConstructionBlockTileEntity)te).getActualBlockData());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public static boolean anchorBlocks(PlayerEntity player, ItemStack stack) {
        Optional<List<BlockPos>> anchorCoords = GadgetUtils.getAnchor(stack);
        if (anchorCoords.isPresent()) {
            GadgetUtils.setAnchor(stack);
            player.func_146105_b((ITextComponent)MessageTranslation.ANCHOR_REMOVED.componentTranslation(new Object[0]).func_230530_a_(Styles.AQUA), true);
            return true;
        }
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, stack);
        BlockPos startBlock = lookingAt.func_216350_a();
        Direction sideHit = lookingAt.func_216354_b();
        if (player.field_70170_p.func_175623_d(startBlock)) {
            return false;
        }
        BlockData blockData = GadgetUtils.getToolBlock(stack);
        AbstractMode.UseContext context = new AbstractMode.UseContext(player.field_70170_p, blockData.getState(), startBlock, stack, sideHit, stack.func_77973_b() instanceof GadgetBuilding && GadgetBuilding.shouldPlaceAtop(stack));
        List<BlockPos> coords = stack.func_77973_b() instanceof GadgetBuilding ? GadgetBuilding.getToolMode(stack).getMode().getCollection(context, player) : GadgetExchanger.getToolMode(stack).getMode().getCollection(context, player);
        GadgetUtils.setAnchor(stack, coords);
        player.func_146105_b((ITextComponent)MessageTranslation.ANCHOR_SET.componentTranslation(new Object[0]).func_230530_a_(Styles.AQUA), true);
        return true;
    }

    public static String withSuffix(int count) {
        if (count < 1000) {
            return "" + count;
        }
        int exp = (int)(Math.log(count) / Math.log(1000.0));
        return String.format("%.1f%c", (double)count / Math.pow(1000.0, exp), Character.valueOf("kMGTPE".charAt(exp - 1)));
    }

    public static void writePOSToNBT(ItemStack stack, @Nullable BlockPos pos, String tagName) {
        CompoundNBT tagCompound = stack.func_196082_o();
        if (pos == null) {
            if (tagCompound.func_74781_a(tagName) != null) {
                tagCompound.func_82580_o(tagName);
                stack.func_77982_d(tagCompound);
            }
            return;
        }
        tagCompound.func_218657_a(tagName, (INBT)NBTUtil.func_186859_a((BlockPos)pos));
        stack.func_77982_d(tagCompound);
    }

    @Nullable
    public static BlockPos getPOSFromNBT(ItemStack stack, String tagName) {
        CompoundNBT stackTag = stack.func_196082_o();
        if (!stackTag.func_74764_b(tagName)) {
            return null;
        }
        CompoundNBT posTag = stack.func_196082_o().func_74775_l(tagName);
        if (posTag.isEmpty()) {
            return null;
        }
        return NBTUtil.func_186861_c((CompoundNBT)posTag);
    }

    @Nullable
    public static ResourceLocation getDIMFromNBT(ItemStack stack, String tagName) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        CompoundNBT posTag = tagCompound.func_74775_l(tagName);
        if (posTag.equals((Object)new CompoundNBT())) {
            return null;
        }
        return new ResourceLocation(posTag.func_74779_i("dim"));
    }

    public static void dropTileEntityInventory(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            LazyOptional cap = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            cap.ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)handler.getStackInSlot(i));
                }
            });
        }
    }
}

