/*
 * Decompiled with CFR 0.152.
 */
package bee.beeshroom.ComfyCozy.world.generation.generators;

import bee.beeshroom.ComfyCozy.util.handlers.ConfigHandler;
import bee.beeshroom.ComfyCozy.world.generation.generators.WorldGenBigWhiteMushroom;
import bee.beeshroom.ComfyCozy.world.generation.generators.WorldGenCinnamon;
import bee.beeshroom.ComfyCozy.world.generation.generators.WorldGenPeach;
import bee.beeshroom.ComfyCozy.world.generation.generators.WorldGenStrawberry;
import bee.beeshroom.ComfyCozy.world.generation.generators.WorldGenWhiteMushroom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeForest;
import net.minecraft.world.biome.BiomeHell;
import net.minecraft.world.biome.BiomeJungle;
import net.minecraft.world.biome.BiomeMushroomIsland;
import net.minecraft.world.biome.BiomeSwamp;
import net.minecraft.world.biome.BiomeTaiga;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGen
implements IWorldGenerator {
    private final WorldGenerator CINNAMON = new WorldGenCinnamon(true);
    private final WorldGenerator STRAWBERRY = new WorldGenStrawberry();
    private final WorldGenerator PEACH = new WorldGenPeach(true);
    private final WorldGenerator BIGWHITEMUSHROOM = new WorldGenBigWhiteMushroom(true);
    private final WorldGenerator WHITEMUSHROOM = new WorldGenWhiteMushroom();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 1: {
                break;
            }
            case 0: {
                this.runGenerator(this.CINNAMON, world, random, chunkX, chunkZ, 2, (Block)Blocks.field_150349_c, BiomeJungle.class);
                this.runGenerator(this.CINNAMON, world, random, chunkX, chunkZ, 2, Blocks.field_150346_d, BiomeJungle.class);
                if (ConfigHandler.CINNAMON) {
                    this.runGenerator(this.CINNAMON, world, random, chunkX, chunkZ, 55, (Block)Blocks.field_150349_c, BiomeForest.class);
                }
                if (ConfigHandler.PEACH) {
                    this.runGenerator(this.PEACH, world, random, chunkX, chunkZ, 20, (Block)Blocks.field_150349_c, BiomeForest.class);
                }
                this.runGenerator(this.WHITEMUSHROOM, world, random, chunkX, chunkZ, 10, (Block)Blocks.field_150349_c, BiomeForest.class);
                this.runGenerator(this.WHITEMUSHROOM, world, random, chunkX, chunkZ, 2, (Block)Blocks.field_150349_c, BiomeSwamp.class);
                this.runGenerator(this.WHITEMUSHROOM, world, random, chunkX, chunkZ, 1, (Block)Blocks.field_150391_bh, BiomeMushroomIsland.class);
                this.runGenerator(this.WHITEMUSHROOM, world, random, chunkX, chunkZ, 2, Blocks.field_150346_d, BiomeTaiga.class);
                this.runGenerator(this.WHITEMUSHROOM, world, random, chunkX, chunkZ, 2, (Block)Blocks.field_150349_c, BiomeTaiga.class);
                this.runGenerator(this.WHITEMUSHROOM, world, random, chunkX, chunkZ, 10, Blocks.field_150424_aL, BiomeHell.class);
                this.runGenerator(this.WHITEMUSHROOM, world, random, chunkX, chunkZ, 6, Blocks.field_150385_bj, BiomeHell.class);
                this.runGenerator(this.BIGWHITEMUSHROOM, world, random, chunkX, chunkZ, 1, (Block)Blocks.field_150391_bh, BiomeMushroomIsland.class);
                if (!ConfigHandler.STRAWBERRY) break;
                this.runGenerator(this.STRAWBERRY, world, random, chunkX, chunkZ, 15, (Block)Blocks.field_150349_c, BiomeForest.class);
                this.runGenerator(this.STRAWBERRY, world, random, chunkX, chunkZ, 6, (Block)Blocks.field_150349_c, BiomeTaiga.class);
                break;
            }
        }
    }

    private void runGenerator(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock, Class<?> ... classes) {
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        int x = chunkX * 16 + random.nextInt(15) + 8;
        int z = chunkZ * 16 + random.nextInt(15) + 8;
        int y = WorldGen.calculateGenerationHeight(world, x, z, topBlock);
        BlockPos pos = new BlockPos(x, y, z);
        Class<?> biome = world.field_73011_w.getBiomeForCoords(pos).getClass();
        if (world.func_175624_G() != WorldType.field_77138_c && classesList.contains(biome) && random.nextInt(chance) == 0) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private static int calculateGenerationHeight(World world, int x, int z, Block topBlock) {
        int y = world.func_72800_K();
        boolean foundGround = false;
        while (!foundGround && y-- >= 0) {
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = block == topBlock;
        }
        return y;
    }
}

