/*
 * Decompiled with CFR 0.152.
 */
package c4.consecration;

import c4.consecration.common.capabilities.CapabilityUndying;
import c4.consecration.common.entities.EntityFireBomb;
import c4.consecration.common.events.EventHandlerCommon;
import c4.consecration.common.init.ConsecrationFluids;
import c4.consecration.common.init.ConsecrationItems;
import c4.consecration.common.init.ConsecrationPotions;
import c4.consecration.common.init.ConsecrationTriggers;
import c4.consecration.common.trading.ListPotionForEmeralds;
import c4.consecration.common.util.ConfigHelper;
import c4.consecration.common.util.UndeadHelper;
import c4.consecration.common.util.UndeadRegistry;
import c4.consecration.integrations.ModuleCompatibility;
import c4.consecration.proxy.IProxy;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="consecration", name="Consecration", version="1.0.4", dependencies="required-after:forge@[14.23.4.2705,)", acceptedMinecraftVersions="[1.12.2, 1.13)", certificateFingerprint="5d5b8aee896a4f5ea3f3114784742662a67ad32f")
public class Consecration {
    public static final String MODID = "consecration";
    public static final String MODNAME = "Consecration";
    public static final String MODVER = "1.0.4";
    @SidedProxy(clientSide="c4.consecration.proxy.ClientProxy", serverSide="c4.consecration.proxy.ServerProxy")
    public static IProxy proxy;
    @Mod.Instance
    public static Consecration instance;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        logger = evt.getModLog();
        FluidRegistry.registerFluid((Fluid)ConsecrationFluids.HOLY_WATER);
        FluidRegistry.addBucketForFluid((Fluid)ConsecrationFluids.HOLY_WATER);
        proxy.preInit(evt);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerCommon());
        ConsecrationTriggers.init();
        CapabilityUndying.register();
        BlockDispenser.field_149943_a.func_82595_a((Object)ConsecrationItems.fireBomb, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return new EntityFireBomb(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }
        });
        for (String modid : ModuleCompatibility.compatDeps.keySet()) {
            if (!Loader.isModLoaded((String)modid)) continue;
            try {
                ModuleCompatibility.compatDeps.get(modid).newInstance();
            }
            catch (Exception e) {
                logger.log(Level.ERROR, "Error loading compatibility module " + ModuleCompatibility.compatDeps.get(modid));
            }
        }
        proxy.init(evt);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        VillagerRegistry.VillagerProfession priest = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation("minecraft:priest"));
        if (priest != null) {
            VillagerRegistry.VillagerCareer priestCareer = priest.getCareer(0);
            priestCareer.addTrade(2, new EntityVillager.ITradeList[]{new ListPotionForEmeralds(ConsecrationPotions.HOLY, new EntityVillager.PriceInfo(4, 6))});
            priestCareer.addTrade(3, new EntityVillager.ITradeList[]{new ListPotionForEmeralds(ConsecrationPotions.STRONG_HOLY, new EntityVillager.PriceInfo(6, 9))});
        }
        ConfigHelper.parseDimensionConfigs();
        ConfigHelper.registerConfigs();
        if (Loader.isModLoaded((String)"metamorph")) {
            UndeadHelper.isMetamorphLoaded = true;
        }
        proxy.postInit(evt);
    }

    @Mod.EventHandler
    public void onMessageReceived(FMLInterModComms.IMCEvent evt) {
        UndeadRegistry.processIMC(evt);
    }

    @Mod.EventHandler
    public void onFingerPrintViolation(FMLFingerprintViolationEvent evt) {
        FMLLog.log.log(Level.ERROR, "Invalid fingerprint detected! The file " + evt.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!");
    }

    static {
        FluidRegistry.enableUniversalBucket();
    }
}

