/*
 * Decompiled with CFR 0.152.
 */
package c4.consecration.common.capabilities;

import c4.consecration.Consecration;
import c4.consecration.common.capabilities.IUndying;
import c4.consecration.common.capabilities.Undying;
import c4.consecration.common.config.ConfigHandler;
import c4.consecration.common.init.ConsecrationTriggers;
import c4.consecration.common.util.UndeadHelper;
import c4.consecration.common.util.UndeadRegistry;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.Level;

public final class CapabilityUndying {
    private static final Field TIPPED_ARROW_POTION = ReflectionHelper.findField(EntityTippedArrow.class, (String[])new String[]{"potion", "field_184560_g", "g"});
    private static final UUID SPEED_MOD = UUID.fromString("b812ef3d-0ef9-4368-845b-fad7003a1f4f");
    @CapabilityInject(value=IUndying.class)
    public static final Capability<IUndying> UNDYING_CAP = null;
    public static final EnumFacing DEFAULT_FACING = null;
    public static final ResourceLocation ID = new ResourceLocation("consecration", "undying");
    private static final String SMITE_TAG = "smite";

    public static void register() {
        CapabilityManager.INSTANCE.register(IUndying.class, (Capability.IStorage)new Capability.IStorage<IUndying>(){

            public NBTBase writeNBT(Capability<IUndying> capability, IUndying instance, EnumFacing side) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74768_a(CapabilityUndying.SMITE_TAG, instance.getSmite());
                return compound;
            }

            public void readNBT(Capability<IUndying> capability, IUndying instance, EnumFacing side, NBTBase nbt) {
                NBTTagCompound compound = (NBTTagCompound)nbt;
                instance.setSmite(compound.func_74762_e(CapabilityUndying.SMITE_TAG));
            }
        }, Undying::new);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    @Nullable
    public static IUndying getUndying(EntityLivingBase entityIn) {
        if (entityIn != null && entityIn.hasCapability(UNDYING_CAP, DEFAULT_FACING)) {
            return (IUndying)entityIn.getCapability(UNDYING_CAP, DEFAULT_FACING);
        }
        return null;
    }

    public static ICapabilityProvider createProvider(IUndying undying) {
        return new Provider(undying, UNDYING_CAP, DEFAULT_FACING);
    }

    @Mod.EventBusSubscriber(modid="consecration")
    public static class EventHandler {
        private static Set<Integer> dimensions = new HashSet<Integer>();

        @SubscribeEvent
        public static void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
            EntityLivingBase living;
            if (evt.getObject() instanceof EntityLivingBase && EventHandler.isAllowedDimension(living = (EntityLivingBase)evt.getObject())) {
                evt.addCapability(ID, CapabilityUndying.createProvider(new Undying()));
            }
        }

        @SubscribeEvent
        public static void onLivingUpdate(LivingEvent.LivingUpdateEvent evt) {
            IUndying undying;
            EntityLivingBase entitylivingbase = evt.getEntityLiving();
            if (!entitylivingbase.func_130014_f_().field_72995_K && UndeadHelper.isUndead(entitylivingbase) && (undying = CapabilityUndying.getUndying(entitylivingbase)) != null) {
                IAttributeInstance speedAttribute = entitylivingbase.func_110148_a(SharedMonsterAttributes.field_111263_d);
                speedAttribute.func_188479_b(SPEED_MOD);
                if (undying.isSmote()) {
                    if (entitylivingbase.field_70173_aa % 10 == 0) {
                        WorldServer worldIn = (WorldServer)entitylivingbase.func_130014_f_();
                        worldIn.func_175739_a(EnumParticleTypes.SPELL_INSTANT, entitylivingbase.field_70165_t, entitylivingbase.field_70163_u + (double)entitylivingbase.field_70131_O / 2.0, entitylivingbase.field_70161_v, 2, (double)entitylivingbase.field_70130_N / 2.0, (double)entitylivingbase.field_70131_O / 4.0, (double)entitylivingbase.field_70130_N / 2.0, 0.0, new int[0]);
                    }
                    undying.decrementSmite();
                } else if (UndeadHelper.hasHolyPotion(entitylivingbase)) {
                    undying.setSmite(ConfigHandler.holy.smiteDuration * 20);
                } else if (entitylivingbase.func_70027_ad()) {
                    undying.setSmite(ConfigHandler.holy.fireSmiteDuration * 20);
                } else {
                    if (entitylivingbase.field_70173_aa % 20 == 0 && entitylivingbase.func_110143_aJ() < entitylivingbase.func_110138_aP()) {
                        entitylivingbase.func_70691_i((float)ConfigHandler.undying.healthRegen);
                    }
                    if (ConfigHandler.undying.speedModifier > 0.0 && speedAttribute.func_111127_a(SPEED_MOD) == null) {
                        speedAttribute.func_111121_a(new AttributeModifier(SPEED_MOD, "Undead speed", ConfigHandler.undying.speedModifier, 2));
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onArrowImpact(ProjectileImpactEvent.Arrow evt) {
            EntityArrow arrow = evt.getArrow();
            if (arrow.field_70250_c instanceof EntityPlayerMP && arrow instanceof EntityTippedArrow) {
                PotionType potionType = null;
                try {
                    potionType = (PotionType)TIPPED_ARROW_POTION.get(arrow);
                }
                catch (IllegalAccessException e) {
                    Consecration.logger.log(Level.ERROR, "Error catching potion from EntityTippedArrow" + arrow);
                }
                if (potionType != null) {
                    for (PotionEffect effect : potionType.func_185170_a()) {
                        Potion potion = effect.func_188419_a();
                        if (!UndeadRegistry.getHolyPotions().contains((Object)potion)) continue;
                        ConsecrationTriggers.SMITE_KILLED.trigger((EntityPlayerMP)arrow.field_70250_c);
                        return;
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onLivingDamage(LivingDamageEvent evt) {
            EntityLivingBase entitylivingbase = evt.getEntityLiving();
            if (!entitylivingbase.func_130014_f_().field_72995_K && UndeadHelper.isUndead(entitylivingbase)) {
                DamageSource source = evt.getSource();
                if (source == DamageSource.field_76380_i || source == DamageSource.field_191291_g || source == DamageSource.field_76368_d) {
                    return;
                }
                IUndying undying = CapabilityUndying.getUndying(entitylivingbase);
                if (undying != null) {
                    if (UndeadHelper.doSmite(entitylivingbase, source)) {
                        if (source.func_76347_k()) {
                            undying.setSmite(ConfigHandler.holy.fireSmiteDuration * 20);
                        } else {
                            undying.setSmite(ConfigHandler.holy.smiteDuration * 20);
                        }
                        if (source.func_76346_g() instanceof EntityPlayerMP) {
                            ConsecrationTriggers.SMITE_KILLED.trigger((EntityPlayerMP)source.func_76346_g());
                        }
                    } else if (!source.func_151517_h() && !undying.isSmote() && source.func_76346_g() != null && (ConfigHandler.undying.reduceDamageVsMobs || source.func_76346_g() instanceof EntityPlayer)) {
                        evt.setAmount(evt.getAmount() * (float)(1.0 - ConfigHandler.undying.damageReduction));
                    }
                }
            }
        }

        public static void addDimension(int dimension) {
            dimensions.add(dimension);
        }

        public static boolean isAllowedDimension(EntityLivingBase entity) {
            int dimension = entity.field_71093_bK;
            if (dimensions.isEmpty()) {
                return true;
            }
            if (ConfigHandler.dimensionPermission == ConfigHandler.PermissionMode.BLACKLIST) {
                return !dimensions.contains(dimension);
            }
            return dimensions.contains(dimension);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        final Capability<IUndying> capability;
        final EnumFacing facing;
        final IUndying instance;

        Provider(IUndying instance, Capability<IUndying> capability, @Nullable EnumFacing facing) {
            this.instance = instance;
            this.capability = capability;
            this.facing = facing;
        }

        public boolean hasCapability(@Nullable Capability<?> capability, EnumFacing facing) {
            return capability == this.getCapability();
        }

        public <T> T getCapability(@Nullable Capability<T> capability, EnumFacing facing) {
            return (T)(capability == this.getCapability() ? this.getCapability().cast((Object)this.instance) : null);
        }

        final Capability<IUndying> getCapability() {
            return this.capability;
        }

        EnumFacing getFacing() {
            return this.facing;
        }

        final IUndying getInstance() {
            return this.instance;
        }

        public NBTBase serializeNBT() {
            return this.getCapability().writeNBT((Object)this.getInstance(), this.getFacing());
        }

        public void deserializeNBT(NBTBase nbt) {
            this.getCapability().readNBT((Object)this.getInstance(), this.getFacing(), nbt);
        }
    }
}

