/*
 * Decompiled with CFR 0.152.
 */
package c4.consecration.common.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="consecration")
public class ConfigHandler {
    @Config.Name(value="Dimension Permission Mode")
    @Config.Comment(value={"Set whether the dimension configuration is blacklisted or whitelisted"})
    @Config.RequiresMcRestart
    public static PermissionMode dimensionPermission = PermissionMode.BLACKLIST;
    @Config.Name(value="Dimension List")
    @Config.Comment(value={"Set which dimensions are blacklisted or whitelisted for affected undead, leave blank to disable this option"})
    @Config.RequiresMcRestart
    public static String[] dimensionList = new String[0];
    @Config.Name(value="Blessing XP Level Cost")
    @Config.Comment(value={"Set how many levels a blessing from a villager priest costs"})
    public static int blessingCost = 1;
    public static Holy holy = new Holy();
    public static Undying undying = new Undying();
    public static ModSupport modSupport = new ModSupport();

    @Mod.EventBusSubscriber(modid="consecration")
    private static class ConfigEventHandler {
        private ConfigEventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent evt) {
            if (evt.getModID().equals("consecration")) {
                ConfigManager.sync((String)"consecration", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static enum PermissionMode {
        BLACKLIST,
        WHITELIST;

    }

    public static class ModSupport {
        @Config.Name(value="Reliquary Glowing Water")
        @Config.Comment(value={"Set to true to give Reliquary's Glowing Water smiting"})
        public boolean reliquaryGlowingWater = true;
        @Config.Name(value="MK-Ultra Holy Damage")
        @Config.Comment(value={"List of abilities from MK-Ultra that will deal holy damage"})
        public String[] mkultraSources = new String[]{"ability.smite", "ability.heal"};
        @Config.Name(value="Tinkers' Holy Modifiers")
        @Config.Comment(value={"List of modifiers from Tinkers' Construct that will smite"})
        public String[] tinkersHolyModifiers = new String[]{"smite"};
    }

    public static class Undying {
        @Config.Name(value="Auto-Include Default Undead Mobs")
        @Config.Comment(value={"Set to true to include all mobs that are listed as undead by default"})
        @Config.RequiresWorldRestart
        public boolean defaultUndead = true;
        @Config.Name(value="Include as Undead Mob")
        @Config.Comment(value={"A list of mobs that will be classified as undead by this mod in addition to the regular undead"})
        @Config.RequiresMcRestart
        public String[] undeadMobs = new String[0];
        @Config.Name(value="Smite-Proof Mobs")
        @Config.Comment(value={"A list of mobs that cannot lose their undying abilities"})
        @Config.RequiresMcRestart
        public String[] smiteProofMobs = new String[0];
        @Config.Name(value="Include as Unholy Mob")
        @Config.Comment(value={"A list of mobs that will be classified as unholy, acting like undead except they cannot be smited by fire"})
        public String[] unholyMobs = new String[0];
        @Config.Name(value="Damage Reduction")
        @Config.Comment(value={"Set undead natural damage reduction, in percent, against all non-holy damage"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double damageReduction = 0.8;
        @Config.Name(value="Health Regen")
        @Config.Comment(value={"Set undead natural health regen, in half-hearts per second"})
        @Config.RangeInt(min=0, max=1000)
        public int healthRegen = 1;
        @Config.Name(value="Bonus Speed Modifier")
        @Config.Comment(value={"Set undead natural bonus speed modifier"})
        @Config.RangeDouble(min=0.0)
        public double speedModifier = 0.0;
        @Config.Name(value="Reduce Damage Against Non-Players")
        @Config.Comment(value={"Set to true to have undead reduce damage against non-player non-holy entities"})
        public boolean reduceDamageVsMobs = true;
    }

    public static class Holy {
        @Config.Name(value="Fire Smite Duration")
        @Config.Comment(value={"The amount of time, in seconds, that smiting from fire lasts"})
        public int fireSmiteDuration = 5;
        @Config.Name(value="Holy Smite Duration")
        @Config.Comment(value={"The amount of time, in seconds, that smiting from holy sources lasts"})
        public int smiteDuration = 10;
        @Config.Name(value="Holy Entities")
        @Config.Comment(value={"A list of entities that will be able to damage and smite undead"})
        @Config.RequiresMcRestart
        public String[] holyEntities = new String[]{"minecraft:villager_golem", "xreliquary:hand_grenade", "dcs_climate:dcs.main.bullet_silver"};
        @Config.Name(value="Holy Potions")
        @Config.Comment(value={"A list of potions that will be able to damage and smite undead"})
        @Config.RequiresMcRestart
        public String[] holyPotions = new String[]{"consecration:holy_potion", "minecraft:instant_health"};
        @Config.Name(value="Holy Weapons")
        @Config.Comment(value={"A list of items that will be able to damage and smite undead"})
        @Config.RequiresMcRestart
        public String[] holyWeapons = new String[]{"xreliquary:mercy_cross", "dcs_climate:dcs_dagger_silver"};
        @Config.Name(value="Holy Enchantments")
        @Config.Comment(value={"A list of enchantments that will be able to damage and smite undead"})
        @Config.RequiresMcRestart
        public String[] holyEnchantments = new String[]{"minecraft:smite", "somanyenchantments:BlessedEdge", "somanyenchantments:ExtremeSmite"};
        @Config.Name(value="Holy Damage")
        @Config.Comment(value={"A list of damage types that will be able to damage and smite undead"})
        @Config.RequiresMcRestart
        public String[] holyDamage = new String[]{"holy", "ieRevolver_silver", "aov.nimbusray"};
        @Config.Name(value="Holy Material")
        @Config.Comment(value={"A list of material names that will be able to damage and smite undead"})
        @Config.RequiresMcRestart
        public String[] holyMaterial = new String[]{"silver"};
    }
}

