/*
 * Decompiled with CFR 0.152.
 */
package c4.consecration.common.events;

import c4.consecration.Consecration;
import c4.consecration.common.blocks.BlockBlessedTrail;
import c4.consecration.common.blocks.BlockHolyWater;
import c4.consecration.common.capabilities.CapabilityUndying;
import c4.consecration.common.capabilities.IUndying;
import c4.consecration.common.config.ConfigHandler;
import c4.consecration.common.init.ConsecrationBlocks;
import c4.consecration.common.init.ConsecrationFluids;
import c4.consecration.common.init.ConsecrationItems;
import c4.consecration.common.util.UndeadHelper;
import c4.consecration.integrations.ModuleCompatibility;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.Level;

public class EventHandlerCommon {
    private static final Field CONVERSION_TIME = ReflectionHelper.findField(EntityZombieVillager.class, (String[])new String[]{"conversionTime", "field_82234_d"});

    @SubscribeEvent
    public void onZombieVillagerUpdate(LivingEvent.LivingUpdateEvent evt) {
        EntityZombieVillager zombieVillager;
        EntityLivingBase living = evt.getEntityLiving();
        if (!living.field_70170_p.field_72995_K && living instanceof EntityZombieVillager && (zombieVillager = (EntityZombieVillager)living).func_82230_o()) {
            int conversionTime = this.getConversionTime(zombieVillager);
            this.setConversionTime(zombieVillager, conversionTime -= this.getConversionSpeed(zombieVillager));
        }
    }

    private int getConversionSpeed(EntityZombieVillager zombieVillager) {
        int speed = 0;
        if (zombieVillager.field_70170_p.field_73012_v.nextFloat() < 0.01f) {
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = (int)zombieVillager.field_70165_t - 4; k < (int)zombieVillager.field_70165_t + 4 && j < 14; ++k) {
                for (int l = (int)zombieVillager.field_70163_u - 4; l < (int)zombieVillager.field_70163_u + 4 && j < 14; ++l) {
                    for (int i1 = (int)zombieVillager.field_70161_v - 4; i1 < (int)zombieVillager.field_70161_v + 4 && j < 14; ++i1) {
                        Block block = zombieVillager.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(k, l, i1)).func_177230_c();
                        if (!(block instanceof BlockHolyWater) && !(block instanceof BlockBlessedTrail)) continue;
                        if (zombieVillager.field_70170_p.field_73012_v.nextFloat() < 0.3f) {
                            speed += 3;
                        }
                        ++j;
                    }
                }
            }
        }
        return speed;
    }

    private int getConversionTime(EntityZombieVillager zombieVillager) {
        try {
            return CONVERSION_TIME.getInt(zombieVillager);
        }
        catch (IllegalAccessException e) {
            Consecration.logger.log(Level.ERROR, "Error getting conversionTime for Zombie Villager " + zombieVillager);
            return 0;
        }
    }

    private void setConversionTime(EntityZombieVillager zombieVillager, int conversionTime) {
        try {
            CONVERSION_TIME.setInt(zombieVillager, conversionTime);
        }
        catch (IllegalAccessException e) {
            Consecration.logger.log(Level.ERROR, "Error setting conversionTime for Zombie Villager " + zombieVillager);
        }
    }

    @SubscribeEvent
    public void onSpawnCheck(LivingSpawnEvent.CheckSpawn evt) {
        BlockPos pos;
        World world = evt.getWorld();
        if ((world.func_180495_p(pos = evt.getEntityLiving().func_180425_c()).func_177230_c() == ConsecrationBlocks.blessedTrail || world.func_180495_p(pos.func_177979_c(2)).func_177230_c() == ConsecrationBlocks.blessedTrail) && UndeadHelper.isUndead(evt.getEntityLiving())) {
            evt.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onPriestInteract(PlayerInteractEvent.EntityInteract evt) {
        EntityVillager villager;
        VillagerRegistry.VillagerProfession profession;
        Entity target = evt.getTarget();
        if (!target.field_70170_p.field_72995_K && target instanceof EntityVillager && (profession = (villager = (EntityVillager)target).getProfessionForge()).getRegistryName().toString().equalsIgnoreCase("minecraft:priest")) {
            ItemStack stack = evt.getItemStack();
            Item item = stack.func_77973_b();
            EntityPlayer player = evt.getEntityPlayer();
            ItemStack output = ItemStack.field_190927_a;
            String messageKey = "consecration.benediction.";
            if (item == Items.field_151114_aO) {
                output = new ItemStack((Item)ConsecrationItems.blessedDust, stack.func_190916_E());
                messageKey = messageKey + "dust";
            } else if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
                if (fluidStack != null && fluidStack.getFluid() == FluidRegistry.WATER) {
                    if (item == Items.field_151131_as) {
                        output = FluidUtil.getFilledBucket((FluidStack)new FluidStack((Fluid)ConsecrationFluids.HOLY_WATER, 1000));
                    } else {
                        fluidStack = fluidHandler.drain(fluidStack, true);
                        fluidHandler.fill(new FluidStack((Fluid)ConsecrationFluids.HOLY_WATER, fluidStack.amount), true);
                        output = stack.func_77946_l();
                    }
                    messageKey = messageKey + "water";
                }
            }
            if (!output.func_190926_b()) {
                if (player.field_71068_ca < 1 && !player.field_71075_bZ.field_75098_d) {
                    messageKey = "consecration.benediction.power";
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187913_gm, SoundCategory.NEUTRAL, 1.0f, (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                } else {
                    player.func_192024_a(output, ConfigHandler.blessingCost);
                    stack.func_190918_g(output.func_190916_E());
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)output, (int)player.field_71071_by.field_70461_c);
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 2.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.5f + 1.5f);
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187915_go, SoundCategory.NEUTRAL, 1.0f, (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                }
                player.func_146105_b((ITextComponent)new TextComponentTranslation(messageKey, new Object[0]), true);
                evt.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent evt) {
        EntityLivingBase attacker;
        IUndying undying;
        EntityLivingBase entityLivingBase = evt.getEntityLiving();
        DamageSource source = evt.getSource();
        if (!entityLivingBase.func_130014_f_().field_72995_K && source.func_76346_g() instanceof EntityLivingBase && (undying = CapabilityUndying.getUndying(attacker = (EntityLivingBase)source.func_76346_g())) != null) {
            int level = 0;
            for (ItemStack stack : entityLivingBase.func_184193_aE()) {
                if (stack.func_190926_b()) continue;
                boolean flag = UndeadHelper.isHolyArmor(stack);
                if (!flag) {
                    for (ModuleCompatibility module : ModuleCompatibility.getLoadedMods().values()) {
                        if (!module.processArmor(entityLivingBase, stack, source)) continue;
                        flag = true;
                        break;
                    }
                }
                if (!flag) continue;
                ++level;
            }
            if (level > 0 && entityLivingBase.func_130014_f_().field_73012_v.nextFloat() < 0.15f * (float)level) {
                undying.setSmite(ConfigHandler.holy.smiteDuration * 20);
            }
        }
    }
}

