/*
 * Decompiled with CFR 0.152.
 */
package c4.consecration.common.util;

import c4.consecration.Consecration;
import c4.consecration.common.config.ConfigHandler;
import c4.consecration.common.util.UndeadRegistry;
import c4.consecration.integrations.ModuleCompatibility;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import mchorse.metamorph.api.EntityUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.EntityMorph;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.Level;

public class UndeadHelper {
    public static boolean isMetamorphLoaded = false;
    private static final Field ARMOR_MATERIAL_NAME = ReflectionHelper.findField(ItemArmor.ArmorMaterial.class, (String[])new String[]{"name", "field_179243_f", "f"});
    private static final Field AOE_CLOUD_POTION = ReflectionHelper.findField(EntityAreaEffectCloud.class, (String[])new String[]{"potion", "field_184502_e", "g"});

    public static boolean isUndead(EntityLivingBase entityLivingBase) {
        ResourceLocation key = EntityList.func_191301_a((Entity)entityLivingBase);
        boolean isEntityUndead = false;
        if (isMetamorphLoaded) {
            AbstractMorph morph = EntityUtils.getMorph((EntityLivingBase)entityLivingBase);
            if (morph instanceof EntityMorph) {
                EntityLivingBase entity = ((EntityMorph)morph).getEntity();
                if (entity != null) {
                    isEntityUndead = entity.func_70662_br();
                }
            } else {
                isEntityUndead = entityLivingBase.func_70662_br();
            }
        } else {
            isEntityUndead = entityLivingBase.func_70662_br();
        }
        return ConfigHandler.undying.defaultUndead && isEntityUndead || UndeadRegistry.getUndeadList().contains((Object)key) || UndeadRegistry.getUnholyList().contains((Object)key);
    }

    public static boolean doSmite(EntityLivingBase target, DamageSource source) {
        if (UndeadRegistry.getSmiteProofList().contains((Object)EntityList.func_191301_a((Entity)target))) {
            return false;
        }
        if (!target.func_70045_F() && source.func_76347_k() && !UndeadRegistry.getUnholyList().contains((Object)EntityList.func_191301_a((Entity)target))) {
            return true;
        }
        if (source.func_76364_f() instanceof EntityLivingBase) {
            ItemStack stack = ((EntityLivingBase)source.func_76364_f()).func_184614_ca();
            if (stack.func_77973_b() instanceof ItemTool && UndeadHelper.isHolyMaterial(((ItemTool)stack.func_77973_b()).func_77861_e())) {
                return true;
            }
            if (stack.func_77973_b() instanceof ItemSword && UndeadHelper.isHolyMaterial(((ItemSword)stack.func_77973_b()).func_150932_j())) {
                return true;
            }
            for (ItemStack stack1 : UndeadRegistry.getHolyWeapons()) {
                if (!ItemStack.func_185132_d((ItemStack)stack1, (ItemStack)stack)) continue;
                return true;
            }
            for (Enchantment ench : EnchantmentHelper.func_82781_a((ItemStack)stack).keySet()) {
                if (!UndeadRegistry.getHolyEnchantments().contains((Object)ench)) continue;
                return true;
            }
        }
        if (UndeadHelper.isHolyDamage(source.field_76373_n) || UndeadHelper.isHolyEntity(source.func_76364_f())) {
            return true;
        }
        for (ModuleCompatibility module : ModuleCompatibility.getLoadedMods().values()) {
            if (!module.process(target, source)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasHolyPotion(EntityLivingBase entityIn) {
        for (Potion potion : entityIn.func_193076_bZ().keySet()) {
            if (!UndeadRegistry.getHolyPotions().contains((Object)potion)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHolyPotionEntity(Entity entity) {
        ArrayList effects = Lists.newArrayList();
        if (entity instanceof EntityPotion) {
            EntityPotion entitypotion = (EntityPotion)entity;
            effects.addAll(PotionUtils.func_185189_a((ItemStack)entitypotion.func_184543_l()));
        } else if (entity instanceof EntityAreaEffectCloud) {
            PotionType potion = null;
            try {
                potion = (PotionType)AOE_CLOUD_POTION.get(entity);
            }
            catch (IllegalAccessException e) {
                Consecration.logger.log(Level.ERROR, "Error getting potion from AoE cloud " + entity);
            }
            if (potion != null) {
                effects.addAll(potion.func_185170_a());
            }
        }
        for (PotionEffect effect : effects) {
            Potion potion = effect.func_188419_a();
            if (!UndeadRegistry.getHolyPotions().contains((Object)potion)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHolyEntity(Entity entity) {
        if (entity != null) {
            ResourceLocation rl = EntityList.func_191301_a((Entity)entity);
            return rl != null && (UndeadHelper.isHolyPotionEntity(entity) || UndeadRegistry.getHolyEntities().contains((Object)rl));
        }
        return false;
    }

    public static boolean isHolyArmor(ItemStack armor) {
        if (armor.func_77973_b() instanceof ItemArmor) {
            ItemArmor armorItem = (ItemArmor)armor.func_77973_b();
            boolean isHolyArmor = false;
            try {
                isHolyArmor = UndeadHelper.isHolyMaterial((String)ARMOR_MATERIAL_NAME.get(armorItem.func_82812_d()));
            }
            catch (IllegalAccessException e) {
                Consecration.logger.log(Level.ERROR, "Error retrieving name for armor material " + armorItem.func_82812_d());
            }
            if (!isHolyArmor) {
                // empty if block
            }
            return isHolyArmor;
        }
        return false;
    }

    public static boolean isHolyDamage(String name) {
        return UndeadRegistry.getHolyDamage().contains((Object)name);
    }

    public static boolean isHolyMaterial(String mat) {
        mat = mat.toLowerCase();
        for (String name : UndeadRegistry.getHolyMaterials()) {
            String pattern = "((.*[^a-z])|\\b)" + name + "((.*[^a-z])|\\b)(.*|\\b)";
            if (!mat.matches(pattern)) continue;
            return true;
        }
        return false;
    }
}

