/*
 * Decompiled with CFR 0.152.
 */
package c4.consecration.common.util;

import c4.consecration.Consecration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.apache.logging.log4j.Level;

public class UndeadRegistry {
    private static List<ResourceLocation> undeadList = new ArrayList<ResourceLocation>();
    private static List<ResourceLocation> holyEntities = new ArrayList<ResourceLocation>();
    private static List<Potion> holyPotions = new ArrayList<Potion>();
    private static List<ItemStack> holyWeapons = new ArrayList<ItemStack>();
    private static List<Enchantment> holyEnchantments = new ArrayList<Enchantment>();
    private static Set<String> holyDamage = new HashSet<String>();
    private static Set<String> holyMaterials = new HashSet<String>();
    private static List<ResourceLocation> unholyList = new ArrayList<ResourceLocation>();
    private static List<ResourceLocation> smiteProofList = new ArrayList<ResourceLocation>();

    public static void processIMC(FMLInterModComms.IMCEvent evt) {
        for (FMLInterModComms.IMCMessage message : evt.getMessages()) {
            String key = message.key;
            if (message.isItemStackMessage()) {
                if (!UndeadRegistry.equalsKey(key, "holyweapon")) continue;
                UndeadRegistry.addHolyWeapon(message.getItemStackValue());
                continue;
            }
            if (message.isResourceLocationMessage()) {
                if (UndeadRegistry.equalsKey(key, "holypotion")) {
                    UndeadRegistry.addHolyPotion(message.getResourceLocationValue());
                    continue;
                }
                if (UndeadRegistry.equalsKey(key, "holyentity")) {
                    UndeadRegistry.addHolyEntity(message.getResourceLocationValue());
                    continue;
                }
                if (!UndeadRegistry.equalsKey(key, "holyenchantment")) continue;
                UndeadRegistry.addHolyEnchantment(message.getResourceLocationValue());
                continue;
            }
            if (!message.isStringMessage()) continue;
            if (UndeadRegistry.equalsKey(key, "holydamage")) {
                UndeadRegistry.addHolyDamage(message.getStringValue());
                continue;
            }
            if (!UndeadRegistry.equalsKey(key, "holymaterial")) continue;
            UndeadRegistry.addHolyMaterial(message.getStringValue());
        }
    }

    private static boolean equalsKey(String key, String value) {
        return key.equalsIgnoreCase(value);
    }

    public static void addUndead(ResourceLocation resource) {
        if (EntityList.func_180125_b((ResourceLocation)resource)) {
            undeadList.add(resource);
        } else {
            Consecration.logger.log(Level.ERROR, "Tried to add undead entity that is not registered! [" + resource.toString() + "]");
        }
    }

    public static void addUnholy(ResourceLocation resource) {
        if (EntityList.func_180125_b((ResourceLocation)resource)) {
            unholyList.add(resource);
        } else {
            Consecration.logger.log(Level.ERROR, "Tried to add unholy entity that is not registered! [" + resource.toString() + "]");
        }
    }

    public static void addSmiteProof(ResourceLocation resourceLocation) {
        if (EntityList.func_180125_b((ResourceLocation)resourceLocation)) {
            smiteProofList.add(resourceLocation);
        } else {
            Consecration.logger.log(Level.ERROR, "Tried to add smite-proof entity that is not registered! [" + resourceLocation.toString() + "]");
        }
    }

    public static void addHolyEntity(ResourceLocation resource) {
        if (EntityList.func_180125_b((ResourceLocation)resource)) {
            holyEntities.add(resource);
        } else {
            Consecration.logger.log(Level.ERROR, "Tried to add holy entity that is not registered! [" + resource.toString() + "]");
        }
    }

    public static void addHolyEnchantment(ResourceLocation resource) {
        if (Enchantment.field_185264_b.func_148741_d((Object)resource)) {
            holyEnchantments.add(Enchantment.func_180305_b((String)resource.toString()));
        } else {
            Consecration.logger.log(Level.ERROR, "Tried to add holy enchantment that is not registered! [" + resource.toString() + "]");
        }
    }

    public static void addHolyMaterial(String name) {
        holyMaterials.add(name.toLowerCase());
    }

    public static void addHolyDamage(String damageSource) {
        holyDamage.add(damageSource);
    }

    public static void addHolyWeapon(String weapon) {
        Item item = Item.func_111206_d((String)weapon);
        if (item != null) {
            UndeadRegistry.addHolyWeapon(new ItemStack(item));
        } else {
            Consecration.logger.log(Level.ERROR, "Tried to add holy weapon that is not registered! [" + weapon + "]");
        }
    }

    public static void addHolyWeapon(ItemStack weapon) {
        holyWeapons.add(weapon);
    }

    public static void addHolyPotion(ResourceLocation resource) {
        Potion potion = Potion.func_180142_b((String)resource.toString());
        if (potion != null) {
            holyPotions.add(potion);
        } else {
            Consecration.logger.log(Level.ERROR, "Tried to add holy potion that is not registered! [" + resource.toString() + "]");
        }
    }

    public static ImmutableList<Enchantment> getHolyEnchantments() {
        return ImmutableList.copyOf(holyEnchantments);
    }

    public static ImmutableList<Potion> getHolyPotions() {
        return ImmutableList.copyOf(holyPotions);
    }

    public static ImmutableSet<String> getHolyDamage() {
        return ImmutableSet.copyOf(holyDamage);
    }

    public static ImmutableList<ItemStack> getHolyWeapons() {
        return ImmutableList.copyOf(holyWeapons);
    }

    public static ImmutableSet<String> getHolyMaterials() {
        return ImmutableSet.copyOf(holyMaterials);
    }

    public static ImmutableList<ResourceLocation> getUndeadList() {
        return ImmutableList.copyOf(undeadList);
    }

    public static ImmutableList<ResourceLocation> getUnholyList() {
        return ImmutableList.copyOf(unholyList);
    }

    public static ImmutableList<ResourceLocation> getSmiteProofList() {
        return ImmutableList.copyOf(smiteProofList);
    }

    public static ImmutableList<ResourceLocation> getHolyEntities() {
        return ImmutableList.copyOf(holyEntities);
    }
}

