/*
 * Decompiled with CFR 0.152.
 */
package c4.consecration.integrations;

import api.materials.PartMaterial;
import c4.consecration.common.util.UndeadHelper;
import c4.consecration.integrations.ModuleCompatibility;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.common.Optional;
import toolbox.common.items.tools.IAdornedTool;
import toolbox.common.items.tools.IBladeTool;
import toolbox.common.items.tools.ICrossguardTool;
import toolbox.common.items.tools.IHaftTool;
import toolbox.common.items.tools.IHandleTool;
import toolbox.common.items.tools.IHeadTool;

public class ModuleToolbox
extends ModuleCompatibility {
    public ModuleToolbox() {
        super("toolbox");
    }

    @Override
    public boolean process(EntityLivingBase entity, DamageSource source) {
        if (source.func_76364_f() == null || !(source.func_76364_f() instanceof EntityLivingBase)) {
            return false;
        }
        ItemStack stack = ((EntityLivingBase)source.func_76364_f()).func_184614_ca();
        return this.isHolyToolbox(stack);
    }

    @Optional.Method(modid="toolbox")
    private boolean isHolyToolbox(ItemStack stack) {
        Item item = stack.func_77973_b();
        ArrayList<Object> materials = new ArrayList<Object>();
        if (item instanceof IHeadTool) {
            materials.add(IHeadTool.getHeadMat((ItemStack)stack));
        }
        if (item instanceof IBladeTool) {
            materials.add(IBladeTool.getBladeMat((ItemStack)stack));
        }
        if (item instanceof ICrossguardTool) {
            materials.add(ICrossguardTool.getCrossguardMat((ItemStack)stack));
        }
        if (item instanceof IHaftTool) {
            materials.add(IHaftTool.getHaftMat((ItemStack)stack));
        }
        if (item instanceof IHandleTool) {
            materials.add(IHandleTool.getHandleMat((ItemStack)stack));
        }
        if (item instanceof IAdornedTool) {
            materials.add(IAdornedTool.getAdornmentMat((ItemStack)stack));
        }
        for (PartMaterial partMaterial : materials) {
            if (!UndeadHelper.isHolyMaterial(partMaterial.getName())) continue;
            return true;
        }
        return false;
    }
}

