/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConsecrationConfig {
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;
    private static final String CONFIG_PREFIX = "gui.consecration.config.";

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> dimensions;
        public final ForgeConfigSpec.EnumValue<PermissionMode> dimensionPermission;
        public final ForgeConfigSpec.IntValue fireSmiteDuration;
        public final ForgeConfigSpec.IntValue holySmiteDuration;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> holyEntities;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> holyEffects;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> holyItems;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> holyEnchantments;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> holyDamage;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> holyMaterials;
        public final ForgeConfigSpec.BooleanValue defaultUndead;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> undeadList;
        public final ForgeConfigSpec.DoubleValue damageReduction;
        public final ForgeConfigSpec.IntValue healthRegen;
        public final ForgeConfigSpec.DoubleValue speedModifier;
        public final ForgeConfigSpec.BooleanValue bystanderNerf;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("dimension");
            this.dimensions = builder.comment("Set which dimensions are blacklisted or whitelisted for affected undead").translation("gui.consecration.config.dimensions").defineList("dimensions", ArrayList::new, x -> x instanceof Integer);
            this.dimensionPermission = builder.comment("Set whether the dimension configuration is blacklisted or whitelisted").translation("gui.consecration.config.dimensionPermission").defineEnum("dimensionPermission", (Enum)PermissionMode.BLACKLIST);
            builder.pop();
            builder.push("holy");
            this.fireSmiteDuration = builder.comment("The amount of time, in seconds, that smiting from fire lasts").translation("gui.consecration.config.fireSmiteDuration").defineInRange("fireSmiteDuration", 10, 0, 100);
            this.holySmiteDuration = builder.comment("The amount of time, in seconds, that smiting from holy sources lasts").translation("gui.consecration.config.holySmiteDuration").defineInRange("holySmiteDuration", 10, 0, 100);
            this.holyEntities = builder.comment("A list of entities that will be able to damage and smite undead").translation("gui.consecration.config.holyEntities").defineList("holyEntities", ArrayList::new, x -> x instanceof String);
            this.holyEffects = builder.comment("A list of potion effects that will be able to damage and smite undead").translation("gui.consecration.config.holyEffects").defineList("holyEffects", Arrays.asList("minecraft:instant_health", "consecration:holy"), x -> x instanceof String);
            this.holyItems = builder.comment("A list of items that will be able to damage and smite undead").translation("gui.consecration.config.holyItems").defineList("holyItems", ArrayList::new, x -> x instanceof String);
            this.holyEnchantments = builder.comment("A list of enchantments that will be able to damage and smite undead").translation("gui.consecration.config.holyEnchantments").defineList("holyEnchantments", Collections.singletonList("minecraft:smite"), x -> x instanceof String);
            this.holyDamage = builder.comment("A list of damage types that will be able to damage and smite undead").translation("gui.consecration.config.holyDamage").defineList("holyDamage", Collections.singletonList("holy"), x -> x instanceof String);
            this.holyMaterials = builder.comment("A list of materials that will be able to damage and smite undead").translation("gui.consecration.config.holyMaterial").defineList("holyMaterial", Collections.singletonList("silver"), x -> x instanceof String);
            builder.pop();
            builder.push("undying");
            this.defaultUndead = builder.comment("Set to true to give default undead the undying trait").translation("gui.consecration.config.defaultUndead").define("defaultUndead", true);
            this.undeadList = builder.comment("A list of mobs that to classify as undead.\nFormat: 'modid:name'\nOptionally, add ';unholy' or ';absolute' to the end.\nUnholy mobs will not be smote by fire and absolute mobs will not be smote by anything.").translation("gui.consecration.config.undeadList").defineList("undeadList", ArrayList::new, x -> x instanceof String);
            this.damageReduction = builder.comment("Set undead natural damage reduction, in percent, against all non-holy damage").translation("gui.consecration.config.damageReduction").defineInRange("damageReduction", 0.8, 0.0, 1.0);
            this.healthRegen = builder.comment("Set undead natural health regen, in half-hearts per second").translation("gui.consecration.config.healthRegen").defineInRange("healthRegen", 1, 0, 1000);
            this.speedModifier = builder.comment("Set undead natural bonus speed modifier").translation("gui.consecration.config.speedModifier").defineInRange("speedModifier", 0.0, 0.0, 100.0);
            this.bystanderNerf = builder.comment("Set to true to have undead reduce damage against non-player non-holy entities").translation("gui.consecration.config.bystanderNerf").define("bystanderNerf", true);
            builder.pop();
        }
    }

    public static enum PermissionMode {
        BLACKLIST,
        WHITELIST;

    }
}

