/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common;

import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraftforge.fml.InterModComms;
import top.theillusivec4.consecration.api.ConsecrationAPI;
import top.theillusivec4.consecration.common.ConsecrationConfig;

public class ConsecrationSeed {
    public static void imc(Stream<InterModComms.IMCMessage> stream) {
        stream.forEach(imcMessage -> {
            Object message = imcMessage.getMessageSupplier().get();
            String method = imcMessage.getMethod();
            if (message instanceof String) {
                String content = (String)message;
                switch (method) {
                    case "undead": {
                        ConsecrationAPI.addUndead(content);
                        break;
                    }
                    case "holy_entity": {
                        ConsecrationAPI.addHolyEntity(content);
                        break;
                    }
                    case "holy_effect": {
                        ConsecrationAPI.addHolyEffect(content);
                        break;
                    }
                    case "holy_item": {
                        ConsecrationAPI.addHolyItem(content);
                        break;
                    }
                    case "holy_enchantment": {
                        ConsecrationAPI.addHolyEnchantment(content);
                        break;
                    }
                    case "holy_material": {
                        ConsecrationAPI.addHolyMaterial(content);
                        break;
                    }
                    case "holy_damage": {
                        ConsecrationAPI.addHolyDamage(content);
                    }
                }
            } else if (message instanceof BiFunction) {
                switch (method) {
                    case "holy_attack": {
                        ConsecrationAPI.addHolyAttack((BiFunction)message);
                        break;
                    }
                    case "holy_protection": {
                        ConsecrationAPI.addHolyProtection((BiFunction)message);
                    }
                }
            }
        });
    }

    public static void config() {
        ConsecrationConfig.Server config = ConsecrationConfig.SERVER;
        ((List)config.undeadList.get()).forEach(ConsecrationAPI::addUndead);
        ((List)config.holyEntities.get()).forEach(ConsecrationAPI::addHolyEntity);
        ((List)config.holyEffects.get()).forEach(ConsecrationAPI::addHolyEffect);
        ((List)config.holyItems.get()).forEach(ConsecrationAPI::addHolyItem);
        ((List)config.holyEnchantments.get()).forEach(ConsecrationAPI::addHolyEnchantment);
        ((List)config.holyDamage.get()).forEach(ConsecrationAPI::addHolyDamage);
        ((List)config.holyMaterials.get()).forEach(ConsecrationAPI::addHolyMaterial);
    }
}

