/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.Level;
import top.theillusivec4.consecration.Consecration;
import top.theillusivec4.consecration.api.ConsecrationAPI;
import top.theillusivec4.consecration.common.ConsecrationConfig;

public class ConsecrationUtils {
    private static final Field AOE_CLOUD_POTION = ObfuscationReflectionHelper.findField(AreaEffectCloudEntity.class, (String)"field_184502_e");

    public static int protect(LivingEntity attacker, LivingEntity protect, DamageSource source) {
        if (ConsecrationUtils.getUndeadType(attacker.func_200600_R()) == ConsecrationAPI.UndeadType.ABSOLUTE) {
            return 0;
        }
        int[] level = new int[1];
        for (ItemStack itemStack : protect.func_184193_aE()) {
            if (itemStack.func_190926_b()) continue;
            Item item = itemStack.func_77973_b();
            if (item instanceof ArmorItem) {
                IArmorMaterial material = ((ArmorItem)item).func_200880_d();
                for (ItemStack mat : material.func_200898_c().func_193365_a()) {
                    ResourceLocation resourceLocation = mat.func_77973_b().getRegistryName();
                    if (resourceLocation == null || !ConsecrationUtils.containsHolyMaterial(resourceLocation)) continue;
                    level[0] = level[0] + 1;
                }
                continue;
            }
            if (!ConsecrationUtils.isHolyItem(item)) continue;
            level[0] = level[0] + 1;
        }
        for (BiFunction biFunction : ConsecrationAPI.getHolyProtection()) {
            level[0] = level[0] + (Integer)biFunction.apply(protect, source);
        }
        return level[0];
    }

    public static DamageType smite(LivingEntity target, DamageSource source) {
        ConsecrationAPI.UndeadType undeadType = ConsecrationUtils.getUndeadType(target.func_200600_R());
        if (undeadType == ConsecrationAPI.UndeadType.ABSOLUTE) {
            return DamageType.NONE;
        }
        if (!target.func_70045_F() && source.func_76347_k() && undeadType != ConsecrationAPI.UndeadType.UNHOLY) {
            return DamageType.FIRE;
        }
        if (source.func_76364_f() instanceof LivingEntity) {
            LivingEntity damager = (LivingEntity)source.func_76364_f();
            ItemStack stack = damager.func_184614_ca();
            Item item = stack.func_77973_b();
            if (item instanceof TieredItem) {
                TieredItem tieredItem = (TieredItem)item;
                IItemTier tier = tieredItem.func_200891_e();
                for (ItemStack mat : tier.func_200924_f().func_193365_a()) {
                    ResourceLocation resourceLocation = mat.func_77973_b().getRegistryName();
                    if (resourceLocation == null || !ConsecrationUtils.containsHolyMaterial(resourceLocation)) continue;
                    return DamageType.HOLY;
                }
            } else if (ConsecrationUtils.isHolyItem(item)) {
                return DamageType.HOLY;
            }
            if (ConsecrationUtils.hasHolyEnchantment(stack)) {
                return DamageType.HOLY;
            }
        }
        if (ConsecrationUtils.isHolyDamage(source) || ConsecrationUtils.isHolyEntity(source.func_76364_f()) || ConsecrationUtils.isHolyPotion(source.func_76364_f())) {
            return DamageType.HOLY;
        }
        return ConsecrationUtils.processHolyFunctions(target, source);
    }

    public static boolean isUndying(LivingEntity livingEntity) {
        return ConsecrationUtils.isValidCreature(livingEntity) && ConsecrationUtils.isValidDimension(livingEntity.func_130014_f_().field_73011_w.func_186058_p().func_186068_a());
    }

    public static boolean isValidCreature(LivingEntity livingEntity) {
        return (Boolean)ConsecrationConfig.SERVER.defaultUndead.get() != false && livingEntity.func_70668_bt() == CreatureAttribute.field_223223_b_ || ConsecrationAPI.getUndead().containsKey(livingEntity.func_200600_R());
    }

    public static boolean isValidDimension(int id) {
        List dimensions = (List)ConsecrationConfig.SERVER.dimensions.get();
        ConsecrationConfig.PermissionMode permissionMode = (ConsecrationConfig.PermissionMode)((Object)ConsecrationConfig.SERVER.dimensionPermission.get());
        if (dimensions.isEmpty()) {
            return true;
        }
        if (permissionMode == ConsecrationConfig.PermissionMode.BLACKLIST) {
            return !dimensions.contains(id);
        }
        return dimensions.contains(id);
    }

    public static boolean containsUndead(EntityType<?> entityType) {
        return ConsecrationAPI.getUndead().containsKey(entityType);
    }

    public static ConsecrationAPI.UndeadType getUndeadType(EntityType<?> entityType) {
        return ConsecrationAPI.getUndead().getOrDefault(entityType, ConsecrationAPI.UndeadType.NORMAL);
    }

    public static boolean isHolyEffect(Effect effect) {
        return ConsecrationAPI.getHolyEffects().contains(effect);
    }

    public static boolean isHolyPotion(Entity entity) {
        ArrayList effects = Lists.newArrayList();
        if (entity instanceof PotionEntity) {
            effects.addAll(PotionUtils.func_185189_a((ItemStack)((PotionEntity)entity).func_184543_l()));
        } else if (entity instanceof AreaEffectCloudEntity) {
            Potion potion = null;
            try {
                potion = (Potion)AOE_CLOUD_POTION.get(entity);
            }
            catch (IllegalAccessException e) {
                Consecration.LOGGER.log(Level.ERROR, "Error getting potion from AoE cloud " + entity);
            }
            if (potion != null) {
                effects.addAll(potion.func_185170_a());
            }
        }
        for (EffectInstance effect : effects) {
            Effect potion = effect.func_188419_a();
            if (!ConsecrationAPI.getHolyEffects().contains(potion)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasHolyEnchantment(ItemStack stack) {
        for (Enchantment enchantment : EnchantmentHelper.func_82781_a((ItemStack)stack).keySet()) {
            if (!ConsecrationAPI.getHolyEnchantments().contains(enchantment)) continue;
            return true;
        }
        return false;
    }

    public static DamageType processHolyFunctions(LivingEntity target, DamageSource source) {
        for (BiFunction<LivingEntity, DamageSource, Boolean> func : ConsecrationAPI.getHolyAttacks()) {
            if (!func.apply(target, source).booleanValue()) continue;
            return DamageType.HOLY;
        }
        return DamageType.NONE;
    }

    public static boolean isHolyEntity(@Nullable Entity entity) {
        return entity != null && ConsecrationAPI.getHolyEntities().contains(entity.func_200600_R());
    }

    public static boolean isHolyDamage(DamageSource source) {
        return ConsecrationAPI.getHolyDamage().contains(source.func_76355_l());
    }

    public static boolean isHolyItem(Item item) {
        return ConsecrationAPI.getHolyItems().contains(item);
    }

    public static boolean containsHolyMaterial(ResourceLocation resourceLocation) {
        for (String mat : ConsecrationAPI.getHolyMaterials()) {
            String pattern = "^" + mat + "(\\b|[_-]\\w*)";
            if (!resourceLocation.func_110623_a().matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public static enum DamageType {
        NONE,
        FIRE,
        HOLY;

    }
}

