/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common.capability;

import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.consecration.api.ConsecrationAPI;
import top.theillusivec4.consecration.common.ConsecrationConfig;
import top.theillusivec4.consecration.common.ConsecrationUtils;
import top.theillusivec4.consecration.common.capability.UndyingCapability;
import top.theillusivec4.consecration.common.trigger.SmiteTrigger;

public class CapabilityEventsHandler {
    private static final UUID SPEED_MOD = UUID.fromString("b812ef3d-0ef9-4368-845b-fad7003a1f4f");

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof LivingEntity && ConsecrationUtils.isUndying((LivingEntity)evt.getObject())) {
            evt.addCapability(UndyingCapability.ID, (ICapabilityProvider)new UndyingCapability.Provider());
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (!livingEntity.func_130014_f_().field_72995_K) {
            LazyOptional<UndyingCapability.IUndying> undyingOpt = UndyingCapability.getCapability(livingEntity);
            undyingOpt.ifPresent(undying -> {
                IAttributeInstance speedAttribute = livingEntity.func_110148_a(SharedMonsterAttributes.field_111263_d);
                speedAttribute.func_188479_b(SPEED_MOD);
                if (undying.hasSmite()) {
                    if (livingEntity.field_70173_aa % 10 == 0) {
                        ServerWorld world = (ServerWorld)livingEntity.func_130014_f_();
                        world.func_195598_a((IParticleData)ParticleTypes.field_197590_A, livingEntity.field_70165_t, livingEntity.field_70163_u + (double)livingEntity.func_213302_cg() / 2.0, livingEntity.field_70161_v, 2, (double)livingEntity.func_213311_cf() / 2.0, (double)livingEntity.func_213302_cg() / 4.0, (double)livingEntity.func_213311_cf() / 2.0, 0.0);
                    }
                    undying.tickSmite();
                } else {
                    double speedMod;
                    if (livingEntity.field_70173_aa % 20 == 0 && livingEntity.func_110143_aJ() < livingEntity.func_110138_aP()) {
                        livingEntity.func_70691_i((float)((Integer)ConsecrationConfig.SERVER.healthRegen.get()).intValue());
                    }
                    if ((speedMod = ((Double)ConsecrationConfig.SERVER.speedModifier.get()).doubleValue()) > 0.0 && speedAttribute.func_111127_a(SPEED_MOD) == null) {
                        speedAttribute.func_111121_a(new AttributeModifier(SPEED_MOD, "Undead speed", speedMod, AttributeModifier.Operation.MULTIPLY_TOTAL));
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onPotionAdded(PotionEvent.PotionAddedEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (!livingEntity.func_130014_f_().field_72995_K) {
            LazyOptional<UndyingCapability.IUndying> undyingOpt = UndyingCapability.getCapability(livingEntity);
            undyingOpt.ifPresent(undying -> {
                Effect effect1;
                EffectInstance effectInstance = evt.getPotionEffect();
                Set<Effect> effect = ConsecrationAPI.getHolyEffects();
                if (effect.contains(effect1 = effectInstance.func_188419_a())) {
                    int duration = effect1.func_76403_b() ? ((Integer)ConsecrationConfig.SERVER.holySmiteDuration.get()).intValue() : effectInstance.func_76459_b();
                    undying.setSmiteDuration(duration * 20);
                }
            });
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (!livingEntity.func_130014_f_().field_72995_K) {
            LazyOptional<UndyingCapability.IUndying> undyingOpt = UndyingCapability.getCapability(livingEntity);
            if (!undyingOpt.isPresent() && evt.getSource().func_76364_f() instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)evt.getSource().func_76364_f();
                LazyOptional<UndyingCapability.IUndying> undyingOpt2 = UndyingCapability.getCapability(attacker);
                undyingOpt2.ifPresent(undying -> {
                    int level = ConsecrationUtils.protect(attacker, livingEntity, evt.getSource());
                    if (level > 0 && livingEntity.func_130014_f_().field_73012_v.nextFloat() < 0.15f * (float)level) {
                        undying.setSmiteDuration((Integer)ConsecrationConfig.SERVER.holySmiteDuration.get() * 20);
                    }
                });
            }
            undyingOpt.ifPresent(undying -> {
                Entity trueSource;
                DamageSource source = evt.getSource();
                if (source == DamageSource.field_76380_i || source == DamageSource.field_191291_g || source == DamageSource.field_76368_d) {
                    return;
                }
                ConsecrationUtils.DamageType type = ConsecrationUtils.smite(livingEntity, source);
                if (type != ConsecrationUtils.DamageType.NONE) {
                    if (type == ConsecrationUtils.DamageType.FIRE) {
                        undying.setSmiteDuration((Integer)ConsecrationConfig.SERVER.fireSmiteDuration.get() * 20);
                    } else {
                        undying.setSmiteDuration((Integer)ConsecrationConfig.SERVER.holySmiteDuration.get() * 20);
                    }
                    if (source.func_76346_g() instanceof ServerPlayerEntity) {
                        SmiteTrigger.INSTANCE.trigger((ServerPlayerEntity)source.func_76346_g());
                    }
                } else if (!source.func_151517_h() && !undying.hasSmite() && (trueSource = source.func_76346_g()) != null && (trueSource instanceof PlayerEntity || ((Boolean)ConsecrationConfig.SERVER.bystanderNerf.get()).booleanValue())) {
                    evt.setAmount(evt.getAmount() * (float)(1.0 - (Double)ConsecrationConfig.SERVER.damageReduction.get()));
                }
            });
        }
    }
}

