/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingbook;

import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.blay09.mods.cookingbook.api.kitchen.IKitchenItemProvider;
import net.blay09.mods.cookingbook.api.kitchen.IKitchenSmeltingProvider;
import net.blay09.mods.cookingbook.api.kitchen.IKitchenStorageProvider;
import net.blay09.mods.cookingbook.api.kitchen.IMultiblockKitchen;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class KitchenMultiBlock {
    public static final Map<String, Class<? extends IMultiblockKitchen>> tileEntityWrappers = new HashMap<String, Class<? extends IMultiblockKitchen>>();
    public static final Map<String, Class<? extends IMultiblockKitchen>> blockWrappers = new HashMap<String, Class<? extends IMultiblockKitchen>>();
    private final Map<BlockPosition, IMultiblockKitchen> kitchenParts = new HashMap<BlockPosition, IMultiblockKitchen>();
    private final List<IKitchenStorageProvider> storageProviderList = new ArrayList<IKitchenStorageProvider>();
    private final List<IKitchenItemProvider> itemProviderList = new ArrayList<IKitchenItemProvider>();
    private final List<IKitchenSmeltingProvider> smeltingProviderList = new ArrayList<IKitchenSmeltingProvider>();
    private final List<IInventory> sourceInventories = new ArrayList<IInventory>();

    public KitchenMultiBlock(World world, int x, int y, int z) {
        this.findNeighbourKitchenBlocks(world, x, y, z);
    }

    private void findNeighbourKitchenBlocks(World world, int x, int y, int z) {
        for (int i = 0; i <= 5; ++i) {
            TileEntity tileEntity;
            IMultiblockKitchen kitchenPart;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            BlockPosition position = new BlockPosition(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if (this.kitchenParts.containsKey(position) || (kitchenPart = (tileEntity = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) instanceof IMultiblockKitchen ? (IMultiblockKitchen)tileEntity : (tileEntity != null ? KitchenMultiBlock.getWrapper(tileEntity) : KitchenMultiBlock.getWrapper(world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)))) == null) continue;
            this.kitchenParts.put(position, kitchenPart);
            if (kitchenPart instanceof IKitchenStorageProvider) {
                this.storageProviderList.add((IKitchenStorageProvider)kitchenPart);
            }
            if (kitchenPart instanceof IKitchenSmeltingProvider) {
                this.smeltingProviderList.add((IKitchenSmeltingProvider)kitchenPart);
            }
            if (kitchenPart instanceof IKitchenItemProvider) {
                this.itemProviderList.add((IKitchenItemProvider)kitchenPart);
            }
            this.findNeighbourKitchenBlocks(world, position.x, position.y, position.z);
        }
    }

    public List<IInventory> getSourceInventories(InventoryPlayer playerInventory) {
        this.sourceInventories.clear();
        this.sourceInventories.add((IInventory)playerInventory);
        for (IKitchenStorageProvider provider : this.storageProviderList) {
            this.sourceInventories.add(provider.getInventory());
        }
        return this.sourceInventories;
    }

    public ItemStack smeltItem(ItemStack itemStack, int count) {
        IKitchenSmeltingProvider provider;
        ItemStack restStack = itemStack.func_77946_l().func_77979_a(count);
        Iterator<IKitchenSmeltingProvider> i$ = this.smeltingProviderList.iterator();
        while (i$.hasNext() && (restStack = (provider = i$.next()).smeltItem(restStack)) != null) {
        }
        itemStack.field_77994_a = itemStack.field_77994_a - (count - (restStack != null ? restStack.field_77994_a : 0));
        if (itemStack.field_77994_a <= 0) {
            return null;
        }
        return itemStack;
    }

    public boolean hasSmeltingProvider() {
        return this.smeltingProviderList.size() > 0;
    }

    public List<IKitchenItemProvider> getItemProviders() {
        return this.itemProviderList;
    }

    public static IMultiblockKitchen getWrapper(Block block) {
        Class<? extends IMultiblockKitchen> clazz;
        GameRegistry.UniqueIdentifier identifier = GameRegistry.findUniqueIdentifierFor((Block)block);
        if (identifier != null && (clazz = blockWrappers.get(identifier.modId + ":" + identifier.name)) != null) {
            try {
                return clazz.getConstructor(Block.class).newInstance(block);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IMultiblockKitchen getWrapper(TileEntity tileEntity) {
        Class<? extends IMultiblockKitchen> clazz = tileEntityWrappers.get(tileEntity.getClass().getName());
        if (clazz != null) {
            try {
                return clazz.getConstructor(TileEntity.class).newInstance(tileEntity);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private class BlockPosition {
        public final int x;
        public final int y;
        public final int z;

        public BlockPosition(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockPosition that = (BlockPosition)o;
            if (this.x != that.x) {
                return false;
            }
            if (this.y != that.y) {
                return false;
            }
            return this.z == that.z;
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.y;
            result = 31 * result + this.z;
            return result;
        }
    }
}

