/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingbook.block;

import java.util.List;
import net.blay09.mods.cookingbook.CookingConfig;
import net.blay09.mods.cookingbook.api.kitchen.IKitchenSmeltingProvider;
import net.blay09.mods.cookingbook.api.kitchen.IKitchenStorageProvider;
import net.blay09.mods.cookingbook.container.ContainerCookingOven;
import net.blay09.mods.cookingbook.registry.CookingRegistry;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class TileEntityCookingOven
extends TileEntity
implements ISidedInventory,
IKitchenSmeltingProvider,
IKitchenStorageProvider {
    private static final int[] slotsTop = new int[]{0, 1, 2};
    private static final int[] slotsSide = new int[]{3};
    private static final int[] slotsBottom = new int[]{4, 5, 6};
    private static final int[] slotsCenter = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int SLOT_CENTER_OFFSET = 7;
    private static final int COOK_TIME = 200;
    private EntityItem[] renderItem = new EntityItem[4];
    private EntityItem interiorRenderItem;
    private ItemStack[] inventory = new ItemStack[20];
    private OvenInventory ovenInventory = new OvenInventory((IInventory)this);
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int[] slotCookTime = new int[9];
    private float prevDoorAngle;
    private float doorAngle;
    private int numPlayersUsing;
    private int tickCounter;

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        this.interiorRenderItem = new EntityItem(world, 0.0, 0.0, 0.0);
        this.interiorRenderItem.field_70290_d = 0.0f;
        for (int i = 0; i < this.renderItem.length; ++i) {
            this.renderItem[i] = new EntityItem(world, 0.0, 0.0, 0.0);
            this.renderItem[i].field_70290_d = 0.0f;
            this.renderItem[i].func_92058_a(this.inventory[16 + i]);
        }
    }

    public int[] func_94128_d(int side) {
        switch (ForgeDirection.getOrientation((int)side)) {
            case UP: {
                return slotsTop;
            }
            case DOWN: {
                return slotsBottom;
            }
        }
        return slotsSide;
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int side) {
        return !CookingConfig.disallowOvenAutomation && this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int side) {
        return !CookingConfig.disallowOvenAutomation;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int count) {
        if (i >= 7 && i < 16) {
            this.slotCookTime[i - 7] = 0;
        }
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= count) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.inventory[i].func_77979_a(count);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.inventory[i] = itemStack;
        if (i >= 16 && i < 20) {
            this.renderItem[i - 16].func_92058_a(itemStack);
        }
        if (itemStack == null && i >= 7 && i < 16) {
            this.slotCookTime[i - 7] = 0;
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "container.cookingbook:cookingoven";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: {
                return itemStack.func_77973_b() instanceof ItemFood;
            }
            case 3: 
            case 4: 
            case 5: {
                return TileEntityCookingOven.isItemFuel(itemStack);
            }
        }
        return false;
    }

    public boolean func_145842_c(int id, int value) {
        if (id == 1) {
            this.numPlayersUsing = value;
            return true;
        }
        return super.func_145842_c(id, value);
    }

    public void func_70295_k_() {
        ++this.numPlayersUsing;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numPlayersUsing);
    }

    public void func_70305_f() {
        --this.numPlayersUsing;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numPlayersUsing);
    }

    public void func_145845_h() {
        float doorSpeed;
        super.func_145845_h();
        this.fixBrokenContainerClosedCall();
        boolean hasChanged = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        this.prevDoorAngle = this.doorAngle;
        if (this.numPlayersUsing > 0) {
            doorSpeed = 0.2f;
            this.doorAngle = Math.min(1.0f, this.doorAngle + 0.2f);
        } else {
            doorSpeed = 0.1f;
            this.doorAngle = Math.max(0.0f, this.doorAngle - 0.1f);
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceBurnTime == 0 && this.canCook()) {
                for (int j : slotsSide) {
                    if (this.func_70301_a(j) == null) continue;
                    ItemStack fuelItem = this.func_70301_a(j);
                    this.currentItemBurnTime = this.furnaceBurnTime = (int)Math.max(1.0f, (float)TileEntityCookingOven.getItemBurnTime(fuelItem) * CookingConfig.ovenFuelTimeMultiplier);
                    if (this.furnaceBurnTime == 0) break;
                    --fuelItem.field_77994_a;
                    if (fuelItem.field_77994_a == 0) {
                        this.func_70299_a(j, fuelItem.func_77973_b().getContainerItem(fuelItem));
                    }
                    hasChanged = true;
                    break;
                }
            }
            if (this.furnaceBurnTime == 0 && !this.field_145850_b.field_72995_K) {
                for (int i = 0; i < this.slotCookTime.length; ++i) {
                    if (this.slotCookTime[i] <= 0) continue;
                    this.slotCookTime[i] = 0;
                }
            }
            int firstEmptySlot = -1;
            int firstTransferSlot = -1;
            for (int i : slotsCenter) {
                if (this.func_70301_a(i) != null) {
                    if (this.slotCookTime[i - 7] != -1) {
                        ItemStack resultStack;
                        int n = i - 7;
                        this.slotCookTime[n] = this.slotCookTime[n] + 1;
                        if (!((float)this.slotCookTime[i - 7] >= 200.0f * CookingConfig.ovenCookTimeMultiplier) || (resultStack = TileEntityCookingOven.getSmeltingResult(this.func_70301_a(i))) == null) continue;
                        this.func_70299_a(i, resultStack.func_77946_l());
                        this.slotCookTime[i - 7] = -1;
                        if (firstTransferSlot != -1) continue;
                        firstTransferSlot = i;
                        continue;
                    }
                    if (firstTransferSlot != -1) continue;
                    firstTransferSlot = i;
                    continue;
                }
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
            }
            if (firstTransferSlot != -1) {
                ItemStack transferStack = this.func_70301_a(firstTransferSlot);
                while (transferStack.field_77994_a > 0) {
                    int firstResultSlot = -1;
                    int resultSpaceLeft = 0;
                    for (int j : slotsBottom) {
                        ItemStack slotStack = this.func_70301_a(j);
                        if (slotStack == null || slotStack.func_77973_b() != transferStack.func_77973_b() || (resultSpaceLeft = slotStack.func_77976_d() - slotStack.field_77994_a) <= 0) continue;
                        firstResultSlot = j;
                        break;
                    }
                    if (firstResultSlot == -1) {
                        for (int j : slotsBottom) {
                            if (this.func_70301_a(j) != null) continue;
                            firstResultSlot = j;
                            resultSpaceLeft = transferStack.func_77976_d();
                            break;
                        }
                    }
                    if (firstResultSlot == -1) break;
                    ItemStack resultSlotStack = this.func_70301_a(firstResultSlot);
                    if (resultSlotStack != null) {
                        resultSlotStack.field_77994_a += Math.min(transferStack.field_77994_a, resultSpaceLeft);
                        transferStack.field_77994_a -= Math.min(transferStack.field_77994_a, resultSpaceLeft);
                    } else {
                        this.func_70299_a(firstResultSlot, transferStack.func_77946_l());
                        transferStack.field_77994_a = 0;
                    }
                    if (transferStack.field_77994_a > 0) continue;
                    this.func_70299_a(firstTransferSlot, null);
                }
                if (this.func_70301_a(firstTransferSlot) == null) {
                    this.slotCookTime[firstTransferSlot - 7] = 0;
                }
                hasChanged = true;
            }
            if (firstEmptySlot != -1) {
                for (int j : slotsTop) {
                    ItemStack itemStack = this.func_70301_a(j);
                    if (itemStack == null) continue;
                    this.func_70299_a(firstEmptySlot, itemStack.func_77979_a(1));
                    if (itemStack.field_77994_a > 0) break;
                    this.func_70299_a(j, null);
                    break;
                }
            }
        }
        if (hasChanged) {
            this.func_70296_d();
        }
    }

    private void fixBrokenContainerClosedCall() {
        ++this.tickCounter;
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.tickCounter + this.field_145851_c + this.field_145848_d + this.field_145849_e) % 200 == 0) {
            this.numPlayersUsing = 0;
            float range = 5.0f;
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - range), (double)((float)this.field_145848_d - range), (double)((float)this.field_145849_e - range), (double)((float)this.field_145851_c + 1.0f + range), (double)((float)this.field_145848_d + 1.0f + range), (double)((float)this.field_145849_e + 1.0f + range)));
            for (EntityPlayer entityPlayer : list) {
                if (!(entityPlayer.field_71070_bA instanceof ContainerCookingOven) || ((ContainerCookingOven)entityPlayer.field_71070_bA).getTileEntity() != this) continue;
                ++this.numPlayersUsing;
            }
        }
    }

    public static ItemStack getSmeltingResult(ItemStack itemStack) {
        ItemStack result = CookingRegistry.getSmeltingResult(itemStack);
        if (result != null) {
            return result;
        }
        return FurnaceRecipes.func_77602_a().func_151395_a(itemStack);
    }

    public static boolean isItemFuel(ItemStack itemStack) {
        return TileEntityCookingOven.getItemBurnTime(itemStack) > 0;
    }

    public static int getItemBurnTime(ItemStack fuelItem) {
        int fuelTime = CookingRegistry.getOvenFuelTime(fuelItem);
        if (fuelTime != 0 || CookingConfig.ovenRequiresCookingOil) {
            return fuelTime;
        }
        return TileEntityFurnace.func_145952_a((ItemStack)fuelItem);
    }

    private boolean canCook() {
        for (int k : slotsCenter) {
            ItemStack cookingStack = this.func_70301_a(k);
            if (cookingStack != null && this.slotCookTime[k - 7] != -1) {
                return true;
            }
            if (cookingStack != null) continue;
            for (int i : slotsTop) {
                if (this.func_70301_a(i) == null) continue;
                return true;
            }
            break;
        }
        return false;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.func_145830_o()) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList tagList = compound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemCompound = tagList.func_150305_b(i);
            byte slotId = itemCompound.func_74771_c("Slot");
            if (slotId < 0 || slotId >= this.inventory.length) continue;
            this.inventory[slotId] = ItemStack.func_77949_a((NBTTagCompound)itemCompound);
            if (slotId < 16 || slotId >= 20 || this.renderItem[slotId - 16] == null) continue;
            this.renderItem[slotId - 16].func_92058_a(this.inventory[slotId]);
        }
        this.furnaceBurnTime = compound.func_74765_d("BurnTime");
        this.currentItemBurnTime = compound.func_74765_d("CurrentItemBurnTime");
        this.slotCookTime = compound.func_74759_k("CookTimes");
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound itemCompound = new NBTTagCompound();
            itemCompound.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(itemCompound);
            tagList.func_74742_a((NBTBase)itemCompound);
        }
        compound.func_74782_a("Items", (NBTBase)tagList);
        compound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        compound.func_74777_a("CurrentItemBurnTime", (short)this.currentItemBurnTime);
        compound.func_74783_a("CookTimes", ArrayUtils.clone((int[])this.slotCookTime));
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public float getBurnTimeProgress() {
        return (float)this.furnaceBurnTime / (float)this.currentItemBurnTime;
    }

    public float getCookProgress(int i) {
        return (float)this.slotCookTime[i] / (200.0f * CookingConfig.ovenCookTimeMultiplier);
    }

    public EntityItem getRenderItem(int i) {
        return this.renderItem[i];
    }

    @Override
    public IInventory getInventory() {
        return this.ovenInventory;
    }

    @Override
    public ItemStack smeltItem(ItemStack itemStack) {
        int[] inputSlots = this.func_94128_d(ForgeDirection.UP.ordinal());
        int firstEmptySlot = -1;
        for (int slot : inputSlots) {
            ItemStack slotStack = this.func_70301_a(slot);
            if (slotStack != null) {
                int spaceLeft;
                if (slotStack.func_77969_a(slotStack) && (spaceLeft = Math.min(itemStack.field_77994_a, slotStack.func_77976_d() - slotStack.field_77994_a)) > 0) {
                    slotStack.field_77994_a += spaceLeft;
                    itemStack.field_77994_a -= spaceLeft;
                }
                if (itemStack.field_77994_a > 0) continue;
                return null;
            }
            if (firstEmptySlot != -1) continue;
            firstEmptySlot = slot;
        }
        if (firstEmptySlot != -1) {
            this.func_70299_a(firstEmptySlot, itemStack);
            return null;
        }
        return itemStack;
    }

    public float getPrevDoorAngle() {
        return this.prevDoorAngle;
    }

    public float getDoorAngle() {
        return this.doorAngle;
    }

    public EntityItem getInteriorRenderItem() {
        return this.interiorRenderItem;
    }

    public static class OvenInventory
    implements IInventory {
        private final IInventory inventory;

        public OvenInventory(IInventory inventory) {
            this.inventory = inventory;
        }

        public int func_70302_i_() {
            return 7;
        }

        public ItemStack func_70301_a(int i) {
            if (i >= 3) {
                return this.inventory.func_70301_a(16 + i - 3);
            }
            return this.inventory.func_70301_a(i + 4);
        }

        public ItemStack func_70298_a(int i, int amount) {
            if (i >= 3) {
                return this.inventory.func_70298_a(16 + i - 3, amount);
            }
            return this.inventory.func_70298_a(i + 4, amount);
        }

        public ItemStack func_70304_b(int i) {
            if (i >= 3) {
                return this.inventory.func_70304_b(16 + i - 3);
            }
            return this.inventory.func_70304_b(i + 4);
        }

        public void func_70299_a(int i, ItemStack itemStack) {
            if (i >= 3) {
                this.inventory.func_70299_a(16 + i - 3, itemStack);
            } else {
                this.inventory.func_70299_a(i + 4, itemStack);
            }
        }

        public String func_145825_b() {
            return this.inventory.func_145825_b();
        }

        public boolean func_145818_k_() {
            return this.inventory.func_145818_k_();
        }

        public int func_70297_j_() {
            return this.inventory.func_70297_j_();
        }

        public void func_70296_d() {
            this.inventory.func_70296_d();
        }

        public boolean func_70300_a(EntityPlayer player) {
            return this.inventory.func_70300_a(player);
        }

        public void func_70295_k_() {
            this.inventory.func_70295_k_();
        }

        public void func_70305_f() {
            this.inventory.func_70305_f();
        }

        public boolean func_94041_b(int i, ItemStack itemStack) {
            if (i >= 3) {
                return this.inventory.func_94041_b(16 + i - 3, itemStack);
            }
            return this.inventory.func_94041_b(i + 4, itemStack);
        }
    }
}

