/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.container.comparator.ComparatorName;
import net.blay09.mods.cookingforblockheads.container.inventory.InventoryCraftBook;
import net.blay09.mods.cookingforblockheads.container.slot.FakeSlot;
import net.blay09.mods.cookingforblockheads.container.slot.FakeSlotCraftMatrix;
import net.blay09.mods.cookingforblockheads.container.slot.FakeSlotRecipe;
import net.blay09.mods.cookingforblockheads.network.NetworkHandler;
import net.blay09.mods.cookingforblockheads.network.message.MessageCraftRecipe;
import net.blay09.mods.cookingforblockheads.network.message.MessageItemList;
import net.blay09.mods.cookingforblockheads.network.message.MessageRecipes;
import net.blay09.mods.cookingforblockheads.network.message.MessageRequestRecipes;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeWithIngredients;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeWithStatus;
import net.blay09.mods.cookingforblockheads.registry.RecipeStatus;
import net.blay09.mods.cookingforblockheads.registry.RecipeType;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodIngredient;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodRecipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerRecipeBook
extends Container {
    private final EntityPlayer player;
    private final List<FakeSlotRecipe> recipeSlots = Lists.newArrayList();
    private final List<FakeSlotCraftMatrix> matrixSlots = Lists.newArrayList();
    private final InventoryCraftBook craftBook = new InventoryCraftBook(this);
    private boolean noFilter;
    private boolean allowCrafting;
    private KitchenMultiBlock multiBlock;
    private boolean isDirty = true;
    private ItemStack lastOutputItem;
    private final List<FoodRecipeWithStatus> itemList = Lists.newArrayList();
    private Comparator<FoodRecipeWithStatus> currentSorting = new ComparatorName();
    private final List<FoodRecipeWithStatus> filteredItems = Lists.newArrayList();
    @SideOnly(value=Side.CLIENT)
    private String currentSearch;
    @SideOnly(value=Side.CLIENT)
    private boolean isDirtyClient;
    @SideOnly(value=Side.CLIENT)
    private boolean hasOven;
    @SideOnly(value=Side.CLIENT)
    private int scrollOffset;
    @SideOnly(value=Side.CLIENT)
    private FakeSlotRecipe selectedRecipe;
    @SideOnly(value=Side.CLIENT)
    private List<FoodRecipeWithIngredients> selectedRecipeList;
    @SideOnly(value=Side.CLIENT)
    private int selectedRecipeIndex;

    public ContainerRecipeBook(EntityPlayer player) {
        FakeSlot slot;
        int j;
        int i;
        this.player = player;
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 3; ++j) {
                slot = new FakeSlotRecipe(j + i * 3, 102 + j * 18, 11 + i * 18);
                this.recipeSlots.add((FakeSlotRecipe)slot);
                this.func_75146_a(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                slot = new FakeSlotCraftMatrix(j + i * 3, 24 + j * 18, 20 + i * 18);
                this.matrixSlots.add((FakeSlotCraftMatrix)slot);
                this.func_75146_a(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, j + i * 9 + 9, 8 + j * 18, 92 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, i, 8 + i * 18, 150));
        }
    }

    public ItemStack func_184996_a(int slotNumber, int dragType, ClickType clickType, EntityPlayer player) {
        if (slotNumber >= 0 && slotNumber < this.field_75151_b.size()) {
            Slot slot = (Slot)this.field_75151_b.get(slotNumber);
            if (player.field_70170_p.field_72995_K) {
                if (slot instanceof FakeSlotRecipe) {
                    FakeSlotRecipe slotRecipe = (FakeSlotRecipe)slot;
                    if (slotRecipe.getRecipe() != null) {
                        if (slotRecipe == this.selectedRecipe) {
                            FoodRecipeWithIngredients recipe;
                            if (this.allowCrafting && (clickType == ClickType.QUICK_MOVE || clickType == ClickType.PICKUP) && (recipe = this.getSelection()) != null) {
                                ArrayList craftMatrix = Lists.newArrayList();
                                if (recipe.getRecipeType() == RecipeType.CRAFTING) {
                                    for (FakeSlotCraftMatrix matrixSlot : this.matrixSlots) {
                                        craftMatrix.add(matrixSlot.func_75211_c());
                                    }
                                } else if (recipe.getRecipeType() == RecipeType.SMELTING) {
                                    craftMatrix.add(this.matrixSlots.get(4).func_75211_c());
                                }
                                NetworkHandler.instance.sendToServer((IMessage)new MessageCraftRecipe(recipe.getOutputItem(), recipe.getRecipeType(), craftMatrix, clickType == ClickType.QUICK_MOVE));
                            }
                        } else {
                            this.selectedRecipe = slotRecipe;
                            NetworkHandler.instance.sendToServer((IMessage)new MessageRequestRecipes(this.selectedRecipe.getRecipe().getOutputItem()));
                        }
                    }
                } else if (slot instanceof FakeSlotCraftMatrix) {
                    ((FakeSlotCraftMatrix)slot).setLocked(!((FakeSlotCraftMatrix)slot).isLocked());
                }
            }
        }
        return super.func_184996_a(slotNumber, dragType, clickType, player);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.player.field_70170_p.field_72995_K && (this.isDirty || this.player.field_71071_by.field_70459_e)) {
            this.findAndSendItemList();
            if (this.lastOutputItem != null) {
                this.findAndSendRecipes(this.lastOutputItem);
            }
            this.player.field_71071_by.field_70459_e = false;
            this.isDirty = false;
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void func_75130_a(IInventory inventory) {
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            if (slotIndex >= 48 && slotIndex < 57 ? !this.func_75135_a(slotStack, 21, 48, true) : slotIndex >= 21 && slotIndex < 48 && !this.func_75135_a(slotStack, 48, 57, false)) {
                return null;
            }
            if (slotStack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
        }
        return itemStack;
    }

    public ContainerRecipeBook setNoFilter() {
        this.noFilter = true;
        return this;
    }

    public ContainerRecipeBook allowCrafting() {
        this.allowCrafting = true;
        return this;
    }

    public ContainerRecipeBook setKitchenMultiBlock(KitchenMultiBlock kitchenMultiBlock) {
        this.multiBlock = kitchenMultiBlock;
        return this;
    }

    public void findAndSendItemList() {
        HashMap statusMap = Maps.newHashMap();
        List<IKitchenItemProvider> inventories = CookingRegistry.getItemProviders(this.multiBlock, this.player.field_71071_by);
        block0: for (ResourceLocation key : CookingRegistry.getFoodRecipes().keySet()) {
            Enum bestStatus = null;
            for (FoodRecipe recipe : CookingRegistry.getFoodRecipes().get((Object)key)) {
                RecipeStatus thisStatus = CookingRegistry.getRecipeStatus(recipe, inventories);
                if (!(!this.noFilter && thisStatus == RecipeStatus.MISSING_INGREDIENTS || bestStatus != null && thisStatus.ordinal() <= bestStatus.ordinal())) {
                    statusMap.put(key, new FoodRecipeWithStatus(recipe.getOutputItem(), thisStatus));
                    bestStatus = thisStatus;
                }
                if (bestStatus != RecipeStatus.AVAILABLE) continue;
                continue block0;
            }
        }
        NetworkHandler.instance.sendTo((IMessage)new MessageItemList(statusMap.values(), this.multiBlock != null && this.multiBlock.hasSmeltingProvider()), (EntityPlayerMP)this.player);
    }

    public void findAndSendRecipes(ItemStack outputItem) {
        this.lastOutputItem = outputItem;
        ArrayList resultList = Lists.newArrayList();
        List<IKitchenItemProvider> inventories = CookingRegistry.getItemProviders(this.multiBlock, this.player.field_71071_by);
        block0: for (FoodRecipe recipe : CookingRegistry.getFoodRecipes(outputItem)) {
            for (IKitchenItemProvider itemProvider : inventories) {
                itemProvider.resetSimulation();
            }
            List<FoodIngredient> ingredients = recipe.getCraftMatrix();
            ArrayList craftMatrix = Lists.newArrayListWithCapacity((int)ingredients.size());
            boolean requireBucket = CookingRegistry.doesItemRequireBucketForCrafting(recipe.getOutputItem());
            for (FoodIngredient ingredient : ingredients) {
                ArrayList stackList = Lists.newArrayList();
                if (ingredient != null) {
                    for (ItemStack checkStack : ingredient.getItemStacks()) {
                        ItemStack foundStack = CookingRegistry.findAnyItemStack(checkStack, inventories, requireBucket);
                        if (foundStack == null && (this.noFilter || ingredient.isToolItem())) {
                            ItemStack itemStack = foundStack = ingredient.getItemStacks().length > 0 ? ingredient.getItemStacks()[0] : null;
                        }
                        if (foundStack == null) continue block0;
                        stackList.add(foundStack);
                    }
                }
                craftMatrix.add(stackList);
            }
            resultList.add(new FoodRecipeWithIngredients(recipe.getOutputItem(), recipe.getType(), recipe.getRecipeWidth(), craftMatrix));
        }
        NetworkHandler.instance.sendTo((IMessage)new MessageRecipes(outputItem, resultList), (EntityPlayerMP)this.player);
    }

    public void tryCraft(@Nullable ItemStack outputItem, RecipeType recipeType, List<ItemStack> craftMatrix, boolean stack) {
        if (outputItem == null || craftMatrix.size() == 0) {
            return;
        }
        if (this.allowCrafting) {
            if (recipeType == RecipeType.CRAFTING) {
                ItemStack itemStack;
                int craftCount = stack ? outputItem.func_77976_d() : 1;
                for (int i = 0; i < craftCount && (itemStack = this.craftBook.tryCraft(outputItem, craftMatrix, this.player, this.multiBlock)) != null; ++i) {
                    if (this.player.field_71071_by.func_70441_a(itemStack)) continue;
                    this.player.func_71019_a(itemStack, false);
                }
                this.isDirty = true;
                this.func_75142_b();
            } else if (recipeType == RecipeType.SMELTING && this.multiBlock != null && this.multiBlock.hasSmeltingProvider()) {
                this.multiBlock.trySmelt(outputItem, craftMatrix.get(0), this.player, stack);
                this.isDirty = true;
            }
        }
    }

    public boolean isAllowCrafting() {
        return this.allowCrafting;
    }

    @SideOnly(value=Side.CLIENT)
    public void setItemList(Collection<FoodRecipeWithStatus> recipeList) {
        this.itemList.clear();
        this.itemList.addAll(recipeList);
        this.search(this.currentSearch);
        Collections.sort(this.filteredItems, this.currentSorting);
        if (this.selectedRecipe != null && this.selectedRecipe.getRecipe() != null) {
            Iterator<FoodRecipeWithStatus> it = this.filteredItems.iterator();
            FoodRecipeWithStatus found = null;
            while (it.hasNext()) {
                FoodRecipeWithStatus recipe = it.next();
                if (recipe.getOutputItem().func_77973_b() != this.selectedRecipe.getRecipe().getOutputItem().func_77973_b()) continue;
                found = recipe;
                it.remove();
            }
            int index = this.scrollOffset + this.selectedRecipe.getSlotIndex();
            while (index > this.filteredItems.size()) {
                this.filteredItems.add(null);
            }
            this.filteredItems.add(index, found);
        }
        this.populateRecipeSlots();
        this.setDirty(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void populateRecipeSlots() {
        int i = this.scrollOffset * 3;
        for (FakeSlotRecipe slot : this.recipeSlots) {
            if (i < this.filteredItems.size()) {
                slot.setFoodRecipe(this.filteredItems.get(i));
                ++i;
                continue;
            }
            slot.setFoodRecipe(null);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void populateMatrixSlots() {
        if (this.selectedRecipeList == null) {
            for (FakeSlotCraftMatrix matrixSlot : this.matrixSlots) {
                matrixSlot.setIngredient(null);
            }
            return;
        }
        FoodRecipeWithIngredients recipe = this.selectedRecipeList.get(this.selectedRecipeIndex);
        if (recipe.getRecipeType() == RecipeType.SMELTING) {
            for (int i = 0; i < this.matrixSlots.size(); ++i) {
                this.matrixSlots.get(i).setIngredient(i == 4 ? recipe.getCraftMatrix().get(0) : null);
            }
        } else {
            int i;
            for (i = 0; i < this.matrixSlots.size(); ++i) {
                this.matrixSlots.get(i).setIngredient(null);
            }
            for (i = 0; i < recipe.getCraftMatrix().size(); ++i) {
                int origX = i % recipe.getRecipeWidth();
                int origY = i / recipe.getRecipeWidth();
                int targetIdx = origY * 3 + origX;
                this.matrixSlots.get(targetIdx).setIngredient(recipe.getCraftMatrix().get(i));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setSortComparator(Comparator<FoodRecipeWithStatus> comparator) {
        this.currentSorting = comparator;
        Iterator<FoodRecipeWithStatus> it = this.filteredItems.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
        Collections.sort(this.filteredItems, comparator);
        this.populateRecipeSlots();
    }

    @SideOnly(value=Side.CLIENT)
    public int getItemListCount() {
        return this.filteredItems.size();
    }

    @SideOnly(value=Side.CLIENT)
    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.populateRecipeSlots();
    }

    @SideOnly(value=Side.CLIENT)
    public void search(@Nullable String term) {
        this.currentSearch = term;
        this.filteredItems.clear();
        if (term == null || term.trim().isEmpty()) {
            this.filteredItems.addAll(this.itemList);
        } else {
            for (FoodRecipeWithStatus recipe : this.itemList) {
                if (!recipe.getOutputItem().func_82833_r().toLowerCase().contains(term.toLowerCase())) continue;
                this.filteredItems.add(recipe);
            }
        }
        Collections.sort(this.filteredItems, this.currentSorting);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public FoodRecipeWithIngredients getSelection() {
        return this.selectedRecipeList != null ? this.selectedRecipeList.get(this.selectedRecipeIndex) : null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSelectedSlot(FakeSlotRecipe slot) {
        return slot == this.selectedRecipe;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isDirty() {
        return this.isDirtyClient;
    }

    @SideOnly(value=Side.CLIENT)
    public void setDirty(boolean dirty) {
        this.isDirtyClient = dirty;
    }

    @SideOnly(value=Side.CLIENT)
    public void setHasOven(boolean hasOven) {
        this.hasOven = hasOven;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasOven() {
        return this.hasOven;
    }

    @SideOnly(value=Side.CLIENT)
    public void setRecipeList(ItemStack outputItem, List<FoodRecipeWithIngredients> recipeList) {
        List<FoodRecipeWithIngredients> list = this.selectedRecipeList = recipeList.size() > 0 ? recipeList : null;
        if (this.lastOutputItem == null || this.lastOutputItem.func_77973_b() != outputItem.func_77973_b() || this.selectedRecipeList == null || this.selectedRecipeIndex >= this.selectedRecipeList.size()) {
            this.selectedRecipeIndex = 0;
        }
        this.populateMatrixSlots();
        this.lastOutputItem = outputItem;
    }

    @SideOnly(value=Side.CLIENT)
    public void nextSubRecipe(int i) {
        if (this.selectedRecipeList != null) {
            this.selectedRecipeIndex = Math.max(0, Math.min(this.selectedRecipeList.size() - 1, this.selectedRecipeIndex + i));
            this.populateMatrixSlots();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasVariants() {
        return this.selectedRecipeList != null && this.selectedRecipeList.size() > 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateSlots(float partialTicks) {
        for (FakeSlotCraftMatrix slot : this.matrixSlots) {
            slot.updateSlot(partialTicks);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getSelectionIndex() {
        return this.selectedRecipeIndex;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRecipeCount() {
        return this.selectedRecipeList != null ? this.selectedRecipeList.size() : 0;
    }

    public List<FakeSlotCraftMatrix> getCraftingMatrixSlots() {
        return this.matrixSlots;
    }
}

