/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.balyware.ItemUtils;
import net.blay09.mods.cookingforblockheads.container.FoodRecipeWithStatus;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class KitchenMultiBlock {
    private final Set<BlockPos> checkedPos = Sets.newHashSet();
    private final List<IKitchenItemProvider> itemProviderList = Lists.newArrayList();
    private final List<IKitchenSmeltingProvider> smeltingProviderList = Lists.newArrayList();
    private final List<IKitchenItemProvider> tmpSourceInventories = Lists.newArrayList();

    public KitchenMultiBlock(World world, BlockPos pos) {
        this.findNeighbourKitchenBlocks(world, pos);
    }

    private void findNeighbourKitchenBlocks(World world, BlockPos pos) {
        for (int i = 0; i <= 5; ++i) {
            IKitchenSmeltingProvider smeltingProvider;
            EnumFacing dir = EnumFacing.func_82600_a((int)i);
            BlockPos position = pos.func_177972_a(dir);
            if (this.checkedPos.contains(position)) continue;
            this.checkedPos.add(position);
            TileEntity tileEntity = world.func_175625_s(position);
            if (tileEntity == null) continue;
            IKitchenItemProvider itemProvider = (IKitchenItemProvider)tileEntity.getCapability(CapabilityKitchenItemProvider.KITCHEN_ITEM_PROVIDER_CAPABILITY, null);
            if (itemProvider != null) {
                this.itemProviderList.add(itemProvider);
            }
            if ((smeltingProvider = (IKitchenSmeltingProvider)tileEntity.getCapability(CapabilityKitchenSmeltingProvider.KITCHEN_SMELTING_PROVIDER_CAPABILITY, null)) != null) {
                this.smeltingProviderList.add(smeltingProvider);
            }
            if (itemProvider == null && smeltingProvider == null) continue;
            this.findNeighbourKitchenBlocks(world, position);
        }
    }

    public List<IKitchenItemProvider> getSourceInventories(InventoryPlayer playerInventory) {
        this.tmpSourceInventories.clear();
        this.tmpSourceInventories.add(new KitchenItemProvider((IItemHandler)new InvWrapper((IInventory)playerInventory)));
        for (IKitchenItemProvider provider : this.itemProviderList) {
            this.tmpSourceInventories.add(provider);
        }
        return this.tmpSourceInventories;
    }

    public ItemStack smeltItem(ItemStack itemStack, int count) {
        IKitchenSmeltingProvider provider;
        ItemStack restStack = itemStack.func_77946_l().func_77979_a(count);
        Iterator<IKitchenSmeltingProvider> iterator = this.smeltingProviderList.iterator();
        while (iterator.hasNext() && (restStack = (provider = iterator.next()).smeltItem(restStack)) != null) {
        }
        itemStack.field_77994_a = itemStack.field_77994_a - (count - (restStack != null ? restStack.field_77994_a : 0));
        if (itemStack.field_77994_a <= 0) {
            return null;
        }
        return itemStack;
    }

    public void trySmelt(EntityPlayer player, FoodRecipeWithStatus recipe, boolean stack) {
        for (IKitchenItemProvider itemProvider : this.getSourceInventories(player.field_71071_by)) {
            itemProvider.resetSimulation();
            for (int i = 0; i < itemProvider.getSlots(); ++i) {
                ItemStack itemStack = itemProvider.getStackInSlot(i);
                if (itemStack == null) continue;
                for (ItemStack sourceStack : recipe.getCraftMatrix().get(0).getItemStacks()) {
                    int smeltCount;
                    ItemStack restStack;
                    if (!ItemUtils.areItemStacksEqualWithWildcard(itemStack, sourceStack) || (restStack = itemProvider.useItemStack(i, smeltCount = Math.min(itemStack.field_77994_a, stack ? sourceStack.func_77976_d() : 1), false)) == null) continue;
                    if ((restStack = this.smeltItem(restStack, smeltCount)) != null && !player.field_71071_by.func_70441_a(restStack = itemProvider.returnItemStack(restStack))) {
                        player.func_71019_a(restStack, false);
                    }
                    player.field_71070_bA.func_75142_b();
                    return;
                }
            }
        }
    }

    public boolean hasSmeltingProvider() {
        return this.smeltingProviderList.size() > 0;
    }
}

