/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.balyware;

import com.google.common.base.Preconditions;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class RangedWrapper
implements IItemHandlerModifiable {
    private final IItemHandlerModifiable compose;
    private final int minSlot;
    private final int maxSlot;

    public RangedWrapper(IItemHandlerModifiable compose, int minSlot, int maxSlotExclusive) {
        Preconditions.checkArgument((maxSlotExclusive > minSlot ? 1 : 0) != 0, (Object)"Max slot must be greater than min slot");
        this.compose = compose;
        this.minSlot = minSlot;
        this.maxSlot = maxSlotExclusive;
    }

    public int getSlots() {
        return this.maxSlot - this.minSlot;
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.checkSlot(slot)) {
            return this.compose.getStackInSlot(slot + this.minSlot);
        }
        return null;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.checkSlot(slot)) {
            return this.compose.insertItem(slot + this.minSlot, stack, simulate);
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.checkSlot(slot)) {
            return this.compose.extractItem(slot + this.minSlot, amount, simulate);
        }
        return null;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.checkSlot(slot)) {
            this.compose.setStackInSlot(slot + this.minSlot, stack);
        }
    }

    private boolean checkSlot(int localSlot) {
        return localSlot + this.minSlot < this.maxSlot;
    }
}

