/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.gui;

import java.io.IOException;
import net.blay09.mods.cookingforblockheads.client.gui.GuiButtonSort;
import net.blay09.mods.cookingforblockheads.container.ContainerRecipeBook;
import net.blay09.mods.cookingforblockheads.container.comparator.ComparatorHunger;
import net.blay09.mods.cookingforblockheads.container.comparator.ComparatorName;
import net.blay09.mods.cookingforblockheads.container.comparator.ComparatorSaturation;
import net.blay09.mods.cookingforblockheads.container.slot.FakeSlotRecipe;
import net.blay09.mods.cookingforblockheads.registry.RecipeStatus;
import net.blay09.mods.cookingforblockheads.registry.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Mouse;

public class GuiRecipeBook
extends GuiContainer {
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_Y = 8;
    private static final int SCROLLBAR_WIDTH = 7;
    private static final int SCROLLBAR_HEIGHT = 77;
    private static final ResourceLocation guiTexture = new ResourceLocation("cookingforblockheads", "textures/gui/gui.png");
    private static final int VISIBLE_ROWS = 4;
    private final ContainerRecipeBook container;
    private boolean isEventHandler;
    private int scrollBarScaledHeight;
    private int scrollBarXPos;
    private int scrollBarYPos;
    private int currentOffset;
    private int mouseClickY = -1;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private GuiButton btnNextRecipe;
    private GuiButton btnPrevRecipe;
    private GuiTextField searchBar;
    private GuiButtonSort btnSortName;
    private GuiButtonSort btnSortHunger;
    private GuiButtonSort btnSortSaturation;
    private final String[] noIngredients;
    private final String[] noSelection;

    public GuiRecipeBook(ContainerRecipeBook container) {
        super((Container)container);
        this.container = container;
        this.noIngredients = I18n.func_135052_a((String)"gui.cookingforblockheads:noIngredients", (Object[])new Object[0]).split("\\\\n");
        this.noSelection = I18n.func_135052_a((String)"gui.cookingforblockheads:noSelection", (Object[])new Object[0]).split("\\\\n");
    }

    public void func_73866_w_() {
        this.field_147000_g = 174;
        super.func_73866_w_();
        this.btnPrevRecipe = new GuiButton(0, this.field_146294_l / 2 - 79, this.field_146295_m / 2 - 51, 13, 20, "<");
        this.btnPrevRecipe.field_146125_m = false;
        this.field_146292_n.add(this.btnPrevRecipe);
        this.btnNextRecipe = new GuiButton(1, this.field_146294_l / 2 - 9, this.field_146295_m / 2 - 51, 13, 20, ">");
        this.btnNextRecipe.field_146125_m = false;
        this.field_146292_n.add(this.btnNextRecipe);
        this.btnSortName = new GuiButtonSort(2, this.field_146294_l / 2 + 87, this.field_146295_m / 2 - 80, 196, "tooltip.cookingforblockheads:sortByName");
        this.field_146292_n.add(this.btnSortName);
        this.btnSortHunger = new GuiButtonSort(3, this.field_146294_l / 2 + 87, this.field_146295_m / 2 - 60, 216, "tooltip.cookingforblockheads:sortByHunger");
        this.field_146292_n.add(this.btnSortHunger);
        this.btnSortSaturation = new GuiButtonSort(4, this.field_146294_l / 2 + 87, this.field_146295_m / 2 - 40, 236, "tooltip.cookingforblockheads:sortBySaturation");
        this.field_146292_n.add(this.btnSortSaturation);
        this.searchBar = new GuiTextField(5, this.field_146289_q, this.field_147003_i + this.field_146999_f - 78, this.field_147009_r - 5, 70, 10);
        if (!this.isEventHandler) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.isEventHandler = true;
        }
        this.recalculateScrollBar();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button != this.btnPrevRecipe && button != this.btnNextRecipe) {
            if (button == this.btnSortName) {
                this.container.setSortComparator(new ComparatorName());
            } else if (button == this.btnSortHunger) {
                this.container.setSortComparator(new ComparatorHunger((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
            } else if (button == this.btnSortSaturation) {
                this.container.setSortComparator(new ComparatorSaturation((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int delta = Mouse.getEventDWheel();
        if (delta == 0) {
            return;
        }
        this.setCurrentOffset(delta > 0 ? this.currentOffset - 1 : this.currentOffset + 1);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (state != -1 && this.mouseClickY != -1) {
            this.mouseClickY = -1;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 1 && mouseX >= this.searchBar.field_146209_f && mouseX < this.searchBar.field_146209_f + this.searchBar.field_146218_h && mouseY >= this.searchBar.field_146210_g && mouseY < this.searchBar.field_146210_g + this.searchBar.field_146219_i) {
            this.searchBar.func_146180_a("");
            this.container.search(null);
            this.recalculateScrollBar();
        } else {
            this.searchBar.func_146192_a(mouseX, mouseY, button);
        }
        if (mouseX >= this.scrollBarXPos && mouseX <= this.scrollBarXPos + 7 && mouseY >= this.scrollBarYPos && mouseY <= this.scrollBarYPos + this.scrollBarScaledHeight) {
            this.mouseClickY = mouseY;
            this.indexWhenClicked = this.currentOffset;
        }
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        if (this.searchBar.func_146201_a(c, keyCode)) {
            this.container.search(this.searchBar.func_146179_b());
            this.recalculateScrollBar();
        } else {
            super.func_73869_a(c, keyCode);
        }
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        int curY;
        boolean hasRecipes;
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (this.container.isDirty()) {
            this.recalculateScrollBar();
            this.container.setDirty(false);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r - 10, 0, 0, this.field_146999_f, this.field_147000_g + 10);
        if (this.mouseClickY != -1 && (pixelsPerFilter = (float)(77 - this.scrollBarScaledHeight) / (float)Math.max(1, (int)Math.ceil((float)this.container.getRecipeCount() / 3.0f) - 4)) != 0.0f && (numberOfFiltersMoved = (int)((float)(mouseY - this.mouseClickY) / pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        this.btnSortName.field_146124_l = hasRecipes = this.container.getRecipeCount() > 0;
        this.btnSortHunger.field_146124_l = hasRecipes;
        this.btnSortSaturation.field_146124_l = hasRecipes;
        if (!this.container.hasSelection()) {
            curY = this.field_147009_r + 39 - this.noSelection.length / 2 * this.field_146289_q.field_78288_b;
            for (String s : this.noSelection) {
                this.field_146289_q.func_175063_a(s, (float)(this.field_147003_i + 23 + 27 - this.field_146289_q.func_78256_a(s) / 2), (float)curY, -1);
                curY += this.field_146289_q.field_78288_b + 5;
            }
        } else if (this.container.getSelection().getType() == RecipeType.SMELTING) {
            this.func_73729_b(this.field_147003_i + 23, this.field_147009_r + 19, 54, 184, 54, 54);
        } else {
            this.func_73729_b(this.field_147003_i + 23, this.field_147009_r + 19, 0, 184, 54, 54);
        }
        GuiContainer.func_73734_a((int)this.scrollBarXPos, (int)this.scrollBarYPos, (int)(this.scrollBarXPos + 7), (int)(this.scrollBarYPos + this.scrollBarScaledHeight), (int)-5592406);
        if (this.container.getRecipeCount() == 0) {
            GuiContainer.func_73734_a((int)(this.field_147003_i + 97), (int)(this.field_147009_r + 7), (int)(this.field_147003_i + 168), (int)(this.field_147009_r + 85), (int)-1440603614);
            curY = this.field_147009_r + 39 - this.noIngredients.length / 2 * this.field_146289_q.field_78288_b;
            for (String s : this.noIngredients) {
                this.field_146289_q.func_175063_a(s, (float)(this.field_147003_i + 97 + 36 - this.field_146289_q.func_78256_a(s) / 2), (float)curY, -1);
                curY += this.field_146289_q.field_78288_b + 5;
            }
        }
        this.searchBar.func_146194_f();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.btnSortName.func_146115_a() && this.btnSortName.field_146124_l) {
            this.func_146283_a(this.btnSortName.getTooltipLines(), mouseX, mouseY);
        } else if (this.btnSortHunger.func_146115_a() && this.btnSortHunger.field_146124_l) {
            this.func_146283_a(this.btnSortHunger.getTooltipLines(), mouseX, mouseY);
        } else if (this.btnSortSaturation.func_146115_a() && this.btnSortSaturation.field_146124_l) {
            this.func_146283_a(this.btnSortSaturation.getTooltipLines(), mouseX, mouseY);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.isEventHandler) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            this.isEventHandler = false;
        }
    }

    public void recalculateScrollBar() {
        int scrollBarTotalHeight = 76;
        this.scrollBarScaledHeight = (int)((double)scrollBarTotalHeight * Math.min(1.0, 4.0 / Math.ceil((float)this.container.getRecipeCount() / 3.0f)));
        this.scrollBarXPos = this.field_147003_i + this.field_146999_f - 7 - 9;
        this.scrollBarYPos = this.field_147009_r + 8 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentOffset / Math.max(1, (int)Math.ceil((float)this.container.getRecipeCount() / 3.0f) - 4);
    }

    public void setCurrentOffset(int currentOffset) {
        this.currentOffset = Math.max(0, Math.min(currentOffset, (int)Math.ceil((float)this.container.getRecipeCount() / 3.0f) - 4));
        this.container.setScrollOffset(this.currentOffset);
        this.recalculateScrollBar();
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        Slot hoverSlot = this.getSlotUnderMouse();
        if (hoverSlot instanceof FakeSlotRecipe && event.itemStack == hoverSlot.func_75211_c()) {
            FakeSlotRecipe slotRecipe = (FakeSlotRecipe)hoverSlot;
            if (this.container.isSelectedSlot(slotRecipe) && this.container.isAllowCrafting()) {
                if (slotRecipe.getRecipe().getType() == RecipeType.SMELTING) {
                    if (!this.container.hasOven()) {
                        event.toolTip.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"tooltip.cookingforblockheads:missingOven", (Object[])new Object[0]));
                    } else if (GuiRecipeBook.func_146272_n()) {
                        event.toolTip.add(EnumChatFormatting.GREEN + I18n.func_135052_a((String)"tooltip.cookingforblockheads:clickToSmeltStack", (Object[])new Object[0]));
                    } else {
                        event.toolTip.add(EnumChatFormatting.GREEN + I18n.func_135052_a((String)"tooltip.cookingforblockheads:clickToSmeltOne", (Object[])new Object[0]));
                    }
                } else if (slotRecipe.getRecipe().getStatus() == RecipeStatus.MISSING_TOOLS) {
                    event.toolTip.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"tooltip.cookingforblockheads:missingTools", (Object[])new Object[0]));
                } else if (slotRecipe.getRecipe().getStatus() == RecipeStatus.MISSING_INGREDIENTS) {
                    event.toolTip.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"tooltip.cookingforblockheads:missingIngredients", (Object[])new Object[0]));
                } else if (GuiRecipeBook.func_146272_n()) {
                    event.toolTip.add(EnumChatFormatting.GREEN + I18n.func_135052_a((String)"tooltip.cookingforblockheads:clickToCraftStack", (Object[])new Object[0]));
                } else {
                    event.toolTip.add(EnumChatFormatting.GREEN + I18n.func_135052_a((String)"tooltip.cookingforblockheads:clickToCraftOne", (Object[])new Object[0]));
                }
            } else {
                event.toolTip.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.cookingforblockheads:clickToSeeRecipe", (Object[])new Object[0]));
            }
        }
    }
}

