/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import net.blay09.mods.cookingforblockheads.block.BlockFridge;
import net.blay09.mods.cookingforblockheads.client.model.ModelFridgeDoor;
import net.blay09.mods.cookingforblockheads.client.model.ModelFridgeLargeDoor;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.blay09.mods.cookingforblockheads.tile.TileFridge;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.IItemHandler;

public class FridgeRenderer
extends TileEntitySpecialRenderer<TileFridge> {
    private final ModelFridgeDoor modelFridgeDoor = new ModelFridgeDoor();
    private final ModelFridgeLargeDoor modelFridgeLargeDoor = new ModelFridgeLargeDoor();
    private final ResourceLocation textureFridgeDoor = new ResourceLocation("cookingforblockheads", "textures/entity/FridgeDoor.png");
    private final ResourceLocation textureFridgeLargeDoor = new ResourceLocation("cookingforblockheads", "textures/entity/FridgeLargeDoor.png");

    public void renderTileEntityAt(TileFridge tileEntity, double x, double y, double z, float partialTicks, int destroyStage) {
        IBlockState state = tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v());
        BlockFridge.FridgeType fridgeType = (BlockFridge.FridgeType)((Object)(state = state.func_177230_c().func_176221_a(state, (IBlockAccess)tileEntity.func_145831_w(), tileEntity.func_174877_v())).func_177229_b(BlockFridge.TYPE));
        if (fridgeType == BlockFridge.FridgeType.INVISIBLE) {
            return;
        }
        GlStateManager.func_179094_E();
        EnumDyeColor fridgeColor = tileEntity.getFridgeColor();
        int color = fridgeColor.func_176768_e().field_76291_p;
        GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)RenderUtils.getFacingAngle(tileEntity), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        boolean isFlipped = (Boolean)state.func_177229_b((IProperty)BlockFridge.FLIPPED);
        float doorAngle = tileEntity.getDoorAnimator().getRenderAngle(partialTicks);
        if (fridgeType == BlockFridge.FridgeType.SMALL) {
            this.func_147499_a(this.textureFridgeDoor);
            this.modelFridgeDoor.DoorMain.field_78796_g = doorAngle;
            this.modelFridgeDoor.DoorHandle.field_78796_g = doorAngle;
            this.modelFridgeDoor.DoorMainFlipped.field_78796_g = -doorAngle;
            this.modelFridgeDoor.DoorHandleFlipped.field_78796_g = -doorAngle;
            this.modelFridgeDoor.render(isFlipped);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.modelFridgeDoor.renderNoTint(isFlipped);
        } else if (fridgeType == BlockFridge.FridgeType.LARGE) {
            this.func_147499_a(this.textureFridgeLargeDoor);
            this.modelFridgeLargeDoor.DoorMain.field_78796_g = doorAngle;
            this.modelFridgeLargeDoor.DoorHandle.field_78796_g = doorAngle;
            this.modelFridgeLargeDoor.DoorMainFlipped.field_78796_g = -doorAngle;
            this.modelFridgeLargeDoor.DoorHandleFlipped.field_78796_g = -doorAngle;
            this.modelFridgeLargeDoor.render(isFlipped);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.modelFridgeLargeDoor.renderNoTint(isFlipped);
        }
        GlStateManager.func_179121_F();
        if (doorAngle > 0.0f) {
            RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)RenderUtils.getFacingAngle(tileEntity), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
            float topY = fridgeType == BlockFridge.FridgeType.LARGE ? 3.25f : 0.35f;
            IItemHandler itemHandler = tileEntity.getCombinedItemHandler();
            for (int i = itemHandler.getSlots() - 1; i >= 0; --i) {
                float offsetZ;
                float offsetY;
                float offsetX;
                int rowIndex;
                ItemStack itemStack = itemHandler.getStackInSlot(i);
                if (itemStack == null) continue;
                if (fridgeType == BlockFridge.FridgeType.LARGE) {
                    rowIndex = i % 18;
                    offsetX = 0.7f - (float)(rowIndex % 9) * 0.175f;
                    offsetY = topY - (float)(i / 18) * 1.25f;
                    offsetZ = 0.5f - (float)(rowIndex / 9) * 0.9f;
                } else {
                    rowIndex = i % 13;
                    offsetX = 0.7f;
                    float spacing = 0.175f;
                    if (rowIndex / 9 > 0) {
                        offsetX -= 0.2f;
                        spacing *= 2.0f;
                    }
                    offsetX -= (float)(rowIndex % 9) * spacing;
                    offsetY = topY - (float)(i / 13) * 1.25f;
                    offsetZ = 0.5f - (float)(rowIndex / 9) * 0.9f;
                }
                RenderUtils.renderItem(itemRenderer, itemStack, offsetX, offsetY, offsetZ, 45.0f, 0.0f, 1.0f, 0.0f);
            }
            GlStateManager.func_179121_F();
        }
    }
}

