/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.container.FoodRecipeWithStatus;
import net.blay09.mods.cookingforblockheads.container.comparator.ComparatorName;
import net.blay09.mods.cookingforblockheads.container.inventory.InventoryCraftBook;
import net.blay09.mods.cookingforblockheads.container.slot.FakeSlot;
import net.blay09.mods.cookingforblockheads.container.slot.FakeSlotCraftMatrix;
import net.blay09.mods.cookingforblockheads.container.slot.FakeSlotRecipe;
import net.blay09.mods.cookingforblockheads.network.NetworkHandler;
import net.blay09.mods.cookingforblockheads.network.message.MessageCraftRecipe;
import net.blay09.mods.cookingforblockheads.network.message.MessageRecipeList;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.RecipeType;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodRecipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContainerRecipeBook
extends Container {
    private final EntityPlayer player;
    private final Map<Integer, FoodRecipeWithStatus> recipeMap = Maps.newHashMap();
    private final List<FoodRecipeWithStatus> sortedRecipes = Lists.newArrayList();
    private final List<FakeSlotRecipe> recipeSlots = Lists.newArrayList();
    private final List<FakeSlotCraftMatrix> matrixSlots = Lists.newArrayList();
    private final InventoryCraftBook craftBook = new InventoryCraftBook(this);
    private boolean noFilter;
    private boolean allowCrafting;
    private KitchenMultiBlock multiBlock;
    private boolean isDirty = true;
    private Comparator<FoodRecipeWithStatus> currentSorting = new ComparatorName();
    private String currentSearch;
    private int selectedRecipeId = -1;
    private int scrollOffset;
    private boolean hasOven;

    public ContainerRecipeBook(EntityPlayer player) {
        FakeSlot slot;
        int j;
        int i;
        this.player = player;
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 3; ++j) {
                slot = new FakeSlotRecipe(j + i * 3, 102 + j * 18, 11 + i * 18);
                this.recipeSlots.add((FakeSlotRecipe)slot);
                this.func_75146_a(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                slot = new FakeSlotCraftMatrix(j + i * 3, 24 + j * 18, 20 + i * 18);
                this.matrixSlots.add((FakeSlotCraftMatrix)slot);
                this.func_75146_a(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, j + i * 9 + 9, 8 + j * 18, 92 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, i, 8 + i * 18, 150));
        }
    }

    public ItemStack func_75144_a(int slotNumber, int dragType, int clickType, EntityPlayer player) {
        FakeSlotRecipe slotRecipe;
        Slot slot;
        if (slotNumber >= 0 && slotNumber < this.field_75151_b.size() && (slot = (Slot)this.field_75151_b.get(slotNumber)) instanceof FakeSlotRecipe && player.field_70170_p.field_72995_K && (slotRecipe = (FakeSlotRecipe)slot).getRecipe() != null) {
            int recipeId = slotRecipe.getRecipe().getId();
            if (recipeId == this.selectedRecipeId) {
                if (this.allowCrafting) {
                    NetworkHandler.instance.sendToServer((IMessage)new MessageCraftRecipe(recipeId, clickType == 1));
                }
            } else {
                this.selectedRecipeId = recipeId;
                this.updateMatrixSlots();
            }
        }
        return super.func_75144_a(slotNumber, dragType, clickType, player);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.player.field_70170_p.field_72995_K) {
            for (FakeSlotCraftMatrix slot : this.matrixSlots) {
                slot.updateSlot();
            }
        } else if (this.isDirty || this.player.field_71071_by.field_70459_e) {
            this.findAndSendRecipes();
            this.player.field_71071_by.field_70459_e = false;
            this.isDirty = false;
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            if (slotIndex >= 48 && slotIndex < 57 ? !this.func_75135_a(slotStack, 21, 48, true) : slotIndex >= 21 && slotIndex < 48 && !this.func_75135_a(slotStack, 48, 57, false)) {
                return null;
            }
            if (slotStack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
        }
        return itemStack;
    }

    public ContainerRecipeBook setNoFilter() {
        this.noFilter = true;
        return this;
    }

    public ContainerRecipeBook allowCrafting() {
        this.allowCrafting = true;
        return this;
    }

    public ContainerRecipeBook setKitchenMultiBlock(KitchenMultiBlock kitchenMultiBlock) {
        this.multiBlock = kitchenMultiBlock;
        return this;
    }

    public ContainerRecipeBook findAndSendRecipes() {
        this.recipeMap.clear();
        if (this.noFilter) {
            for (FoodRecipe recipe : CookingRegistry.getFoodRecipes()) {
                this.recipeMap.put(recipe.getId(), new FoodRecipeWithStatus(recipe.getId(), recipe.getOutputItem(), recipe.getCraftMatrix(), recipe.getType(), CookingRegistry.getRecipeStatus(recipe, this.player.field_71071_by, this.multiBlock)));
            }
        } else {
            for (FoodRecipeWithStatus recipe : CookingRegistry.findAvailableRecipes(this.player.field_71071_by, this.multiBlock)) {
                this.recipeMap.put(recipe.getId(), recipe);
            }
        }
        NetworkHandler.instance.sendTo((IMessage)new MessageRecipeList(this.recipeMap.values(), this.multiBlock != null && this.multiBlock.hasSmeltingProvider()), (EntityPlayerMP)this.player);
        return this;
    }

    public void tryCraft(int id, boolean stack) {
        FoodRecipeWithStatus recipe;
        if (this.allowCrafting && (recipe = this.recipeMap.get(id)) != null) {
            if (recipe.getType() == RecipeType.CRAFTING) {
                ItemStack itemStack;
                int craftCount = stack ? recipe.getOutputItem().func_77976_d() : 1;
                for (int i = 0; i < craftCount && (itemStack = this.craftBook.tryCraft(recipe, this.player, this.multiBlock)) != null; ++i) {
                    if (this.player.field_71071_by.func_70441_a(itemStack)) continue;
                    this.player.func_71019_a(itemStack, false);
                }
                this.isDirty = true;
            } else if (recipe.getType() == RecipeType.SMELTING && this.multiBlock != null && this.multiBlock.hasSmeltingProvider()) {
                this.multiBlock.trySmelt(this.player, recipe, stack);
                this.isDirty = true;
            }
        }
    }

    public void setRecipeList(Collection<FoodRecipeWithStatus> recipeList) {
        this.recipeMap.clear();
        for (FoodRecipeWithStatus recipe : recipeList) {
            this.recipeMap.put(recipe.getId(), recipe);
        }
        if (this.selectedRecipeId != -1 && !this.recipeMap.containsKey(this.selectedRecipeId)) {
            this.selectedRecipeId = -1;
            this.updateMatrixSlots();
        }
        this.search(this.currentSearch);
        Collections.sort(this.sortedRecipes, this.currentSorting);
        this.updateRecipeSlots();
        this.setDirty(true);
    }

    public void updateRecipeSlots() {
        int i = this.scrollOffset * 3;
        for (FakeSlotRecipe slot : this.recipeSlots) {
            if (i < this.sortedRecipes.size()) {
                slot.setFoodRecipe(this.sortedRecipes.get(i));
                ++i;
                continue;
            }
            slot.setFoodRecipe(null);
        }
    }

    public void updateMatrixSlots() {
        FoodRecipeWithStatus recipe;
        FoodRecipeWithStatus foodRecipeWithStatus = recipe = this.selectedRecipeId != -1 ? this.recipeMap.get(this.selectedRecipeId) : null;
        if (recipe != null && recipe.getType() == RecipeType.SMELTING) {
            for (int i = 0; i < this.matrixSlots.size(); ++i) {
                this.matrixSlots.get(i).setIngredient(i == 4 ? recipe.getCraftMatrix().get(0) : null);
            }
        } else {
            int i = 0;
            if (recipe != null && recipe.getCraftMatrix().size() == 1) {
                for (int j = 0; j < this.matrixSlots.size(); ++j) {
                    this.matrixSlots.get(j).setIngredient(j == 4 ? recipe.getCraftMatrix().get(0) : null);
                }
            } else if (recipe != null && recipe.getCraftMatrix().size() == 3) {
                for (int j = 0; j < this.matrixSlots.size(); ++j) {
                    if (j >= 3 && j <= 5) {
                        this.matrixSlots.get(j).setIngredient(recipe.getCraftMatrix().get(j - 3));
                        continue;
                    }
                    this.matrixSlots.get(j).setIngredient(null);
                }
            } else {
                for (FakeSlotCraftMatrix slot : this.matrixSlots) {
                    if (recipe != null && i < recipe.getCraftMatrix().size()) {
                        slot.setIngredient(recipe.getCraftMatrix().get(i));
                        ++i;
                        continue;
                    }
                    slot.setIngredient(null);
                }
            }
        }
    }

    public void setSortComparator(Comparator<FoodRecipeWithStatus> comparator) {
        this.currentSorting = comparator;
        Collections.sort(this.sortedRecipes, comparator);
        this.updateRecipeSlots();
    }

    public int getRecipeCount() {
        return this.sortedRecipes.size();
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.updateRecipeSlots();
    }

    public void search(String term) {
        this.currentSearch = term;
        this.sortedRecipes.clear();
        if (term == null || term.trim().isEmpty()) {
            this.sortedRecipes.addAll(this.recipeMap.values());
        } else {
            for (FoodRecipeWithStatus recipe : this.recipeMap.values()) {
                if (!recipe.getOutputItem().func_82833_r().toLowerCase().contains(term.toLowerCase())) continue;
                this.sortedRecipes.add(recipe);
            }
        }
        Collections.sort(this.sortedRecipes, this.currentSorting);
        this.updateRecipeSlots();
    }

    public boolean hasSelection() {
        return this.selectedRecipeId != -1 && this.recipeMap.containsKey(this.selectedRecipeId);
    }

    public FoodRecipeWithStatus getSelection() {
        return this.selectedRecipeId != -1 ? this.recipeMap.get(this.selectedRecipeId) : null;
    }

    public boolean isSelectedSlot(FakeSlotRecipe slot) {
        return slot.getRecipe().getId() == this.selectedRecipeId;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public boolean isAllowCrafting() {
        return this.allowCrafting;
    }

    public void setHasOven(boolean hasOven) {
        this.hasOven = hasOven;
    }

    public boolean hasOven() {
        return this.hasOven;
    }
}

