/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.container;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.cookingforblockheads.registry.RecipeStatus;
import net.blay09.mods.cookingforblockheads.registry.RecipeType;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodIngredient;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class FoodRecipeWithStatus {
    private final int id;
    private final List<FoodIngredient> craftMatrix;
    private final ItemStack outputItem;
    private final RecipeType type;
    private final RecipeStatus status;

    public FoodRecipeWithStatus(int id, ItemStack outputItem, List<FoodIngredient> craftMatrix, RecipeType type, RecipeStatus status) {
        this.id = id;
        this.outputItem = outputItem;
        this.craftMatrix = craftMatrix;
        this.type = type;
        this.status = status;
    }

    public int getId() {
        return this.id;
    }

    public List<FoodIngredient> getCraftMatrix() {
        return this.craftMatrix;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public RecipeType getType() {
        return this.type;
    }

    public RecipeStatus getStatus() {
        return this.status;
    }

    public static FoodRecipeWithStatus read(ByteBuf buf) {
        int id = buf.readInt();
        ItemStack outputItem = ByteBufUtils.readItemStack((ByteBuf)buf);
        int ingredientCount = buf.readByte();
        ArrayList craftMatrix = Lists.newArrayListWithCapacity((int)ingredientCount);
        for (int i = 0; i < ingredientCount; ++i) {
            int stackCount = buf.readShort();
            ItemStack[] itemStacks = new ItemStack[stackCount];
            for (int j = 0; j < stackCount; ++j) {
                itemStacks[j] = ByteBufUtils.readItemStack((ByteBuf)buf);
            }
            boolean isToolItem = buf.readBoolean();
            craftMatrix.add(new FoodIngredient(itemStacks, isToolItem));
        }
        RecipeType type = RecipeType.fromId(buf.readByte());
        RecipeStatus status = RecipeStatus.fromId(buf.readByte());
        return new FoodRecipeWithStatus(id, outputItem, craftMatrix, type, status);
    }

    public void write(ByteBuf buf) {
        buf.writeInt(this.id);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.outputItem);
        buf.writeByte(this.craftMatrix.size());
        for (FoodIngredient ingredient : this.craftMatrix) {
            buf.writeShort(ingredient.getItemStacks().length);
            for (ItemStack ingredientStack : ingredient.getItemStacks()) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)ingredientStack);
            }
            buf.writeBoolean(ingredient.isToolItem());
        }
        buf.writeByte(this.type.ordinal());
        buf.writeByte(this.status.ordinal());
    }
}

