/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.container.inventory;

import java.util.Collections;
import java.util.List;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.container.FoodRecipeWithStatus;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodIngredient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class InventoryCraftBook
extends InventoryCrafting {
    public InventoryCraftBook(Container container) {
        super(container, 3, 3);
    }

    public ItemStack tryCraft(FoodRecipeWithStatus recipe, EntityPlayer player, KitchenMultiBlock multiBlock) {
        int i;
        int[] sourceInventories = new int[9];
        int[] sourceInventorySlots = new int[9];
        List<IKitchenItemProvider> inventories = multiBlock != null ? multiBlock.getSourceInventories(player.field_71071_by) : Collections.singletonList(new KitchenItemProvider((IItemHandler)new InvWrapper((IInventory)player.field_71071_by)));
        for (IKitchenItemProvider itemProvider : inventories) {
            itemProvider.resetSimulation();
        }
        List<FoodIngredient> craftMatrix = recipe.getCraftMatrix();
        for (i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, null);
            sourceInventories[i] = -1;
            sourceInventorySlots[i] = -1;
        }
        block2: for (i = 0; i < craftMatrix.size(); ++i) {
            FoodIngredient ingredient = craftMatrix.get(i);
            if (ingredient == null) continue;
            for (int j = 0; j < inventories.size(); ++j) {
                IKitchenItemProvider itemProvider = inventories.get(j);
                for (int k = 0; k < itemProvider.getSlots(); ++k) {
                    ItemStack itemStack = itemProvider.getStackInSlot(k);
                    if (itemStack == null || !ingredient.isValidItem(itemStack) || (itemStack = itemProvider.useItemStack(k, 1, true)) == null) continue;
                    this.func_70299_a(i, itemStack);
                    sourceInventories[i] = j;
                    sourceInventorySlots[i] = k;
                    continue block2;
                }
            }
        }
        IRecipe craftRecipe = CookingRegistry.findFoodRecipe(this, player.field_70170_p);
        if (craftRecipe == null) {
            return null;
        }
        ItemStack result = craftRecipe.func_77572_b((InventoryCrafting)this);
        if (result != null) {
            FMLCommonHandler.instance().firePlayerCraftingEvent(player, result, (IInventory)this);
            result.func_77980_a(player.field_70170_p, player, 1);
            if (result.func_77973_b() == Items.field_151025_P) {
                player.func_71064_a((StatBase)AchievementList.field_76014_m, 1);
            } else if (result.func_77973_b() == Items.field_151105_aU) {
                player.func_71064_a((StatBase)AchievementList.field_76011_n, 1);
            }
            for (int i2 = 0; i2 < this.func_70302_i_(); ++i2) {
                ItemStack restStack;
                ItemStack itemStack = this.func_70301_a(i2);
                if (itemStack == null || sourceInventories[i2] == -1) continue;
                ItemStack containerItem = ForgeHooks.getContainerItem((ItemStack)itemStack);
                IKitchenItemProvider sourceProvider = inventories.get(sourceInventories[i2]);
                if (sourceInventorySlots[i2] != -1) {
                    sourceProvider.resetSimulation();
                    sourceProvider.useItemStack(sourceInventorySlots[i2], 1, false);
                }
                if (containerItem == null || (restStack = sourceProvider.returnItemStack(containerItem)) == null || restStack.field_77994_a <= 0) continue;
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)restStack);
            }
        }
        return result;
    }
}

