/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.addon.HarvestCraftAddon;
import net.blay09.mods.cookingforblockheads.api.SinkHandler;
import net.blay09.mods.cookingforblockheads.api.ToastHandler;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.event.FoodRegistryInitEvent;
import net.blay09.mods.cookingforblockheads.balyware.ItemUtils;
import net.blay09.mods.cookingforblockheads.container.FoodRecipeWithStatus;
import net.blay09.mods.cookingforblockheads.container.inventory.InventoryCraftBook;
import net.blay09.mods.cookingforblockheads.registry.RecipeStatus;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodIngredient;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodRecipe;
import net.blay09.mods.cookingforblockheads.registry.recipe.ShapedCraftingFood;
import net.blay09.mods.cookingforblockheads.registry.recipe.ShapedOreCraftingFood;
import net.blay09.mods.cookingforblockheads.registry.recipe.ShapelessCraftingFood;
import net.blay09.mods.cookingforblockheads.registry.recipe.ShapelessOreCraftingFood;
import net.blay09.mods.cookingforblockheads.registry.recipe.SmeltingFood;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CookingRegistry {
    private static final AtomicInteger id = new AtomicInteger();
    private static final List<IRecipe> recipeList = Lists.newArrayList();
    private static final ArrayListMultimap<Item, FoodRecipe> foodItems = ArrayListMultimap.create();
    private static final List<ItemStack> tools = Lists.newArrayList();
    private static final Map<ItemStack, Integer> ovenFuelItems = Maps.newHashMap();
    private static final Map<ItemStack, ItemStack> ovenRecipes = Maps.newHashMap();
    private static final Map<ItemStack, SinkHandler> sinkHandlers = Maps.newHashMap();
    private static final Map<ItemStack, ToastHandler> toastHandlers = Maps.newHashMap();

    public static void initFoodRegistry() {
        recipeList.clear();
        foodItems.clear();
        id.set(0);
        FoodRegistryInitEvent init = new FoodRegistryInitEvent();
        MinecraftForge.EVENT_BUS.post((Event)init);
        Collection<ItemStack> nonFoodRecipes = init.getNonFoodRecipes();
        block0: for (Object e : CraftingManager.func_77594_a().func_77592_b()) {
            IRecipe recipe = (IRecipe)e;
            ItemStack output = recipe.func_77571_b();
            if (output == null) continue;
            if (output.func_77973_b() instanceof ItemFood) {
                if (HarvestCraftAddon.isWeirdBrokenRecipe(recipe)) continue;
                CookingRegistry.addFoodRecipe(recipe);
                continue;
            }
            for (ItemStack itemStack : nonFoodRecipes) {
                if (!ItemUtils.areItemStacksEqualWithWildcard(recipe.func_77571_b(), itemStack)) continue;
                CookingRegistry.addFoodRecipe(recipe);
                continue block0;
            }
        }
        block2: for (Object object : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            Map.Entry entry = (Map.Entry)object;
            ItemStack sourceStack = null;
            if (entry.getKey() instanceof Item) {
                sourceStack = new ItemStack((Item)entry.getKey());
            } else if (entry.getKey() instanceof Block) {
                sourceStack = new ItemStack((Block)entry.getKey());
            } else if (entry.getKey() instanceof ItemStack) {
                sourceStack = (ItemStack)entry.getKey();
            }
            ItemStack resultStack = (ItemStack)entry.getValue();
            if (resultStack.func_77973_b() instanceof ItemFood) {
                foodItems.put((Object)resultStack.func_77973_b(), (Object)new SmeltingFood(id.incrementAndGet(), resultStack, sourceStack));
                continue;
            }
            for (ItemStack itemStack : nonFoodRecipes) {
                if (!ItemUtils.areItemStacksEqualWithWildcard(resultStack, itemStack)) continue;
                foodItems.put((Object)resultStack.func_77973_b(), (Object)new SmeltingFood(id.incrementAndGet(), resultStack, sourceStack));
                continue block2;
            }
        }
    }

    public static void addFoodRecipe(IRecipe recipe) {
        ItemStack output = recipe.func_77571_b();
        if (output != null) {
            recipeList.add(recipe);
            if (recipe instanceof ShapedRecipes) {
                foodItems.put((Object)output.func_77973_b(), (Object)new ShapedCraftingFood(id.incrementAndGet(), (ShapedRecipes)recipe));
            } else if (recipe instanceof ShapelessRecipes) {
                foodItems.put((Object)output.func_77973_b(), (Object)new ShapelessCraftingFood(id.incrementAndGet(), (ShapelessRecipes)recipe));
            } else if (recipe instanceof ShapelessOreRecipe) {
                foodItems.put((Object)output.func_77973_b(), (Object)new ShapelessOreCraftingFood(id.incrementAndGet(), (ShapelessOreRecipe)recipe));
            } else if (recipe instanceof ShapedOreRecipe) {
                foodItems.put((Object)output.func_77973_b(), (Object)new ShapedOreCraftingFood(id.incrementAndGet(), (ShapedOreRecipe)recipe));
            }
        }
    }

    public static Collection<FoodRecipe> getFoodRecipes() {
        return foodItems.values();
    }

    public static void addToolItem(ItemStack toolItem) {
        tools.add(toolItem);
    }

    public static boolean isToolItem(ItemStack itemStack) {
        for (ItemStack toolItem : tools) {
            if (!ItemUtils.areItemStacksEqualWithWildcard(toolItem, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static void addOvenFuel(ItemStack itemStack, int fuelTime) {
        ovenFuelItems.put(itemStack, fuelTime);
    }

    public static int getOvenFuelTime(ItemStack itemStack) {
        for (Map.Entry<ItemStack, Integer> entry : ovenFuelItems.entrySet()) {
            if (!ItemUtils.areItemStacksEqualWithWildcard(entry.getKey(), itemStack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    public static void addSmeltingItem(ItemStack source, ItemStack result) {
        ovenRecipes.put(source, result);
    }

    public static ItemStack getSmeltingResult(ItemStack itemStack) {
        for (Map.Entry<ItemStack, ItemStack> entry : ovenRecipes.entrySet()) {
            if (!ItemUtils.areItemStacksEqualWithWildcard(entry.getKey(), itemStack)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void addToastHandler(ItemStack itemStack, ToastHandler toastHandler) {
        toastHandlers.put(itemStack, toastHandler);
    }

    public static ItemStack getToastOutput(ItemStack itemStack) {
        for (Map.Entry<ItemStack, ToastHandler> entry : toastHandlers.entrySet()) {
            if (!ItemUtils.areItemStacksEqualWithWildcard(entry.getKey(), itemStack)) continue;
            return entry.getValue().getToasterOutput(itemStack);
        }
        return null;
    }

    public static void addSinkHandler(ItemStack itemStack, SinkHandler sinkHandler) {
        sinkHandlers.put(itemStack, sinkHandler);
    }

    public static ItemStack getSinkOutput(ItemStack itemStack) {
        for (Map.Entry<ItemStack, SinkHandler> entry : sinkHandlers.entrySet()) {
            if (!ItemUtils.areItemStacksEqualWithWildcard(entry.getKey(), itemStack)) continue;
            return entry.getValue().getSinkOutput(itemStack);
        }
        return null;
    }

    public static Collection<FoodRecipeWithStatus> findAvailableRecipes(InventoryPlayer inventory, KitchenMultiBlock multiBlock) {
        ArrayList result = Lists.newArrayList();
        for (FoodRecipe recipe : CookingRegistry.getFoodRecipes()) {
            RecipeStatus recipeStatus = CookingRegistry.getRecipeStatus(recipe, inventory, multiBlock);
            if (recipeStatus == RecipeStatus.MISSING_INGREDIENTS) continue;
            result.add(new FoodRecipeWithStatus(recipe.getId(), recipe.getOutputItem(), recipe.getCraftMatrix(), recipe.getType(), recipeStatus));
        }
        return result;
    }

    public static RecipeStatus getRecipeStatus(FoodRecipe recipe, InventoryPlayer inventory, KitchenMultiBlock multiBlock) {
        List<IKitchenItemProvider> inventories = multiBlock != null ? multiBlock.getSourceInventories(inventory) : Collections.singletonList(new KitchenItemProvider((IItemHandler)new InvWrapper((IInventory)inventory)));
        for (IKitchenItemProvider itemProvider : inventories) {
            itemProvider.resetSimulation();
        }
        List<FoodIngredient> craftMatrix = recipe.getCraftMatrix();
        boolean[] itemFound = new boolean[craftMatrix.size()];
        block1: for (int i = 0; i < craftMatrix.size(); ++i) {
            FoodIngredient ingredient = craftMatrix.get(i);
            if (ingredient == null) {
                itemFound[i] = true;
                continue;
            }
            for (IKitchenItemProvider itemProvider : inventories) {
                for (int j = 0; j < itemProvider.getSlots(); ++j) {
                    ItemStack itemStack = itemProvider.getStackInSlot(j);
                    if (itemStack == null || !ingredient.isValidItem(itemStack) || itemProvider.useItemStack(j, 1, true) == null) continue;
                    itemFound[i] = true;
                    continue block1;
                }
            }
        }
        boolean missingTools = false;
        for (int i = 0; i < itemFound.length; ++i) {
            if (itemFound[i]) continue;
            if (craftMatrix.get(i).isToolItem()) {
                missingTools = true;
                continue;
            }
            return RecipeStatus.MISSING_INGREDIENTS;
        }
        return missingTools ? RecipeStatus.MISSING_TOOLS : RecipeStatus.AVAILABLE;
    }

    public static IRecipe findFoodRecipe(InventoryCraftBook craftMatrix, World world) {
        for (IRecipe recipe : recipeList) {
            if (!recipe.func_77569_a((InventoryCrafting)craftMatrix, world)) continue;
            return recipe;
        }
        return null;
    }
}

