/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.network.VanillaPacketHandler;
import net.blay09.mods.cookingforblockheads.tile.DoorAnimator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TileFridge
extends TileEntity
implements ITickable {
    private final ItemStackHandler itemHandler = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            TileFridge.this.isDirty = true;
            TileFridge.this.func_70296_d();
        }
    };
    private final KitchenItemProvider itemProvider = new KitchenItemProvider((IItemHandler)this.itemHandler);
    private final DoorAnimator doorAnimator = new DoorAnimator(this, 1, 2);
    private EnumDyeColor fridgeColor = EnumDyeColor.WHITE;
    private boolean isDirty;

    public TileFridge() {
        this.doorAnimator.setOpenRadius(2.0f);
    }

    public void setFridgeColor(EnumDyeColor fridgeColor) {
        this.fridgeColor = fridgeColor;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), state, state, 3);
        this.func_70296_d();
    }

    public void func_73660_a() {
        this.doorAnimator.update();
        if (this.isDirty) {
            VanillaPacketHandler.sendTileEntityUpdate(this);
            this.isDirty = false;
        }
    }

    public boolean func_145842_c(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.func_145842_c(id, type);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
        this.fridgeColor = EnumDyeColor.func_176766_a((int)tagCompound.func_74771_c("FridgeColor"));
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74782_a("ItemHandler", (NBTBase)this.itemHandler.serializeNBT());
        tagCompound.func_74774_a("FridgeColor", (byte)this.fridgeColor.func_176767_b());
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
        this.doorAnimator.setForcedOpen(pkt.func_148857_g().func_74767_n("IsForcedOpen"));
        this.doorAnimator.setNumPlayersUsing(pkt.func_148857_g().func_74771_c("NumPlayersUsing"));
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        tagCompound.func_74757_a("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tagCompound.func_74774_a("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
        return new S35PacketUpdateTileEntity(this.field_174879_c, 0, tagCompound);
    }

    public TileFridge findNeighbourFridge() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c() == ModBlocks.fridge) {
            return (TileFridge)this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == ModBlocks.fridge) {
            return (TileFridge)this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        }
        return null;
    }

    public TileFridge getBaseFridge() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == ModBlocks.fridge) {
            return (TileFridge)this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        }
        return this;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityKitchenItemProvider.KITCHEN_ITEM_PROVIDER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.getCombinedItemHandler();
        }
        if (capability == CapabilityKitchenItemProvider.KITCHEN_ITEM_PROVIDER_CAPABILITY) {
            return (T)this.itemProvider;
        }
        return (T)super.getCapability(capability, facing);
    }

    public EnumDyeColor getFridgeColor() {
        return this.fridgeColor;
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public IItemHandler getCombinedItemHandler() {
        TileFridge baseFridge = this.getBaseFridge();
        TileFridge neighbourFridge = baseFridge == this ? this.findNeighbourFridge() : this;
        if (neighbourFridge != null) {
            return new CombinedInvWrapper(new IItemHandlerModifiable[]{neighbourFridge.itemHandler, baseFridge.itemHandler});
        }
        return this.itemHandler;
    }
}

