/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import net.blay09.mods.cookingforblockheads.CookingConfig;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.balyware.RangedWrapper;
import net.blay09.mods.cookingforblockheads.network.VanillaPacketHandler;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.DoorAnimator;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public class TileOven
extends TileEntity
implements ITickable,
IKitchenSmeltingProvider {
    private static final int COOK_TIME = 200;
    private final ItemStackHandler itemHandler = new ItemStackHandler(20){

        protected void onContentsChanged(int slot) {
            if (slot >= 7 && slot < 16) {
                TileOven.this.slotCookTime[slot - 7] = 0;
            }
            TileOven.this.isDirty = true;
            TileOven.this.func_70296_d();
        }
    };
    private final RangedWrapper itemHandlerInput = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 0, 3);
    private final RangedWrapper itemHandlerFuel = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 3, 4);
    private final RangedWrapper itemHandlerOutput = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 4, 7);
    private final RangedWrapper itemHandlerProcessing = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 7, 16);
    private final RangedWrapper itemHandlerTools = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 16, 20);
    private final KitchenItemProvider itemProvider = new KitchenItemProvider((IItemHandler)this.itemHandlerOutput);
    private final DoorAnimator doorAnimator = new DoorAnimator(this, 1, 2);
    public int[] slotCookTime = new int[9];
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    private boolean isDirty;

    public boolean func_145842_c(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.func_145842_c(id, type);
    }

    public void func_73660_a() {
        this.doorAnimator.update();
        if (this.isDirty) {
            VanillaPacketHandler.sendTileEntityUpdate(this);
            this.isDirty = false;
        }
        boolean hasChanged = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemStack;
            if (this.furnaceBurnTime == 0 && this.shouldConsumeFuel()) {
                for (int i = 0; i < this.itemHandlerFuel.getSlots(); ++i) {
                    ItemStack fuelItem = this.itemHandlerFuel.getStackInSlot(i);
                    if (fuelItem == null) continue;
                    this.currentItemBurnTime = this.furnaceBurnTime = (int)Math.max(1.0f, (float)TileOven.getItemBurnTime(fuelItem) * CookingConfig.ovenFuelTimeMultiplier);
                    if (this.furnaceBurnTime == 0) break;
                    --fuelItem.field_77994_a;
                    if (fuelItem.field_77994_a == 0) {
                        this.itemHandlerFuel.setStackInSlot(i, fuelItem.func_77973_b().getContainerItem(fuelItem));
                    }
                    hasChanged = true;
                    break;
                }
            }
            int firstEmptySlot = -1;
            int firstTransferSlot = -1;
            for (int i = 0; i < this.itemHandlerProcessing.getSlots(); ++i) {
                itemStack = this.itemHandlerProcessing.getStackInSlot(i);
                if (itemStack != null) {
                    if (this.slotCookTime[i] != -1) {
                        ItemStack resultStack;
                        if (this.furnaceBurnTime > 0) {
                            int n = i;
                            this.slotCookTime[n] = this.slotCookTime[n] + 1;
                        }
                        if (!((float)this.slotCookTime[i] >= 200.0f * CookingConfig.ovenCookTimeMultiplier) || (resultStack = TileOven.getSmeltingResult(itemStack)) == null) continue;
                        this.itemHandlerProcessing.setStackInSlot(i, resultStack.func_77946_l());
                        this.slotCookTime[i] = -1;
                        if (firstTransferSlot != -1) continue;
                        firstTransferSlot = i;
                        continue;
                    }
                    if (firstTransferSlot != -1) continue;
                    firstTransferSlot = i;
                    continue;
                }
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
            }
            if (firstTransferSlot != -1) {
                ItemStack transferStack = this.itemHandlerProcessing.getStackInSlot(firstTransferSlot);
                transferStack = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandlerOutput, (ItemStack)transferStack, (boolean)false);
                this.itemHandlerProcessing.setStackInSlot(firstTransferSlot, transferStack);
                if (transferStack == null) {
                    this.slotCookTime[firstTransferSlot] = 0;
                }
                hasChanged = true;
            }
            if (firstEmptySlot != -1) {
                for (int j = 0; j < this.itemHandlerInput.getSlots(); ++j) {
                    itemStack = this.itemHandlerInput.getStackInSlot(j);
                    if (itemStack == null) continue;
                    this.itemHandlerProcessing.setStackInSlot(firstEmptySlot, itemStack.func_77979_a(1));
                    if (itemStack.field_77994_a > 0) break;
                    this.itemHandlerInput.setStackInSlot(j, null);
                    break;
                }
            }
        }
        if (hasChanged) {
            this.func_70296_d();
        }
    }

    public static ItemStack getSmeltingResult(ItemStack itemStack) {
        ItemStack result = CookingRegistry.getSmeltingResult(itemStack);
        if (result != null) {
            return result;
        }
        return FurnaceRecipes.func_77602_a().func_151395_a(itemStack);
    }

    public static boolean isItemFuel(ItemStack itemStack) {
        return TileOven.getItemBurnTime(itemStack) > 0;
    }

    public static int getItemBurnTime(ItemStack fuelItem) {
        int fuelTime = CookingRegistry.getOvenFuelTime(fuelItem);
        if (fuelTime != 0 || CookingConfig.ovenRequiresCookingOil) {
            return fuelTime;
        }
        return TileEntityFurnace.func_145952_a((ItemStack)fuelItem);
    }

    private boolean shouldConsumeFuel() {
        for (int i = 0; i < this.itemHandlerProcessing.getSlots(); ++i) {
            ItemStack cookingStack = this.itemHandlerProcessing.getStackInSlot(i);
            if (cookingStack == null || this.slotCookTime[i] == -1) continue;
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
        this.furnaceBurnTime = tagCompound.func_74765_d("BurnTime");
        this.currentItemBurnTime = tagCompound.func_74765_d("CurrentItemBurnTime");
        this.slotCookTime = tagCompound.func_74759_k("CookTimes");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74782_a("ItemHandler", (NBTBase)this.itemHandler.serializeNBT());
        tagCompound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        tagCompound.func_74777_a("CurrentItemBurnTime", (short)this.currentItemBurnTime);
        tagCompound.func_74783_a("CookTimes", ArrayUtils.clone((int[])this.slotCookTime));
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        tagCompound.func_74757_a("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tagCompound.func_74774_a("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
        return new S35PacketUpdateTileEntity(this.field_174879_c, 0, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
        this.doorAnimator.setForcedOpen(pkt.func_148857_g().func_74767_n("IsForcedOpen"));
        this.doorAnimator.setNumPlayersUsing(pkt.func_148857_g().func_74771_c("NumPlayersUsing"));
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public float getBurnTimeProgress() {
        return (float)this.furnaceBurnTime / (float)this.currentItemBurnTime;
    }

    public float getCookProgress(int i) {
        return (float)this.slotCookTime[i] / (200.0f * CookingConfig.ovenCookTimeMultiplier);
    }

    @Override
    public ItemStack smeltItem(ItemStack itemStack) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandlerInput, (ItemStack)itemStack, (boolean)false);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public ItemStack getToolItem(int i) {
        return this.itemHandlerTools.getStackInSlot(i);
    }

    public void setToolItem(int i, ItemStack itemStack) {
        this.itemHandlerTools.setStackInSlot(i, itemStack);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityKitchenSmeltingProvider.KITCHEN_SMELTING_PROVIDER_CAPABILITY || capability == CapabilityKitchenItemProvider.KITCHEN_ITEM_PROVIDER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)this.itemHandler;
            }
            switch (facing) {
                case UP: {
                    return (T)this.itemHandlerInput;
                }
                case DOWN: {
                    return (T)this.itemHandlerOutput;
                }
            }
            return (T)this.itemHandlerFuel;
        }
        if (capability == CapabilityKitchenItemProvider.KITCHEN_ITEM_PROVIDER_CAPABILITY) {
            return (T)this.itemProvider;
        }
        if (capability == CapabilityKitchenSmeltingProvider.KITCHEN_SMELTING_PROVIDER_CAPABILITY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    public IItemHandler getInputHandler() {
        return this.itemHandlerInput;
    }
}

