/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.cookingforblockheads.CookingConfig;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileSink
extends TileEntity
implements IFluidHandler {
    private final FluidTank waterTank = new WaterTank(16000);
    private final SinkItemProvider itemProvider = new SinkItemProvider(this.waterTank);

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_174879_c, 0, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.waterTank.writeToNBT(tagCompound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.waterTank.readFromNBT(tagCompound);
    }

    public int getWaterAmount() {
        return this.waterTank.getFluidAmount();
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return this.waterTank.fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.waterTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return CookingConfig.sinkRequiresWater && fluid == FluidRegistry.WATER;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return CookingConfig.sinkRequiresWater && fluid == FluidRegistry.WATER;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.waterTank.getInfo()};
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityKitchenItemProvider.KITCHEN_ITEM_PROVIDER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityKitchenItemProvider.KITCHEN_ITEM_PROVIDER_CAPABILITY) {
            return (T)this.itemProvider;
        }
        return (T)super.getCapability(capability, facing);
    }

    private static class SinkItemProvider
    implements IKitchenItemProvider {
        private final List<ItemStack> itemStacks = Lists.newArrayList();
        private final FluidTank fluidTank;
        private int waterUsed;

        public SinkItemProvider(FluidTank fluidTank) {
            this.fluidTank = fluidTank;
            this.itemStacks.add(new ItemStack(Items.field_151131_as));
            Item pamsWaterItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("harvestcraft", "freshwaterItem"));
            if (pamsWaterItem != null) {
                this.itemStacks.add(new ItemStack(pamsWaterItem));
            }
        }

        @Override
        public void resetSimulation() {
            this.waterUsed = 0;
        }

        @Override
        public ItemStack useItemStack(int slot, int amount, boolean simulate) {
            if (this.fluidTank.getFluidAmount() - this.waterUsed > amount * 1000) {
                if (simulate) {
                    this.waterUsed += amount * 1000;
                } else {
                    this.fluidTank.drain(amount * 1000, true);
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)this.getStackInSlot(slot), (int)amount);
            }
            return null;
        }

        @Override
        public ItemStack returnItemStack(ItemStack itemStack) {
            for (ItemStack providedStack : this.itemStacks) {
                if (!ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)itemStack, (ItemStack)providedStack)) continue;
                this.fluidTank.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
                break;
            }
            return null;
        }

        @Override
        public int getSlots() {
            return this.itemStacks.size();
        }

        @Override
        public ItemStack getStackInSlot(int slot) {
            return this.itemStacks.get(slot);
        }
    }

    private static class WaterTank
    extends FluidTank {
        public WaterTank(int capacity) {
            super(capacity);
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource.getFluid() != FluidRegistry.WATER) {
                return 0;
            }
            return super.fill(resource, doFill);
        }
    }
}

