/*
 * Decompiled with CFR 0.152.
 */
package com.plop.cubeplus;

import com.plop.cubeplus.common.item.cpItems;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cubeplus")
public class CubePlus {
    public static final String MOD_ID = "cubeplus";
    private static final Logger LOGGER = LogManager.getLogger();

    public CubePlus() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)cpItems.INSTANCE);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM PREINIT");
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        LOGGER.info("Got game settings {}", (Object)((Minecraft)event.getMinecraftSupplier().get()).field_71474_y);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MOD_ID, (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    public static void log(String text) {
        String szPath = "debug.txt";
        text = text + "\n";
        File pFile = new File(szPath);
        try {
            if (pFile.exists() || pFile.createNewFile()) {
                byte[] byData = Files.readAllBytes(Paths.get(szPath, new String[0]));
                byte[] byFinal = new byte[byData.length + text.getBytes().length];
                System.arraycopy(byData, 0, byFinal, 0, byData.length);
                System.arraycopy(text.getBytes(), 0, byFinal, byData.length, text.getBytes().length);
                Files.write(Paths.get(szPath, new String[0]), byFinal, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.info(text);
    }
}

