/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding;

import net.minecraftforge.common.config.Config;

@Config(modid="effortlessbuilding", name="EffortlessBuilding", type=Config.Type.INSTANCE, category="")
public class BuildConfig {
    public static Reach reach = new Reach();
    public static SurvivalBalancers survivalBalancers = new SurvivalBalancers();
    public static Visuals visuals = new Visuals();

    public static class Visuals {
        @Config.Comment(value={"Show a block preview if you have a block in hand on build mode NORMAL"})
        public boolean alwaysShowBlockPreview = false;
        @Config.Comment(value={"How long the dissolve effect takes when placing blocks.", "Default between 30 and 60 ticks, you can multiply that here.", "Recommended values:", "Snappy: 0.7", "Relaxing: 1.5"})
        public double dissolveTimeMultiplier = 1.0;
        @Config.Comment(value={"Switch to using the simple performance shader when placing more than this many blocks."})
        public int shaderTreshold = 1500;
        @Config.Comment(value={"Use fancy shaders while placing blocks"})
        public boolean useShaders = true;
    }

    public static class SurvivalBalancers {
        @Config.Comment(value={"Allows a survival player to break blocks that are far away, in addition to placing blocks.", "Note: this allows insta-breaking of blocks in survival."})
        public boolean breakFar = false;
        @Config.Comment(value={"Increases the time to mine a block when breaking multiple at once.", "Mining time depends on how many blocks, what type of blocks, and the percentage below.", "Example: breaking 1 dirt + 1 obsidian takes the time of breaking 1 dirt + 1 obsidian."})
        public boolean increasedMiningTime = true;
        @Config.Comment(value={"How much the mining time of each additional block counts towards an increased mining time.", "A percentage between 0% and 100%, where 0% is the same as disabling it,", "and 100% takes as much time as breaking each block individually.", "The block in front of you always counts as 100%."})
        @Config.RangeInt(min=0, max=200)
        public int miningTimePercentage = 50;
        @Config.Comment(value={"Determines what blocks can be replaced in survival.", "-1: only blocks that can be harvested by hand (default)", "0: blocks that can be harvested with wooden or gold tools", "1: blocks that can be harvested with stone tools", "2: blocks that can be harvested with iron tools", "3: blocks that can be harvested with diamond tools"})
        @Config.RangeInt(min=-1, max=3)
        public int quickReplaceMiningLevel = -1;
        @Config.Comment(value={"How many placements are remembered for the undo functionality."})
        @Config.RequiresMcRestart
        public int undoStackSize = 10;
    }

    public static class Reach {
        @Config.Comment(value={"Reach: how far away the player can place blocks using mirror/array etc.", "Enable the crafting of reach upgrades to increase reach.", "If disabled, reach is set to level 3 for survival players."})
        public boolean enableReachUpgrades = true;
        @Config.Comment(value={"Maximum reach in creative", "Keep in mind that chunks need to be loaded to be able to place blocks inside."})
        public int maxReachCreative = 200;
        @Config.Comment(value={"Maximum reach in survival without upgrades", "Reach upgrades are craftable consumables that permanently increase reach.", "Set to 0 to disable Effortless Building until the player has consumed a reach upgrade."})
        public int maxReachLevel0 = 20;
        @Config.Comment(value={"Maximum reach in survival with one upgrade"})
        public int maxReachLevel1 = 50;
        @Config.Comment(value={"Maximum reach in survival with two upgrades"})
        public int maxReachLevel2 = 100;
        @Config.Comment(value={"Maximum reach in survival with three upgrades"})
        public int maxReachLevel3 = 200;
    }
}

