/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.compatibility;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import nl.requios.effortlessbuilding.compatibility.ActiveChiselsAndBitsProxy;
import nl.requios.effortlessbuilding.compatibility.DummyChiselsAndBitsProxy;
import nl.requios.effortlessbuilding.compatibility.IChiselsAndBitsProxy;
import nl.requios.effortlessbuilding.item.ItemRandomizerBag;

public class CompatHelper {
    @GameRegistry.ObjectHolder(value="danknull:dank_null")
    public static final Item dankNullItem = null;
    public static IChiselsAndBitsProxy chiselsAndBitsProxy;

    public static void postInit() {
        if (Loader.isModLoaded((String)"chiselsandbits")) {
            try {
                chiselsAndBitsProxy = Class.forName("nl.requios.effortlessbuilding.compatibility.ActiveChiselsAndBitsProxy").asSubclass(ActiveChiselsAndBitsProxy.class).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        } else {
            chiselsAndBitsProxy = new DummyChiselsAndBitsProxy();
        }
    }

    public static boolean isItemBlockProxy(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            return true;
        }
        if (item instanceof ItemRandomizerBag) {
            return true;
        }
        return item == dankNullItem;
    }

    public static ItemStack getItemBlockFromStack(ItemStack proxy) {
        Item proxyItem = proxy.func_77973_b();
        if (proxyItem instanceof ItemBlock) {
            return proxy;
        }
        if (proxyItem instanceof ItemRandomizerBag) {
            ItemStack itemStack = proxy;
            while (!(itemStack.func_77973_b() instanceof ItemBlock) && !itemStack.func_190926_b()) {
                if (!(itemStack.func_77973_b() instanceof ItemRandomizerBag)) continue;
                itemStack = ItemRandomizerBag.pickRandomStack(ItemRandomizerBag.getBagInventory(itemStack));
            }
            return itemStack;
        }
        if (proxyItem == dankNullItem) {
            int index = 0;
            if (proxy.func_77942_o() && proxy.func_77978_p().func_74764_b("selectedIndex")) {
                index = proxy.func_77978_p().func_74762_e("selectedIndex");
            }
            return ((IItemHandler)proxy.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(index);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getItemBlockByState(ItemStack stack, IBlockState state) {
        int index;
        Item blockItem = Item.func_150898_a((Block)state.func_177230_c());
        if (stack.func_77973_b() instanceof ItemBlock) {
            return stack;
        }
        if (stack.func_77973_b() instanceof ItemRandomizerBag) {
            IItemHandler bagInventory = ItemRandomizerBag.getBagInventory(stack);
            return ItemRandomizerBag.findStack(bagInventory, blockItem);
        }
        if (stack.func_77973_b() == dankNullItem && (index = CompatHelper.itemHandlerSlotForItem(stack, blockItem)) >= 0) {
            return ((IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(index);
        }
        return ItemStack.field_190927_a;
    }

    public static void shrinkStack(ItemStack origStack, ItemStack curStack, EntityPlayer player) {
        origStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (origStack.func_77973_b() == dankNullItem) {
            int index = CompatHelper.itemHandlerSlotForItem(origStack, curStack.func_77973_b());
            ((IItemHandler)origStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).extractItem(index, 1, false);
        } else {
            curStack.func_190918_g(1);
        }
    }

    private static int itemHandlerSlotForItem(ItemStack stack, Item blockItem) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack ref = handler.getStackInSlot(i);
            if (!(ref.func_77973_b() instanceof ItemBlock) || ref.func_77973_b() != blockItem) continue;
            return i;
        }
        return -1;
    }
}

