/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.elements;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.text.TextFormatting;

public class GuiNumberField
extends Gui {
    public int x;
    public int y;
    public int width;
    public int height;
    public int buttonWidth = 10;
    protected GuiTextField textField;
    protected GuiButton minusButton;
    protected GuiButton plusButton;
    List<String> tooltip = new ArrayList<String>();

    public GuiNumberField(int id1, int id2, int id3, FontRenderer fontRenderer, List<GuiButton> buttonList, int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.textField = new GuiTextField(id1, fontRenderer, x + this.buttonWidth + 1, y + 1, width - 2 * this.buttonWidth - 2, height - 2);
        this.minusButton = new GuiButton(id2, x, y - 1, this.buttonWidth, height + 2, "-");
        this.plusButton = new GuiButton(id3, x + width - this.buttonWidth, y - 1, this.buttonWidth, height + 2, "+");
        buttonList.add(this.minusButton);
        buttonList.add(this.plusButton);
    }

    public void setNumber(double number) {
        DecimalFormat format = new DecimalFormat("0.#");
        this.textField.func_146180_a(format.format(number));
    }

    public double getNumber() {
        if (this.textField.func_146179_b().isEmpty()) {
            return 0.0;
        }
        return Double.parseDouble(this.textField.func_146179_b());
    }

    public void setTooltip(String tooltip) {
        this.setTooltip(Arrays.asList(tooltip));
    }

    public void setTooltip(List<String> tooltip) {
        this.tooltip = tooltip;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag;
        boolean result = this.textField.func_146192_a(mouseX, mouseY, mouseButton);
        boolean bl = flag = mouseX >= this.x + this.buttonWidth && mouseX < this.x + this.width - this.buttonWidth && mouseY >= this.y && mouseY < this.y + this.height;
        if (flag && mouseButton == 1) {
            this.textField.func_146180_a("");
            this.textField.func_146195_b(true);
            result = true;
        }
        return result;
    }

    public void drawNumberField(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        this.textField.field_146210_g = this.y + 1;
        this.minusButton.field_146129_i = this.y - 1;
        this.plusButton.field_146129_i = this.y - 1;
        this.textField.func_146194_f();
        this.minusButton.func_191745_a(mc, mouseX, mouseY, partialTicks);
        this.plusButton.func_191745_a(mc, mouseX, mouseY, partialTicks);
    }

    public void drawTooltip(GuiScreen guiScreen, int mouseX, int mouseY) {
        boolean insideTextField = mouseX >= this.x + this.buttonWidth && mouseX < this.x + this.width - this.buttonWidth && mouseY >= this.y && mouseY < this.y + this.height;
        boolean insideMinusButton = mouseX >= this.x && mouseX < this.x + this.buttonWidth && mouseY >= this.y && mouseY < this.y + this.height;
        boolean insidePlusButton = mouseX >= this.x + this.width - this.buttonWidth && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
        ArrayList<String> textLines = new ArrayList<String>();
        if (insideTextField && !this.tooltip.isEmpty()) {
            textLines.addAll(this.tooltip);
        }
        if (insideMinusButton) {
            textLines.add("Hold " + TextFormatting.AQUA + "shift " + TextFormatting.RESET + "for " + TextFormatting.RED + "10");
            textLines.add("Hold " + TextFormatting.AQUA + "ctrl " + TextFormatting.RESET + "for " + TextFormatting.RED + "5");
        }
        if (insidePlusButton) {
            textLines.add("Hold " + TextFormatting.AQUA + "shift " + TextFormatting.RESET + "for " + TextFormatting.DARK_GREEN + "10");
            textLines.add("Hold " + TextFormatting.AQUA + "ctrl " + TextFormatting.RESET + "for " + TextFormatting.DARK_GREEN + "5");
        }
        guiScreen.func_146283_a(textLines, mouseX - 10, mouseY + 25);
    }

    public void actionPerformed(GuiButton button) {
        float valueChanged = 1.0f;
        if (GuiScreen.func_146271_m()) {
            valueChanged = 5.0f;
        }
        if (GuiScreen.func_146272_n()) {
            valueChanged = 10.0f;
        }
        if (button == this.minusButton) {
            this.setNumber(this.getNumber() - (double)valueChanged);
        }
        if (button == this.plusButton) {
            this.setNumber(this.getNumber() + (double)valueChanged);
        }
    }

    public void update() {
        this.textField.func_146178_a();
    }

    public void keyTyped(char typedChar, int keyCode) throws IOException {
        if (!this.textField.func_146206_l()) {
            return;
        }
        this.textField.func_146201_a(typedChar, keyCode);
    }
}

